
package com.baijia.tianxiao.sal.club.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.dal.club.dao.OrgVipScanRecordDao;
import com.baijia.tianxiao.dal.club.po.OrgVipScanRecord;
import com.baijia.tianxiao.dal.constant.DalConstant;
import com.baijia.tianxiao.sal.club.OrgVipScanRecordService;

@Service
public class OrgVipScanRecordServiceImpl implements OrgVipScanRecordService {

    @Autowired
    private OrgVipScanRecordDao orgVipScanRecordDao;

    @Override 
    public OrgVipScanRecord getLastUpgradeOrgVipScanRecord() {
        return orgVipScanRecordDao.getLastOrgVipScanRecord(DalConstant.ORDER_INFO_JIGOU_TYPE,
            DalConstant.ORDER_INFO_JIGOU_HUIYUAN_UPGRADE_SUB_TYPE);
    }

    @Override
    public List<OrgVipScanRecord> getUpgradeRecord(Integer index) {
        return orgVipScanRecordDao.getByTypes(DalConstant.ORDER_INFO_JIGOU_TYPE,
            DalConstant.ORDER_INFO_JIGOU_HUIYUAN_UPGRADE_SUB_TYPE, index);
    }

    /* (non-Javadoc)
     * @see com.baijia.tianxiao.sal.club.OrgVipScanRecordService#saveUpgradeRecord(java.lang.Integer)
     */
        
    @Override
    public void saveUpgradeRecord(OrgVipScanRecord record) {
        orgVipScanRecordDao.save(record);
    }

}
