
package com.baijia.tianxiao.sal.club.cas.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baijia.cas.ac.api.AccountApi;
import com.baijia.cas.ac.protocol.GetAccountRequest;
import com.baijia.cas.ac.protocol.GetAccountResponse;
import com.baijia.cas.ac.protocol.GetAccountsRequest;
import com.baijia.cas.ac.protocol.GetAccountsResponse;
import com.baijia.cas.ac.protocol.GetSubAccountsRequest;
import com.baijia.cas.ac.protocol.GetSubAccountsResponse;
import com.baijia.tianxiao.sal.club.cas.CasAccountApi;
import com.baijia.tianxiao.sal.club.constant.App;
import com.baijia.tianxiao.sal.club.constant.SalConstant;

@Service
public class CasAccountApiImpl implements CasAccountApi {
    
    @Autowired
    private AccountApi accountApi;
    
    @Override
    public GetSubAccountsResponse getSubAccounts() throws Exception {
        GetSubAccountsRequest acRequest = new GetSubAccountsRequest();
        acRequest.setSubRoleTag(SalConstant.CLUB_ROLE_TAG);
        acRequest.setAppId(App.JIGOU.getId());
        GetSubAccountsResponse acResponse = accountApi.getSubAccounts(acRequest);;
        return acResponse;
    }

    @Override
    public GetAccountsResponse getAccounts(List<String> orgNumberList) throws Exception {
        GetAccountsRequest acRequest = new GetAccountsRequest();
        acRequest.setAccountNames(orgNumberList);
        acRequest.setAppId(App.JIGOU.getId());
        GetAccountsResponse acResponse = accountApi.getAccounts(acRequest); // TODO Auto-generated method stub
        return acResponse;

    }

    @Override
    public GetAccountResponse getAccount(String orgNumber) throws Exception {
        GetAccountRequest acRequest = new GetAccountRequest();
        acRequest.setAccountName(orgNumber);
        acRequest.setAppId(App.JIGOU.getId());
        GetAccountResponse acResponse = accountApi.getAccount(acRequest);
        return acResponse;

    }

}

    