/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.card.service.impl;

import com.baijia.tianxiao.dal.signup.dao.TxTimescardRuleDao;
import com.baijia.tianxiao.dal.signup.po.TxTimescardRule;
import com.baijia.tianxiao.sal.card.dto.TimescardRuleDto;
import com.baijia.tianxiao.sal.card.service.TxTimescardRuleService;
import java.util.Date;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TxTimescardRuleServiceImpl
implements TxTimescardRuleService {
    private static final Logger log = LoggerFactory.getLogger(TxTimescardRuleServiceImpl.class);
    @Autowired
    private TxTimescardRuleDao txTimescardRuleDao;

    @Override
    @Transactional(readOnly=true)
    public TimescardRuleDto getRuleByOrgId(@NonNull Long orgId) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        TimescardRuleDto result = new TimescardRuleDto();
        TxTimescardRule rule = this.txTimescardRuleDao.getByOrgId(orgId);
        if (null != rule) {
            result.setMaxDeferTimes(rule.getMaxDeferTimes());
            result.setMaxTotalDeferDays(rule.getMaxTotalDeferDays());
            result.setMinDeferDaysEachtime(rule.getMinDeferDaysEachtime());
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateOrSave(@NonNull Long orgId, @NonNull TimescardRuleDto ruleDto) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        if (ruleDto == null) {
            throw new NullPointerException("ruleDto");
        }
        ruleDto.valide();
        if (ruleDto.ignore()) {
            return;
        }
        TxTimescardRule rule = this.txTimescardRuleDao.getByOrgId(orgId);
        if (null != rule) {
            rule.setMaxDeferTimes(ruleDto.getMaxDeferTimes());
            rule.setMaxTotalDeferDays(ruleDto.getMaxTotalDeferDays());
            rule.setMinDeferDaysEachtime(ruleDto.getMinDeferDaysEachtime());
            rule.setUpdateTime(new Date());
            this.txTimescardRuleDao.update((Object)rule, new String[0]);
        } else {
            rule = new TxTimescardRule();
            rule.setOrgId(orgId);
            rule.setMaxDeferTimes(ruleDto.getMaxDeferTimes());
            rule.setMaxTotalDeferDays(ruleDto.getMaxTotalDeferDays());
            rule.setMinDeferDaysEachtime(ruleDto.getMinDeferDaysEachtime());
            rule.setCreateTime(new Date());
            rule.setUpdateTime(rule.getCreateTime());
            this.txTimescardRuleDao.save((Object)rule, new String[0]);
        }
    }
}

