package com.baijia.tianxiao.sal.card.service.impl;

import com.baijia.tianxiao.dal.signup.dao.TxTimescardRuleDao;
import com.baijia.tianxiao.dal.signup.po.TxTimescardRule;
import com.baijia.tianxiao.sal.card.dto.TimescardRuleDto;
import com.baijia.tianxiao.sal.card.service.TxTimescardRuleService;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;

import lombok.NonNull;
import lombok.extern.slf4j.Slf4j;

/**
 * @author weihongyan
 * @implNote <(▰˘◡˘▰)>
 * @since 24/07/2017 11:11 AM
 */
@Slf4j
@Service
public class TxTimescardRuleServiceImpl implements TxTimescardRuleService {
    @Autowired
    private TxTimescardRuleDao txTimescardRuleDao;

    @Transactional(readOnly = true)
    public TimescardRuleDto getRuleByOrgId(@NonNull Long orgId) {
        TimescardRuleDto result = new TimescardRuleDto();
        TxTimescardRule rule = txTimescardRuleDao.getByOrgId(orgId);
        if (null != rule) {
            result.setMaxDeferTimes(rule.getMaxDeferTimes());
            result.setMaxTotalDeferDays(rule.getMaxTotalDeferDays());
            result.setMinDeferDaysEachtime(rule.getMinDeferDaysEachtime());
        }
        return result;
    }

    @Transactional(rollbackFor = Exception.class)
    public void updateOrSave(@NonNull Long orgId, @NonNull TimescardRuleDto ruleDto) {
        ruleDto.valide();
        if (ruleDto.ignore()) { // 无变更
            return;
        }
        TxTimescardRule rule = txTimescardRuleDao.getByOrgId(orgId);
        if (null != rule) {
            rule.setMaxDeferTimes(ruleDto.getMaxDeferTimes());
            rule.setMaxTotalDeferDays(ruleDto.getMaxTotalDeferDays());
            rule.setMinDeferDaysEachtime(ruleDto.getMinDeferDaysEachtime());
            rule.setUpdateTime(new Date());
            this.txTimescardRuleDao.update(rule);
        } else {
            rule = new TxTimescardRule();
            rule.setOrgId(orgId);
            rule.setMaxDeferTimes(ruleDto.getMaxDeferTimes());
            rule.setMaxTotalDeferDays(ruleDto.getMaxTotalDeferDays());
            rule.setMinDeferDaysEachtime(ruleDto.getMinDeferDaysEachtime());
            rule.setCreateTime(new Date());
            rule.setUpdateTime(rule.getCreateTime());
            this.txTimescardRuleDao.save(rule);
        }
    }
}
