package com.baijia.tianxiao.sal.card.dto;

import com.google.common.base.Preconditions;

import lombok.Data;

/**
 * @author weihongyan
 * @implNote <(▰˘◡˘▰)> 有默认值的
 * @since 24/07/2017 10:13 AM
 */
@Data
public class TimescardRuleDto {
    private Integer maxDeferTimes = 3;
    private Integer maxTotalDeferDays = 60;
    private Integer minDeferDaysEachtime = 7;

    public void valide() {
        Preconditions.checkArgument(null != maxDeferTimes && maxDeferTimes >= 0, "maxDeferTimes error!");
        Preconditions.checkArgument(null != maxTotalDeferDays && maxTotalDeferDays >= 0, "maxTotalDeferDays error!");
        Preconditions.checkArgument(null != minDeferDaysEachtime && minDeferDaysEachtime >= 0,
            "minDeferDaysEachtime error!");
        Preconditions.checkArgument(maxTotalDeferDays >= maxDeferTimes * minDeferDaysEachtime,
            "可延期总天数 不能小于  最大可延期次数*每次延期的最短天数");
    }

    public boolean ignore() {
        return this.equals(new TimescardRuleDto());
    }
}