/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.callservice.ronglian;

import com.baijia.tianxiao.sal.callservice.ronglian.utils.CcopHttpClient;
import com.baijia.tianxiao.sal.callservice.ronglian.utils.DateUtil;
import com.baijia.tianxiao.sal.callservice.ronglian.utils.EncryptUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.AbstractHttpMessage;
import org.apache.http.util.EntityUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CCPRestSDK {
    private static final Logger log = LoggerFactory.getLogger(CCPRestSDK.class);
    private static final int Request_Get = 0;
    private static final int Request_Post = 1;
    private static final String Account_Info = "AccountInfo";
    private static final String Create_SubAccount = "SubAccounts";
    private static final String Get_SubAccounts = "GetSubAccounts";
    private static final String Query_SubAccountByName = "QuerySubAccountByName";
    private static final String SMSMessages = "SMS/Messages";
    private static final String TemplateSMS = "SMS/TemplateSMS";
    private static final String Query_SMSTemplate = "SMS/QuerySMSTemplate";
    private static final String Call_back = "Calls/Callback";
    private static final String LandingCalls = "Calls/LandingCalls";
    private static final String VoiceVerify = "Calls/VoiceVerify";
    private static final String IvrDial = "ivr/dial";
    private static final String BillRecords = "BillRecords";
    private static final String callCancel = "Calls/CallCancel";
    private static final String queryCallState = "ivr/call";
    private static final String callResult = "CallResult";
    private static final String mediaFileUpload = "Calls/MediaFileUpload";
    private String SERVER_IP;
    private String SERVER_PORT;
    private String ACCOUNT_SID;
    private String ACCOUNT_TOKEN;
    private String SUBACCOUNT_SID;
    private String SUBACCOUNT_Token;
    private String VOIP_ACCOUNT;
    private String VOIP_TOKEN;
    public String App_ID;
    private BodyType BODY_TYPE = BodyType.Type_JSON;
    public String Callsid;
    public String Filename;

    public void init(String serverIP, String serverPort) {
        if (this.isEmpty(serverIP) || this.isEmpty(serverPort)) {
            log.error("\u521d\u59cb\u5316\u5f02\u5e38:serverIP\u6216serverPort\u4e3a\u7a7a");
            throw new IllegalArgumentException("\u5fc5\u9009\u53c2\u6570:" + (this.isEmpty(serverIP) ? " \u670d\u52a1\u5668\u5730\u5740 " : "") + (this.isEmpty(serverPort) ? " \u670d\u52a1\u5668\u7aef\u53e3 " : "") + "\u4e3a\u7a7a");
        }
        this.SERVER_IP = serverIP;
        this.SERVER_PORT = serverPort;
    }

    public void setAccount(String accountSid, String accountToken) {
        if (this.isEmpty(accountSid) || this.isEmpty(accountToken)) {
            log.error("\u521d\u59cb\u5316\u5f02\u5e38:accountSid\u6216accountToken\u4e3a\u7a7a");
            throw new IllegalArgumentException("\u5fc5\u9009\u53c2\u6570:" + (this.isEmpty(accountSid) ? " \u4e3b\u5e10\u53f7" : "") + (this.isEmpty(accountToken) ? " \u4e3b\u5e10\u53f7TOKEN " : "") + "\u4e3a\u7a7a");
        }
        this.ACCOUNT_SID = accountSid;
        this.ACCOUNT_TOKEN = accountToken;
    }

    public void setSubAccount(String subAccountSid, String subAccountToken) {
        if (this.isEmpty(subAccountSid) || this.isEmpty(subAccountToken)) {
            log.error("\u521d\u59cb\u5316\u5f02\u5e38:subAccountSid\u6216subAccountToken\u4e3a\u7a7a");
            throw new IllegalArgumentException("\u5fc5\u9009\u53c2\u6570:" + (this.isEmpty(subAccountSid) ? " \u5b50\u5e10\u53f7" : "") + (this.isEmpty(subAccountToken) ? " \u5b50\u5e10\u53f7TOKEN " : "") + "\u4e3a\u7a7a");
        }
        this.SUBACCOUNT_SID = subAccountSid;
        this.SUBACCOUNT_Token = subAccountToken;
    }

    public void setAppId(String appId) {
        if (this.isEmpty(appId)) {
            log.error("\u521d\u59cb\u5316\u5f02\u5e38:appId\u4e3a\u7a7a");
            throw new IllegalArgumentException("\u5fc5\u9009\u53c2\u6570: \u5e94\u7528Id \u4e3a\u7a7a");
        }
        this.App_ID = appId;
    }

    public void setVoIPAccount(String voIPAccount, String voIPPassWord) {
        if (this.isEmpty(voIPAccount) || this.isEmpty(voIPPassWord)) {
            log.error("\u521d\u59cb\u5316\u5f02\u5e38:voIPAccount\u6216voIPPassWord\u4e3a\u7a7a");
            throw new IllegalArgumentException("\u5fc5\u9009\u53c2\u6570:" + (this.isEmpty(voIPAccount) ? " VoIP\u5e10\u53f7" : "") + (this.isEmpty(voIPPassWord) ? " VoIP\u5bc6\u7801 " : "") + "\u4e3a\u7a7a");
        }
        this.VOIP_ACCOUNT = voIPAccount;
        this.VOIP_TOKEN = voIPPassWord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, Object> billRecords(String date, String keywords) {
        HashMap<String, Object> validate = this.accountValidate();
        if (validate != null) {
            return validate;
        }
        if (this.isEmpty(date)) {
            log.error("\u5fc5\u9009\u53c2\u6570: \u65e5\u671f  \u4e3a\u7a7a");
            throw new IllegalArgumentException("\u5fc5\u9009\u53c2\u6570: \u65e5\u671f  \u4e3a\u7a7a");
        }
        CcopHttpClient chc = new CcopHttpClient();
        DefaultHttpClient httpclient = null;
        try {
            httpclient = chc.registerSSL(this.SERVER_IP, "TLS", Integer.parseInt(this.SERVER_PORT), "https");
        }
        catch (Exception e1) {
            e1.printStackTrace();
            log.error(e1.getMessage());
            throw new RuntimeException("\u521d\u59cb\u5316httpclient\u5f02\u5e38" + e1.getMessage());
        }
        String result = "";
        try {
            HttpPost httppost = (HttpPost)this.getHttpRequestBase(1, BillRecords);
            String requsetbody = "";
            if (this.BODY_TYPE == BodyType.Type_JSON) {
                JsonObject json = new JsonObject();
                json.addProperty("appId", this.App_ID);
                json.addProperty("date", date);
                if (!this.isEmpty(keywords)) {
                    json.addProperty("keywords", keywords);
                }
                requsetbody = json.toString();
            } else {
                StringBuilder sb = new StringBuilder("<?xml version='1.0' encoding='utf-8'?><BillRecords>");
                sb.append("<appId>").append(this.App_ID).append("</appId>").append("<date>").append(date).append("</date>");
                if (!this.isEmpty(keywords)) {
                    sb.append("<keywords>").append(keywords).append("</keywords>");
                }
                sb.append("</BillRecords>").toString();
                requsetbody = sb.toString();
            }
            log.info("billRecords Request body = : " + requsetbody);
            BasicHttpEntity requestBody = new BasicHttpEntity();
            requestBody.setContent((InputStream)new ByteArrayInputStream(requsetbody.getBytes("UTF-8")));
            requestBody.setContentLength((long)requsetbody.getBytes("UTF-8").length);
            httppost.setEntity((HttpEntity)requestBody);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httppost);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            }
            EntityUtils.consume((HttpEntity)entity);
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error(e.getMessage());
            HashMap<String, Object> hashMap = this.getMyError("172001", "\u7f51\u7edc\u9519\u8bef");
            return hashMap;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            HashMap<String, Object> hashMap = this.getMyError("172002", "\u65e0\u8fd4\u56de");
            return hashMap;
        }
        finally {
            if (httpclient != null) {
                httpclient.getConnectionManager().shutdown();
            }
        }
        log.info("billRecords response body = " + result);
        try {
            if (this.BODY_TYPE == BodyType.Type_JSON) {
                return this.jsonToMap(result);
            }
            return this.xmlToMap(result);
        }
        catch (Exception e) {
            return this.getMyError("172003", "\u8fd4\u56de\u5305\u4f53\u9519\u8bef");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, Object> ivrDial(String number, String userdata, boolean record) {
        HashMap<String, Object> validate = this.accountValidate();
        if (validate != null) {
            return validate;
        }
        if (this.isEmpty(number)) {
            log.error("\u5fc5\u9009\u53c2\u6570: \u5f85\u547c\u53eb\u53f7\u7801   \u4e3a\u7a7a");
            throw new IllegalArgumentException("\u5fc5\u9009\u53c2\u6570: \u5f85\u547c\u53eb\u53f7\u7801   \u4e3a\u7a7a");
        }
        CcopHttpClient chc = new CcopHttpClient();
        DefaultHttpClient httpclient = null;
        try {
            httpclient = chc.registerSSL(this.SERVER_IP, "TLS", Integer.parseInt(this.SERVER_PORT), "https");
        }
        catch (Exception e1) {
            e1.printStackTrace();
            throw new RuntimeException("\u521d\u59cb\u5316httpclient\u5f02\u5e38" + e1.getMessage());
        }
        String result = "";
        try {
            HttpPost httppost = (HttpPost)this.getHttpRequestBase(1, IvrDial);
            String requsetbody = "";
            StringBuilder sb = new StringBuilder("<?xml version='1.0' encoding='utf-8'?><Request>");
            sb.append("<Appid>").append(this.App_ID).append("</Appid>").append("<Dial number=").append("\"").append(number).append("\"");
            if (record) {
                sb.append(" record=").append("\"").append(record).append("\"");
            }
            if (userdata != null) {
                sb.append(" userdata=").append("\"").append(userdata).append("\"");
            }
            sb.append("></Dial></Request>").toString();
            requsetbody = sb.toString();
            log.info("ivrDial Request body = : " + requsetbody);
            BasicHttpEntity requestBody = new BasicHttpEntity();
            requestBody.setContent((InputStream)new ByteArrayInputStream(requsetbody.getBytes("UTF-8")));
            requestBody.setContentLength((long)requsetbody.getBytes("UTF-8").length);
            httppost.setEntity((HttpEntity)requestBody);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httppost);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            }
            EntityUtils.consume((HttpEntity)entity);
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error(e.getMessage());
            HashMap<String, Object> hashMap = this.getMyError("172001", "\u7f51\u7edc\u9519\u8bef");
            return hashMap;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            HashMap<String, Object> hashMap = this.getMyError("172002", "\u65e0\u8fd4\u56de");
            return hashMap;
        }
        finally {
            if (httpclient != null) {
                httpclient.getConnectionManager().shutdown();
            }
        }
        log.info("ivrDial response body = " + result);
        try {
            return this.xmlToMap(result);
        }
        catch (Exception e) {
            return this.getMyError("172003", "\u8fd4\u56de\u5305\u4f53\u9519\u8bef");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, Object> voiceVerify(String verifyCode, String to, String displayNum, String playTimes, String respUrl, String lang, String userData) {
        HashMap<String, Object> validate = this.accountValidate();
        if (validate != null) {
            return validate;
        }
        if (this.isEmpty(verifyCode) || this.isEmpty(to)) {
            throw new IllegalArgumentException("\u5fc5\u9009\u53c2\u6570:" + (this.isEmpty(verifyCode) ? " \u9a8c\u8bc1\u7801\u5185\u5bb9 " : "") + (this.isEmpty(to) ? " \u63a5\u6536\u53f7\u7801 " : "") + "\u4e3a\u7a7a");
        }
        CcopHttpClient chc = new CcopHttpClient();
        DefaultHttpClient httpclient = null;
        try {
            httpclient = chc.registerSSL(this.SERVER_IP, "TLS", Integer.parseInt(this.SERVER_PORT), "https");
        }
        catch (Exception e1) {
            e1.printStackTrace();
            throw new RuntimeException("\u521d\u59cb\u5316httpclient\u5f02\u5e38" + e1.getMessage());
        }
        String result = "";
        try {
            HttpPost httppost = (HttpPost)this.getHttpRequestBase(1, VoiceVerify);
            String requsetbody = "";
            if (this.BODY_TYPE == BodyType.Type_JSON) {
                JsonObject json = new JsonObject();
                json.addProperty("appId", this.App_ID);
                json.addProperty("verifyCode", verifyCode);
                json.addProperty("to", to);
                if (!this.isEmpty(displayNum)) {
                    json.addProperty("displayNum", displayNum);
                }
                if (!this.isEmpty(playTimes)) {
                    json.addProperty("playTimes", playTimes);
                }
                if (!this.isEmpty(respUrl)) {
                    json.addProperty("respUrl", respUrl);
                }
                if (!this.isEmpty(lang)) {
                    json.addProperty("lang", lang);
                }
                if (!this.isEmpty(userData)) {
                    json.addProperty("userData", userData);
                }
                requsetbody = json.toString();
            } else {
                StringBuilder sb = new StringBuilder("<?xml version='1.0' encoding='utf-8'?><VoiceVerify>");
                sb.append("<appId>").append(this.App_ID).append("</appId>").append("<verifyCode>").append(verifyCode).append("</verifyCode>").append("<to>").append(to).append("</to>");
                if (!this.isEmpty(displayNum)) {
                    sb.append("<displayNum>").append(displayNum).append("</displayNum>");
                }
                if (!this.isEmpty(playTimes)) {
                    sb.append("<playTimes>").append(playTimes).append("</playTimes>");
                }
                if (!this.isEmpty(respUrl)) {
                    sb.append("<respUrl>").append(respUrl).append("</respUrl>");
                }
                if (!this.isEmpty(lang)) {
                    sb.append("<lang>").append(lang).append("</lang>");
                }
                if (!this.isEmpty(userData)) {
                    sb.append("<userData>").append(userData).append("</userData>");
                }
                sb.append("</VoiceVerify>").toString();
                requsetbody = sb.toString();
            }
            log.info("voiceVerify Request body = : " + requsetbody);
            BasicHttpEntity requestBody = new BasicHttpEntity();
            requestBody.setContent((InputStream)new ByteArrayInputStream(requsetbody.getBytes("UTF-8")));
            requestBody.setContentLength((long)requsetbody.getBytes("UTF-8").length);
            httppost.setEntity((HttpEntity)requestBody);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httppost);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            }
            EntityUtils.consume((HttpEntity)entity);
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error(e.getMessage());
            HashMap<String, Object> hashMap = this.getMyError("172001", "\u7f51\u7edc\u9519\u8bef");
            return hashMap;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            HashMap<String, Object> hashMap = this.getMyError("172002", "\u65e0\u8fd4\u56de");
            return hashMap;
        }
        finally {
            if (httpclient != null) {
                httpclient.getConnectionManager().shutdown();
            }
        }
        log.info("voiceVerify response body = " + result);
        try {
            if (this.BODY_TYPE == BodyType.Type_JSON) {
                return this.jsonToMap(result);
            }
            return this.xmlToMap(result);
        }
        catch (Exception e) {
            return this.getMyError("172003", "\u8fd4\u56de\u5305\u4f53\u9519\u8bef");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, Object> landingCall(String to, String mediaName, String mediaTxt, String displayNum, String playTimes, int type, String respUrl, String userData, String maxCallTime, String speed, String volume, String pitch, String bgsound) {
        HashMap<String, Object> validate = this.accountValidate();
        if (validate != null) {
            return validate;
        }
        if (this.isEmpty(to)) {
            throw new IllegalArgumentException("\u5fc5\u9009\u53c2\u6570:" + (this.isEmpty(to) ? " \u88ab\u53eb\u53f7\u7801 " : "") + "\u4e3a\u7a7a");
        }
        if (this.isEmpty(mediaName) && this.isEmpty(mediaTxt)) {
            throw new IllegalArgumentException("\u53c2\u6570\u8bed\u97f3\u6587\u4ef6\u540d\u79f0\u548c\u53c2\u6570\u8bed\u97f3\u6587\u672c\u5185\u5bb9\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        CcopHttpClient chc = new CcopHttpClient();
        DefaultHttpClient httpclient = null;
        try {
            httpclient = chc.registerSSL(this.SERVER_IP, "TLS", Integer.parseInt(this.SERVER_PORT), "https");
        }
        catch (Exception e1) {
            e1.printStackTrace();
            throw new RuntimeException("\u521d\u59cb\u5316httpclient\u5f02\u5e38" + e1.getMessage());
        }
        String result = "";
        try {
            HttpPost httppost = (HttpPost)this.getHttpRequestBase(1, LandingCalls);
            String requsetbody = "";
            if (this.BODY_TYPE == BodyType.Type_JSON) {
                JsonObject json = new JsonObject();
                json.addProperty("appId", this.App_ID);
                json.addProperty("to", to);
                if (!this.isEmpty(mediaName)) {
                    json.addProperty("mediaName", mediaName);
                }
                if (type == 1) {
                    json.addProperty("mediaNameType", "1");
                }
                if (!this.isEmpty(mediaTxt)) {
                    json.addProperty("mediaTxt", mediaTxt);
                }
                if (!this.isEmpty(displayNum)) {
                    json.addProperty("displayNum", displayNum);
                }
                if (!this.isEmpty(playTimes)) {
                    json.addProperty("playTimes", playTimes);
                }
                if (!this.isEmpty(respUrl)) {
                    json.addProperty("respUrl", respUrl);
                }
                if (!this.isEmpty(userData)) {
                    json.addProperty("userData", userData);
                }
                if (!this.isEmpty(maxCallTime)) {
                    json.addProperty("maxCallTime", maxCallTime);
                }
                if (!this.isEmpty(speed)) {
                    json.addProperty("speed", speed);
                }
                if (!this.isEmpty(volume)) {
                    json.addProperty("volume", volume);
                }
                if (!this.isEmpty(pitch)) {
                    json.addProperty("pitch", pitch);
                }
                if (!this.isEmpty(bgsound)) {
                    json.addProperty("bgsound", bgsound);
                }
                requsetbody = json.toString();
            } else {
                StringBuilder sb = new StringBuilder("<?xml version='1.0' encoding='utf-8'?><LandingCall>");
                sb.append("<appId>").append(this.App_ID).append("</appId>").append("<to>").append(to).append("</to>");
                if (!this.isEmpty(mediaName) && type == 1) {
                    sb.append("<mediaName type=\"1\">").append(mediaName).append("</mediaName>");
                } else if (!this.isEmpty(mediaName)) {
                    sb.append("<mediaName>").append(mediaName).append("</mediaName>");
                }
                if (!this.isEmpty(mediaTxt)) {
                    sb.append("<mediaTxt>").append(mediaTxt).append("</mediaTxt>");
                }
                if (!this.isEmpty(displayNum)) {
                    sb.append("<displayNum>").append(displayNum).append("</displayNum>");
                }
                if (!this.isEmpty(playTimes)) {
                    sb.append("<playTimes>").append(playTimes).append("</playTimes>");
                }
                if (!this.isEmpty(respUrl)) {
                    sb.append("<respUrl>").append(respUrl).append("</respUrl>");
                }
                if (!this.isEmpty(userData)) {
                    sb.append("<userData>").append(userData).append("</userData>");
                }
                if (!this.isEmpty(maxCallTime)) {
                    sb.append("<maxCallTime>").append(maxCallTime).append("</maxCallTime>");
                }
                if (!this.isEmpty(speed)) {
                    sb.append("<speed>").append(speed).append("</speed>");
                }
                if (!this.isEmpty(volume)) {
                    sb.append("<volume>").append(volume).append("</volume>");
                }
                if (!this.isEmpty(pitch)) {
                    sb.append("<pitch>").append(pitch).append("</pitch>");
                }
                if (!this.isEmpty(bgsound)) {
                    sb.append("<bgsound>").append(bgsound).append("</bgsound>");
                }
                sb.append("</LandingCall>").toString();
                requsetbody = sb.toString();
            }
            log.info("landingCalls Request body = : " + requsetbody);
            BasicHttpEntity requestBody = new BasicHttpEntity();
            requestBody.setContent((InputStream)new ByteArrayInputStream(requsetbody.getBytes("UTF-8")));
            requestBody.setContentLength((long)requsetbody.getBytes("UTF-8").length);
            httppost.setEntity((HttpEntity)requestBody);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httppost);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            }
            EntityUtils.consume((HttpEntity)entity);
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error(e.getMessage());
            HashMap<String, Object> hashMap = this.getMyError("172001", "\u7f51\u7edc\u9519\u8bef");
            return hashMap;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            HashMap<String, Object> hashMap = this.getMyError("172002", "\u65e0\u8fd4\u56de");
            return hashMap;
        }
        finally {
            if (httpclient != null) {
                httpclient.getConnectionManager().shutdown();
            }
        }
        log.info("landingCall response body = " + result);
        try {
            if (this.BODY_TYPE == BodyType.Type_JSON) {
                return this.jsonToMap(result);
            }
            return this.xmlToMap(result);
        }
        catch (Exception e) {
            return this.getMyError("172003", "\u8fd4\u56de\u5305\u4f53\u9519\u8bef");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, Object> callback(String from, String to, String customerSerNum, String fromSerNum, String promptTone, String alwaysPlay, String terminalDtmf, String userData, String maxCallTime, String hangupCdrUrl, String needBothCdr, String needRecord, String countDownTime, String countDownPrompt) {
        HashMap<String, Object> subAccountValidate = this.subAccountValidate();
        if (subAccountValidate != null) {
            return subAccountValidate;
        }
        if (this.isEmpty(from) || this.isEmpty(to)) {
            log.error("\u5fc5\u9009\u53c2\u6570:" + (this.isEmpty(from) ? " \u4e3b\u53eb\u53f7\u7801 " : "") + (this.isEmpty(to) ? " \u88ab\u53eb\u53f7\u7801 " : "") + "\u4e3a\u7a7a");
            throw new IllegalArgumentException("\u5fc5\u9009\u53c2\u6570:" + (this.isEmpty(from) ? " \u4e3b\u53eb\u53f7\u7801 " : "") + (this.isEmpty(to) ? " \u88ab\u53eb\u53f7\u7801 " : "") + "\u4e3a\u7a7a");
        }
        CcopHttpClient chc = new CcopHttpClient();
        DefaultHttpClient httpclient = null;
        try {
            httpclient = chc.registerSSL(this.SERVER_IP, "TLS", Integer.parseInt(this.SERVER_PORT), "https");
        }
        catch (Exception e1) {
            e1.printStackTrace();
            throw new RuntimeException("\u521d\u59cb\u5316httpclient\u5f02\u5e38" + e1.getMessage());
        }
        String result = "";
        try {
            HttpPost httppost = (HttpPost)this.getHttpRequestBase(1, Call_back, AccountType.SubAccounts);
            String requsetbody = "";
            if (this.BODY_TYPE == BodyType.Type_JSON) {
                JsonObject json = new JsonObject();
                json.addProperty("from", from);
                json.addProperty("to", to);
                if (!this.isEmpty(customerSerNum)) {
                    json.addProperty("customerSerNum", customerSerNum);
                }
                if (!this.isEmpty(fromSerNum)) {
                    json.addProperty("fromSerNum", fromSerNum);
                }
                if (!this.isEmpty(promptTone)) {
                    json.addProperty("promptTone", promptTone);
                }
                if (!this.isEmpty(userData)) {
                    json.addProperty("userData", userData);
                }
                if (!this.isEmpty(maxCallTime)) {
                    json.addProperty("maxCallTime", maxCallTime);
                }
                if (!this.isEmpty(hangupCdrUrl)) {
                    json.addProperty("hangupCdrUrl", hangupCdrUrl);
                }
                if (!this.isEmpty(terminalDtmf)) {
                    json.addProperty("terminalDtmf", terminalDtmf);
                }
                if (!this.isEmpty(alwaysPlay)) {
                    json.addProperty("alwaysPlay", alwaysPlay);
                }
                if (!this.isEmpty(needBothCdr)) {
                    json.addProperty("needBothCdr", needBothCdr);
                }
                if (!this.isEmpty(needRecord)) {
                    json.addProperty("needRecord", needRecord);
                }
                if (!this.isEmpty(countDownTime)) {
                    json.addProperty("countDownTime", countDownTime);
                }
                if (!this.isEmpty(countDownPrompt)) {
                    json.addProperty("countDownPrompt", countDownPrompt);
                }
                json.addProperty("recordPoint", "1");
                json.addProperty("forceDisplayType", "0");
                json.addProperty("cbContenType", "json");
                requsetbody = json.toString();
            } else {
                StringBuilder sb = new StringBuilder("<?xml version='1.0' encoding='utf-8'?><CallBack>");
                sb.append("<from>").append(from).append("</from>").append("<to>").append(to).append("</to>");
                if (!this.isEmpty(customerSerNum)) {
                    sb.append("<customerSerNum>").append(customerSerNum).append("</customerSerNum>");
                }
                if (!this.isEmpty(fromSerNum)) {
                    sb.append("<fromSerNum>").append(fromSerNum).append("</fromSerNum>");
                }
                if (!this.isEmpty(promptTone)) {
                    sb.append("<promptTone>").append(promptTone).append("</promptTone>");
                }
                if (!this.isEmpty(userData)) {
                    sb.append("<userData>").append(userData).append("</userData>");
                }
                if (!this.isEmpty(maxCallTime)) {
                    sb.append("<maxCallTime>").append(maxCallTime).append("</maxCallTime>");
                }
                if (!this.isEmpty(hangupCdrUrl)) {
                    sb.append("<hangupCdrUrl>").append(hangupCdrUrl).append("</hangupCdrUrl>");
                }
                if (!this.isEmpty(alwaysPlay)) {
                    sb.append("<alwaysPlay>").append(alwaysPlay).append("</alwaysPlay>");
                }
                if (!this.isEmpty(terminalDtmf)) {
                    sb.append("<terminalDtmf>").append(terminalDtmf).append("</terminalDtmf>");
                }
                if (!this.isEmpty(needBothCdr)) {
                    sb.append("<needBothCdr>").append(needBothCdr).append("</needBothCdr>");
                }
                if (!this.isEmpty(needRecord)) {
                    sb.append("<needRecord>").append(needRecord).append("</needRecord>");
                }
                if (!this.isEmpty(countDownTime)) {
                    sb.append("<countDownTime>").append(countDownTime).append("</countDownTime>");
                }
                if (!this.isEmpty(countDownPrompt)) {
                    sb.append("<countDownPrompt>").append(countDownPrompt).append("</countDownPrompt>");
                }
                sb.append("</CallBack>").toString();
                requsetbody = sb.toString();
            }
            log.info("Callback Request body =  " + requsetbody);
            BasicHttpEntity requestBody = new BasicHttpEntity();
            requestBody.setContent((InputStream)new ByteArrayInputStream(requsetbody.getBytes("UTF-8")));
            requestBody.setContentLength((long)requsetbody.getBytes("UTF-8").length);
            httppost.setEntity((HttpEntity)requestBody);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httppost);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            }
            EntityUtils.consume((HttpEntity)entity);
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error(e.getMessage());
            HashMap<String, Object> hashMap = this.getMyError("172001", "\u7f51\u7edc\u9519\u8bef");
            return hashMap;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            HashMap<String, Object> hashMap = this.getMyError("172002", "\u65e0\u8fd4\u56de");
            return hashMap;
        }
        finally {
            if (httpclient != null) {
                httpclient.getConnectionManager().shutdown();
            }
        }
        log.info("callback response body = " + result);
        try {
            if (this.BODY_TYPE == BodyType.Type_JSON) {
                return this.jsonToMap(result);
            }
            return this.xmlToMap(result);
        }
        catch (Exception e) {
            return this.getMyError("172003", "\u8fd4\u56de\u5305\u4f53\u9519\u8bef");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, Object> sendTemplateSMS(String to, String templateId, String[] datas) {
        HashMap<String, Object> validate = this.accountValidate();
        if (validate != null) {
            return validate;
        }
        if (this.isEmpty(to) || this.isEmpty(this.App_ID) || this.isEmpty(templateId)) {
            throw new IllegalArgumentException("\u5fc5\u9009\u53c2\u6570:" + (this.isEmpty(to) ? " \u624b\u673a\u53f7\u7801 " : "") + (this.isEmpty(templateId) ? " \u6a21\u677fId " : "") + "\u4e3a\u7a7a");
        }
        CcopHttpClient chc = new CcopHttpClient();
        DefaultHttpClient httpclient = null;
        try {
            httpclient = chc.registerSSL(this.SERVER_IP, "TLS", Integer.parseInt(this.SERVER_PORT), "https");
        }
        catch (Exception e1) {
            e1.printStackTrace();
            throw new RuntimeException("\u521d\u59cb\u5316httpclient\u5f02\u5e38" + e1.getMessage());
        }
        String result = "";
        try {
            HttpPost httppost = (HttpPost)this.getHttpRequestBase(1, TemplateSMS);
            String requsetbody = "";
            if (this.BODY_TYPE == BodyType.Type_JSON) {
                JsonObject json = new JsonObject();
                json.addProperty("appId", this.App_ID);
                json.addProperty("to", to);
                json.addProperty("templateId", templateId);
                if (datas != null) {
                    String[] sb = new StringBuilder("[");
                    for (String s : datas) {
                        sb.append("\"" + s + "\"" + ",");
                    }
                    sb.replace(sb.length() - 1, sb.length(), "]");
                    JsonParser parser = new JsonParser();
                    JsonArray Jarray = parser.parse(sb.toString()).getAsJsonArray();
                    json.add("datas", (JsonElement)Jarray);
                }
                requsetbody = json.toString();
            } else {
                StringBuilder sb = new StringBuilder("<?xml version='1.0' encoding='utf-8'?><TemplateSMS>");
                sb.append("<appId>").append(this.App_ID).append("</appId>").append("<to>").append(to).append("</to>").append("<templateId>").append(templateId).append("</templateId>");
                if (datas != null) {
                    sb.append("<datas>");
                    for (String s : datas) {
                        sb.append("<data>").append(s).append("</data>");
                    }
                    sb.append("</datas>");
                }
                sb.append("</TemplateSMS>").toString();
                requsetbody = sb.toString();
            }
            log.info("sendTemplateSMS Request body =  " + requsetbody);
            BasicHttpEntity requestBody = new BasicHttpEntity();
            requestBody.setContent((InputStream)new ByteArrayInputStream(requsetbody.getBytes("UTF-8")));
            requestBody.setContentLength((long)requsetbody.getBytes("UTF-8").length);
            httppost.setEntity((HttpEntity)requestBody);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httppost);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            }
            EntityUtils.consume((HttpEntity)entity);
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error(e.getMessage());
            HashMap<String, Object> hashMap = this.getMyError("172001", "\u7f51\u7edc\u9519\u8bef");
            return hashMap;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            HashMap<String, Object> hashMap = this.getMyError("172002", "\u65e0\u8fd4\u56de");
            return hashMap;
        }
        finally {
            if (httpclient != null) {
                httpclient.getConnectionManager().shutdown();
            }
        }
        log.info("sendTemplateSMS response body = " + result);
        try {
            if (this.BODY_TYPE == BodyType.Type_JSON) {
                return this.jsonToMap(result);
            }
            return this.xmlToMap(result);
        }
        catch (Exception e) {
            return this.getMyError("172003", "\u8fd4\u56de\u5305\u4f53\u9519\u8bef");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, Object> querySubAccount(String friendlyName) {
        HashMap<String, Object> validate = this.accountValidate();
        if (validate != null) {
            return validate;
        }
        if (this.isEmpty(friendlyName)) {
            log.error("\u5fc5\u9009\u53c2\u6570: \u5b50\u5e10\u53f7\u540d\u79f0 \u4e3a\u7a7a");
            throw new IllegalArgumentException("\u5fc5\u9009\u53c2\u6570: \u5b50\u5e10\u53f7\u540d\u79f0 \u4e3a\u7a7a");
        }
        CcopHttpClient chc = new CcopHttpClient();
        DefaultHttpClient httpclient = null;
        try {
            httpclient = chc.registerSSL(this.SERVER_IP, "TLS", Integer.parseInt(this.SERVER_PORT), "https");
        }
        catch (Exception e1) {
            e1.printStackTrace();
            throw new RuntimeException("\u521d\u59cb\u5316httpclient\u5f02\u5e38" + e1.getMessage());
        }
        String result = "";
        try {
            HttpPost httppost = (HttpPost)this.getHttpRequestBase(1, Query_SubAccountByName);
            String requsetbody = "";
            if (this.BODY_TYPE == BodyType.Type_JSON) {
                JsonObject json = new JsonObject();
                json.addProperty("appId", this.App_ID);
                json.addProperty("friendlyName", friendlyName);
                requsetbody = json.toString();
            } else {
                requsetbody = "<?xml version='1.0' encoding='utf-8'?><SubAccount><appId>" + this.App_ID + "</appId>" + "<friendlyName>" + friendlyName + "</friendlyName>" + "</SubAccount>";
            }
            log.info("querySubAccountByName Request body =  " + requsetbody);
            BasicHttpEntity requestBody = new BasicHttpEntity();
            requestBody.setContent((InputStream)new ByteArrayInputStream(requsetbody.getBytes("UTF-8")));
            requestBody.setContentLength((long)requsetbody.getBytes("UTF-8").length);
            httppost.setEntity((HttpEntity)requestBody);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httppost);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            }
            EntityUtils.consume((HttpEntity)entity);
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error(e.getMessage());
            HashMap<String, Object> hashMap = this.getMyError("172001", "\u7f51\u7edc\u9519\u8bef");
            return hashMap;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            HashMap<String, Object> hashMap = this.getMyError("172002", "\u65e0\u8fd4\u56de");
            return hashMap;
        }
        finally {
            if (httpclient != null) {
                httpclient.getConnectionManager().shutdown();
            }
        }
        log.info("querySubAccount result " + result);
        try {
            if (this.BODY_TYPE == BodyType.Type_JSON) {
                return this.jsonToMap(result);
            }
            return this.xmlToMap(result);
        }
        catch (Exception e) {
            return this.getMyError("172003", "\u8fd4\u56de\u5305\u4f53\u9519\u8bef");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, Object> getSubAccounts(String startNo, String offset) {
        HashMap<String, Object> validate = this.accountValidate();
        if (validate != null) {
            return validate;
        }
        CcopHttpClient chc = new CcopHttpClient();
        DefaultHttpClient httpclient = null;
        try {
            httpclient = chc.registerSSL(this.SERVER_IP, "TLS", Integer.parseInt(this.SERVER_PORT), "https");
        }
        catch (Exception e1) {
            e1.printStackTrace();
            throw new RuntimeException("\u521d\u59cb\u5316httpclient\u5f02\u5e38" + e1.getMessage());
        }
        String result = "";
        try {
            HttpPost httppost = (HttpPost)this.getHttpRequestBase(1, Get_SubAccounts);
            String requsetbody = "";
            if (this.BODY_TYPE == BodyType.Type_JSON) {
                JsonObject json = new JsonObject();
                json.addProperty("appId", this.App_ID);
                if (!this.isEmpty(startNo)) {
                    json.addProperty("startNo", startNo);
                }
                if (!this.isEmpty(offset)) {
                    json.addProperty("offset", offset);
                }
                requsetbody = json.toString();
            } else {
                StringBuilder sb = new StringBuilder("<?xml version='1.0' encoding='utf-8'?><SubAccount>");
                sb.append("<appId>").append(this.App_ID).append("</appId>");
                if (!this.isEmpty(startNo)) {
                    sb.append("<startNo>").append(startNo).append("</startNo>");
                }
                if (!this.isEmpty(offset)) {
                    sb.append("<offset>").append(offset).append("</offset>");
                }
                sb.append("</SubAccount>").toString();
                requsetbody = sb.toString();
            }
            log.info("GetSubAccounts Request body =  " + requsetbody);
            BasicHttpEntity requestBody = new BasicHttpEntity();
            requestBody.setContent((InputStream)new ByteArrayInputStream(requsetbody.getBytes("UTF-8")));
            requestBody.setContentLength((long)requsetbody.getBytes("UTF-8").length);
            httppost.setEntity((HttpEntity)requestBody);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httppost);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            }
            EntityUtils.consume((HttpEntity)entity);
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error(e.getMessage());
            HashMap<String, Object> hashMap = this.getMyError("172001", "\u7f51\u7edc\u9519\u8bef");
            return hashMap;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            HashMap<String, Object> hashMap = this.getMyError("172002", "\u65e0\u8fd4\u56de");
            return hashMap;
        }
        finally {
            if (httpclient != null) {
                httpclient.getConnectionManager().shutdown();
            }
        }
        log.info("getSubAccounts result " + result);
        try {
            if (this.BODY_TYPE == BodyType.Type_JSON) {
                return this.jsonToMap(result);
            }
            return this.xmlToMap(result);
        }
        catch (Exception e) {
            return this.getMyError("172003", "\u8fd4\u56de\u5305\u4f53\u9519\u8bef");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, Object> queryAccountInfo() {
        if (this.isEmpty(this.SERVER_IP)) {
            return this.getMyError("172004", "IP\u4e3a\u7a7a");
        }
        if (this.isEmpty(this.SERVER_PORT)) {
            return this.getMyError("172005", "\u7aef\u53e3\u9519\u8bef");
        }
        if (this.isEmpty(this.ACCOUNT_SID)) {
            return this.getMyError("172006", "\u4e3b\u5e10\u53f7\u4e3a\u7a7a");
        }
        if (this.isEmpty(this.ACCOUNT_TOKEN)) {
            return this.getMyError("172007", "\u4e3b\u5e10\u53f7TOKEN\u4e3a\u7a7a");
        }
        CcopHttpClient chc = new CcopHttpClient();
        DefaultHttpClient httpclient = null;
        try {
            httpclient = chc.registerSSL(this.SERVER_IP, "TLS", Integer.parseInt(this.SERVER_PORT), "https");
        }
        catch (Exception e1) {
            e1.printStackTrace();
            log.error(e1.getMessage());
            throw new RuntimeException("\u521d\u59cb\u5316httpclient\u5f02\u5e38" + e1.getMessage());
        }
        String result = "";
        try {
            HttpGet httpGet = (HttpGet)this.getHttpRequestBase(0, Account_Info);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            }
            EntityUtils.consume((HttpEntity)entity);
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error(e.getMessage());
            HashMap<String, Object> hashMap = this.getMyError("172001", "\u7f51\u7edc\u9519\u8bef");
            return hashMap;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            HashMap<String, Object> hashMap = this.getMyError("172002", "\u65e0\u8fd4\u56de");
            return hashMap;
        }
        finally {
            if (httpclient != null) {
                httpclient.getConnectionManager().shutdown();
            }
        }
        log.info("queryAccountInfo response body = " + result);
        try {
            if (this.BODY_TYPE == BodyType.Type_JSON) {
                return this.jsonToMap(result);
            }
            return this.xmlToMap(result);
        }
        catch (Exception e) {
            return this.getMyError("172003", "\u8fd4\u56de\u5305\u4f53\u9519\u8bef");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, Object> createSubAccount(String friendlyName) {
        HashMap<String, Object> validate = this.accountValidate();
        if (validate != null) {
            return validate;
        }
        if (this.isEmpty(friendlyName)) {
            log.error("\u5fc5\u9009\u53c2\u6570: \u5b50\u5e10\u53f7\u540d\u79f0 \u4e3a\u7a7a");
            throw new IllegalArgumentException("\u5fc5\u9009\u53c2\u6570: \u5b50\u5e10\u53f7\u540d\u79f0 \u4e3a\u7a7a");
        }
        CcopHttpClient chc = new CcopHttpClient();
        DefaultHttpClient httpclient = null;
        try {
            httpclient = chc.registerSSL(this.SERVER_IP, "TLS", Integer.parseInt(this.SERVER_PORT), "https");
        }
        catch (Exception e1) {
            e1.printStackTrace();
            log.error(e1.getMessage());
            throw new RuntimeException("\u521d\u59cb\u5316httpclient\u5f02\u5e38" + e1.getMessage());
        }
        String result = "";
        try {
            HttpPost httppost = (HttpPost)this.getHttpRequestBase(1, Create_SubAccount);
            String requsetbody = "";
            if (this.BODY_TYPE == BodyType.Type_JSON) {
                JsonObject json = new JsonObject();
                json.addProperty("appId", this.App_ID);
                json.addProperty("friendlyName", friendlyName);
                requsetbody = json.toString();
            } else {
                requsetbody = "<?xml version='1.0' encoding='utf-8'?><SubAccount><appId>" + this.App_ID + "</appId>" + "<friendlyName>" + friendlyName + "</friendlyName>" + "</SubAccount>";
            }
            log.info("CreateSubAccount Request body =  " + requsetbody);
            BasicHttpEntity requestBody = new BasicHttpEntity();
            requestBody.setContent((InputStream)new ByteArrayInputStream(requsetbody.getBytes("UTF-8")));
            requestBody.setContentLength((long)requsetbody.getBytes("UTF-8").length);
            httppost.setEntity((HttpEntity)requestBody);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httppost);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            }
            EntityUtils.consume((HttpEntity)entity);
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error(e.getMessage());
            HashMap<String, Object> hashMap = this.getMyError("172001", "\u7f51\u7edc\u9519\u8bef");
            return hashMap;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            HashMap<String, Object> hashMap = this.getMyError("172002", "\u65e0\u8fd4\u56de");
            return hashMap;
        }
        finally {
            if (httpclient != null) {
                httpclient.getConnectionManager().shutdown();
            }
        }
        log.info("createSubAccount response body = " + result);
        try {
            if (this.BODY_TYPE == BodyType.Type_JSON) {
                return this.jsonToMap(result);
            }
            return this.xmlToMap(result);
        }
        catch (Exception e) {
            return this.getMyError("172003", "\u8fd4\u56de\u5305\u4f53\u9519\u8bef");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, Object> QuerySMSTemplate(String templateId) {
        HashMap<String, Object> validate = this.accountValidate();
        if (validate != null) {
            return validate;
        }
        CcopHttpClient chc = new CcopHttpClient();
        DefaultHttpClient httpclient = null;
        try {
            httpclient = chc.registerSSL(this.SERVER_IP, "TLS", Integer.parseInt(this.SERVER_PORT), "https");
        }
        catch (Exception e1) {
            e1.printStackTrace();
            log.error(e1.getMessage());
            throw new RuntimeException("\u521d\u59cb\u5316httpclient\u5f02\u5e38" + e1.getMessage());
        }
        String result = "";
        try {
            HttpPost httppost = (HttpPost)this.getHttpRequestBase(1, Query_SMSTemplate);
            String requsetbody = "";
            if (this.BODY_TYPE == BodyType.Type_JSON) {
                JsonObject json = new JsonObject();
                json.addProperty("appId", this.App_ID);
                json.addProperty("templateId", templateId);
                requsetbody = json.toString();
            } else {
                requsetbody = "<?xml version='1.0' encoding='utf-8'?><Request><appId>" + this.App_ID + "</appId>" + "<templateId>" + templateId + "</templateId>" + "</Request>";
            }
            log.info("QuerySMSTemplate Request body =  " + requsetbody);
            BasicHttpEntity requestBody = new BasicHttpEntity();
            requestBody.setContent((InputStream)new ByteArrayInputStream(requsetbody.getBytes("UTF-8")));
            requestBody.setContentLength((long)requsetbody.getBytes("UTF-8").length);
            httppost.setEntity((HttpEntity)requestBody);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httppost);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            }
            EntityUtils.consume((HttpEntity)entity);
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error(e.getMessage());
            HashMap<String, Object> hashMap = this.getMyError("172001", "\u7f51\u7edc\u9519\u8bef");
            return hashMap;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            HashMap<String, Object> hashMap = this.getMyError("172002", "\u65e0\u8fd4\u56de");
            return hashMap;
        }
        finally {
            if (httpclient != null) {
                httpclient.getConnectionManager().shutdown();
            }
        }
        log.info("QuerySMSTemplate response body = " + result);
        try {
            if (this.BODY_TYPE == BodyType.Type_JSON) {
                return this.jsonToMap(result);
            }
            return this.xmlToMap(result);
        }
        catch (Exception e) {
            return this.getMyError("172003", "\u8fd4\u56de\u5305\u4f53\u9519\u8bef");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, Object> CallCancel(String callSid, String type) {
        HashMap<String, Object> subAccountValidate = this.subAccountValidate();
        if (subAccountValidate != null) {
            return subAccountValidate;
        }
        if (this.isEmpty(callSid)) {
            log.error("\u5fc5\u9009\u53c2\u6570: callSid  \u4e3a\u7a7a");
            throw new IllegalArgumentException("\u5fc5\u9009\u53c2\u6570: callSid  \u4e3a\u7a7a");
        }
        CcopHttpClient chc = new CcopHttpClient();
        DefaultHttpClient httpclient = null;
        try {
            httpclient = chc.registerSSL(this.SERVER_IP, "TLS", Integer.parseInt(this.SERVER_PORT), "https");
        }
        catch (Exception e1) {
            e1.printStackTrace();
            log.error(e1.getMessage());
            throw new RuntimeException("\u521d\u59cb\u5316httpclient\u5f02\u5e38" + e1.getMessage());
        }
        String result = "";
        try {
            HttpPost httppost = (HttpPost)this.getHttpRequestBase(1, callCancel, AccountType.SubAccounts);
            String requsetbody = "";
            if (this.BODY_TYPE == BodyType.Type_JSON) {
                JsonObject json = new JsonObject();
                json.addProperty("appId", this.App_ID);
                json.addProperty("callSid", callSid);
                if (!this.isEmpty(type)) {
                    json.addProperty("type", type);
                }
                requsetbody = json.toString();
            } else {
                StringBuilder sb = new StringBuilder("<?xml version='1.0' encoding='utf-8'?><CallCancel>");
                sb.append("<appId>").append(this.App_ID).append("</appId>").append("<callSid>").append(callSid).append("</callSid>");
                if (!this.isEmpty(type)) {
                    sb.append("<type>").append(type).append("</type>");
                }
                sb.append("</CallCancel>").toString();
                requsetbody = sb.toString();
            }
            log.info("CallCancel Request body = : " + requsetbody);
            BasicHttpEntity requestBody = new BasicHttpEntity();
            requestBody.setContent((InputStream)new ByteArrayInputStream(requsetbody.getBytes("UTF-8")));
            requestBody.setContentLength((long)requsetbody.getBytes("UTF-8").length);
            httppost.setEntity((HttpEntity)requestBody);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httppost);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            }
            EntityUtils.consume((HttpEntity)entity);
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error(e.getMessage());
            HashMap<String, Object> hashMap = this.getMyError("172001", "\u7f51\u7edc\u9519\u8bef");
            return hashMap;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            HashMap<String, Object> hashMap = this.getMyError("172002", "\u65e0\u8fd4\u56de");
            return hashMap;
        }
        finally {
            if (httpclient != null) {
                httpclient.getConnectionManager().shutdown();
            }
        }
        log.info("billRecords response body = " + result);
        try {
            if (this.BODY_TYPE == BodyType.Type_JSON) {
                return this.jsonToMap(result);
            }
            return this.xmlToMap(result);
        }
        catch (Exception e) {
            return this.getMyError("172003", "\u8fd4\u56de\u5305\u4f53\u9519\u8bef");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, Object> QueryCallState(String callid, String action) {
        HashMap<String, Object> validate = this.accountValidate();
        if (validate != null) {
            return validate;
        }
        if (this.isEmpty(callid)) {
            log.error("\u5fc5\u9009\u53c2\u6570: callid  \u4e3a\u7a7a");
            throw new IllegalArgumentException("\u5fc5\u9009\u53c2\u6570: callid \u4e3a\u7a7a");
        }
        this.Callsid = callid;
        CcopHttpClient chc = new CcopHttpClient();
        DefaultHttpClient httpclient = null;
        try {
            httpclient = chc.registerSSL(this.SERVER_IP, "TLS", Integer.parseInt(this.SERVER_PORT), "https");
        }
        catch (Exception e1) {
            e1.printStackTrace();
            log.error(e1.getMessage());
            throw new RuntimeException("\u521d\u59cb\u5316httpclient\u5f02\u5e38" + e1.getMessage());
        }
        String result = "";
        try {
            HttpPost httppost = (HttpPost)this.getHttpRequestBase(1, queryCallState);
            String requsetbody = "";
            if (this.BODY_TYPE == BodyType.Type_JSON) {
                JsonObject json = new JsonObject();
                JsonObject json2 = new JsonObject();
                json.addProperty("Appid", this.App_ID);
                json2.addProperty("callid", callid);
                if (!this.isEmpty(action)) {
                    json2.addProperty("action", action);
                }
                json.addProperty("QueryCallState", json2.toString());
                requsetbody = json.toString();
            } else {
                StringBuilder sb = new StringBuilder("<?xml version='1.0' encoding='utf-8'?><Request>");
                sb.append("<Appid>").append(this.App_ID).append("</Appid>").append("<QueryCallState callid=").append("\"").append(callid).append("\"");
                if (action != null) {
                    sb.append(" action=").append("\"").append(action).append("\"").append("/");
                }
                sb.append("></Request>").toString();
                requsetbody = sb.toString();
            }
            log.info("queryCallState Request body = : " + requsetbody);
            BasicHttpEntity requestBody = new BasicHttpEntity();
            requestBody.setContent((InputStream)new ByteArrayInputStream(requsetbody.getBytes("UTF-8")));
            requestBody.setContentLength((long)requsetbody.getBytes("UTF-8").length);
            httppost.setEntity((HttpEntity)requestBody);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httppost);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            }
            EntityUtils.consume((HttpEntity)entity);
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error(e.getMessage());
            HashMap<String, Object> hashMap = this.getMyError("172001", "\u7f51\u7edc\u9519\u8bef");
            return hashMap;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            HashMap<String, Object> hashMap = this.getMyError("172002", "\u65e0\u8fd4\u56de");
            return hashMap;
        }
        finally {
            if (httpclient != null) {
                httpclient.getConnectionManager().shutdown();
            }
        }
        log.info("billRecords response body = " + result);
        try {
            if (this.BODY_TYPE == BodyType.Type_JSON) {
                return this.jsonToMap(result);
            }
            return this.xmlToMap(result);
        }
        catch (Exception e) {
            return this.getMyError("172003", "\u8fd4\u56de\u5305\u4f53\u9519\u8bef");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, Object> CallResult(String callSid) {
        if (this.isEmpty(this.SERVER_IP)) {
            return this.getMyError("172004", "IP\u4e3a\u7a7a");
        }
        if (this.isEmpty(this.SERVER_PORT)) {
            return this.getMyError("172005", "\u7aef\u53e3\u9519\u8bef");
        }
        if (this.isEmpty(this.ACCOUNT_SID)) {
            return this.getMyError("172006", "\u4e3b\u5e10\u53f7\u4e3a\u7a7a");
        }
        if (this.isEmpty(this.ACCOUNT_TOKEN)) {
            return this.getMyError("172007", "\u4e3b\u5e10\u53f7TOKEN\u4e3a\u7a7a");
        }
        this.Callsid = callSid;
        CcopHttpClient chc = new CcopHttpClient();
        DefaultHttpClient httpclient = null;
        try {
            httpclient = chc.registerSSL(this.SERVER_IP, "TLS", Integer.parseInt(this.SERVER_PORT), "https");
        }
        catch (Exception e1) {
            e1.printStackTrace();
            log.error(e1.getMessage());
            throw new RuntimeException("\u521d\u59cb\u5316httpclient\u5f02\u5e38" + e1.getMessage());
        }
        String result = "";
        try {
            HttpGet httpGet = (HttpGet)this.getHttpRequestBase(0, callResult);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            }
            EntityUtils.consume((HttpEntity)entity);
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error(e.getMessage());
            HashMap<String, Object> hashMap = this.getMyError("172001", "\u7f51\u7edc\u9519\u8bef");
            return hashMap;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            HashMap<String, Object> hashMap = this.getMyError("172002", "\u65e0\u8fd4\u56de");
            return hashMap;
        }
        finally {
            if (httpclient != null) {
                httpclient.getConnectionManager().shutdown();
            }
        }
        log.info("queryAccountInfo response body = " + result);
        try {
            if (this.BODY_TYPE == BodyType.Type_JSON) {
                return this.jsonToMap(result);
            }
            return this.xmlToMap(result);
        }
        catch (Exception e) {
            return this.getMyError("172003", "\u8fd4\u56de\u5305\u4f53\u9519\u8bef");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, Object> MediaFileUpload(String filename, String requsetbody) {
        HashMap<String, Object> validate = this.accountValidate();
        if (validate != null) {
            return validate;
        }
        if (this.isEmpty(filename)) {
            log.error("\u5fc5\u9009\u53c2\u6570: filename  \u4e3a\u7a7a");
            throw new IllegalArgumentException("\u5fc5\u9009\u53c2\u6570: filename \u4e3a\u7a7a");
        }
        this.Filename = filename;
        CcopHttpClient chc = new CcopHttpClient();
        DefaultHttpClient httpclient = null;
        try {
            httpclient = chc.registerSSL(this.SERVER_IP, "TLS", Integer.parseInt(this.SERVER_PORT), "https");
        }
        catch (Exception e1) {
            e1.printStackTrace();
            log.error(e1.getMessage());
            throw new RuntimeException("\u521d\u59cb\u5316httpclient\u5f02\u5e38" + e1.getMessage());
        }
        String result = "";
        try {
            HttpPost httppost = (HttpPost)this.getHttpRequestBase(1, mediaFileUpload);
            log.info("MediaFileUpload Request body = : " + requsetbody);
            BasicHttpEntity requestBody = new BasicHttpEntity();
            requestBody.setContent((InputStream)new ByteArrayInputStream(requsetbody.getBytes("UTF-8")));
            requestBody.setContentLength((long)requsetbody.getBytes("UTF-8").length);
            httppost.setEntity((HttpEntity)requestBody);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httppost);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            }
            EntityUtils.consume((HttpEntity)entity);
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error(e.getMessage());
            HashMap<String, Object> hashMap = this.getMyError("172001", "\u7f51\u7edc\u9519\u8bef");
            return hashMap;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            HashMap<String, Object> hashMap = this.getMyError("172002", "\u65e0\u8fd4\u56de");
            return hashMap;
        }
        finally {
            if (httpclient != null) {
                httpclient.getConnectionManager().shutdown();
            }
        }
        log.info("billRecords response body = " + result);
        try {
            if (this.BODY_TYPE == BodyType.Type_JSON) {
                return this.jsonToMap(result);
            }
            return this.xmlToMap(result);
        }
        catch (Exception e) {
            return this.getMyError("172003", "\u8fd4\u56de\u5305\u4f53\u9519\u8bef");
        }
    }

    private HashMap<String, Object> jsonToMap(String result) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        JsonParser parser = new JsonParser();
        JsonObject asJsonObject = parser.parse(result).getAsJsonObject();
        Set entrySet = asJsonObject.entrySet();
        HashMap hashMap2 = new HashMap();
        for (Map.Entry m : entrySet) {
            if ("statusCode".equals(m.getKey()) || "statusMsg".equals(m.getKey())) {
                hashMap.put((String)m.getKey(), ((JsonElement)m.getValue()).getAsString());
                continue;
            }
            if ("SubAccount".equals(m.getKey()) || "totalCount".equals(m.getKey()) || "smsTemplateList".equals(m.getKey()) || "token".equals(m.getKey()) || "callSid".equals(m.getKey()) || "state".equals(m.getKey()) || "downUrl".equals(m.getKey())) {
                if (!"SubAccount".equals(m.getKey()) && !"smsTemplateList".equals(m.getKey())) {
                    hashMap2.put(m.getKey(), ((JsonElement)m.getValue()).getAsString());
                } else {
                    try {
                        if (((JsonElement)m.getValue()).toString().trim().length() <= 2 && !((JsonElement)m.getValue()).toString().contains("[")) {
                            hashMap2.put(m.getKey(), ((JsonElement)m.getValue()).getAsString());
                            hashMap.put("data", hashMap2);
                            break;
                        }
                        if (((JsonElement)m.getValue()).toString().contains("[]")) {
                            hashMap2.put(m.getKey(), new JsonArray());
                            hashMap.put("data", hashMap2);
                            continue;
                        }
                        JsonArray asJsonArray = parser.parse(((JsonElement)m.getValue()).toString()).getAsJsonArray();
                        ArrayList arrayList = new ArrayList();
                        for (JsonElement j : asJsonArray) {
                            Set entrySet2 = j.getAsJsonObject().entrySet();
                            HashMap hashMap3 = new HashMap();
                            Iterator iterator = entrySet2.iterator();
                            while (iterator.hasNext()) {
                                Map.Entry m2 = (Map.Entry)iterator.next();
                                hashMap3.put(m2.getKey(), ((JsonElement)m2.getValue()).getAsString());
                            }
                            arrayList.add(hashMap3);
                        }
                        hashMap2.put(m.getKey(), arrayList);
                    }
                    catch (Exception e) {
                        JsonObject asJsonObject2 = parser.parse(((JsonElement)m.getValue()).toString()).getAsJsonObject();
                        Set entrySet2 = asJsonObject2.entrySet();
                        HashMap hashMap3 = new HashMap();
                        for (Map.Entry m2 : entrySet2) {
                            hashMap3.put(m2.getKey(), ((JsonElement)m2.getValue()).getAsString());
                        }
                        hashMap2.put(m.getKey(), hashMap3);
                        hashMap.put("data", hashMap2);
                    }
                }
                hashMap.put("data", hashMap2);
                continue;
            }
            JsonObject asJsonObject2 = parser.parse(((JsonElement)m.getValue()).toString()).getAsJsonObject();
            Set entrySet2 = asJsonObject2.entrySet();
            HashMap hashMap3 = new HashMap();
            for (Map.Entry m2 : entrySet2) {
                hashMap3.put(m2.getKey(), ((JsonElement)m2.getValue()).getAsString());
            }
            if (hashMap3.size() != 0) {
                hashMap2.put(m.getKey(), hashMap3);
            } else {
                hashMap2.put(m.getKey(), ((JsonElement)m.getValue()).getAsString());
            }
            hashMap.put("data", hashMap2);
        }
        return hashMap;
    }

    private HashMap<String, Object> xmlToMap(String xml) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Document doc = null;
        try {
            doc = DocumentHelper.parseText((String)xml);
            Element rootElt = doc.getRootElement();
            HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
            ArrayList arrayList = new ArrayList();
            Iterator i = rootElt.elementIterator();
            while (i.hasNext()) {
                Element e2;
                Iterator i2;
                HashMap<String, String> hashMap3;
                Element e = (Element)i.next();
                if ("statusCode".equals(e.getName()) || "statusMsg".equals(e.getName())) {
                    map.put(e.getName(), e.getText());
                    continue;
                }
                if ("SubAccount".equals(e.getName()) || "TemplateSMS".equals(e.getName()) || "totalCount".equals(e.getName()) || "token".equals(e.getName()) || "callSid".equals(e.getName()) || "state".equals(e.getName()) || "downUrl".equals(e.getName())) {
                    if (!"SubAccount".equals(e.getName()) && !"TemplateSMS".equals(e.getName())) {
                        hashMap2.put(e.getName(), e.getText());
                    } else if ("SubAccount".equals(e.getName())) {
                        hashMap3 = new HashMap<String, String>();
                        i2 = e.elementIterator();
                        while (i2.hasNext()) {
                            e2 = (Element)i2.next();
                            hashMap3.put(e2.getName(), e2.getText());
                        }
                        arrayList.add(hashMap3);
                        hashMap2.put("SubAccount", arrayList);
                    } else if ("TemplateSMS".equals(e.getName())) {
                        hashMap3 = new HashMap();
                        i2 = e.elementIterator();
                        while (i2.hasNext()) {
                            e2 = (Element)i2.next();
                            hashMap3.put(e2.getName(), e2.getText());
                        }
                        arrayList.add(hashMap3);
                        hashMap2.put("TemplateSMS", arrayList);
                    }
                    map.put("data", hashMap2);
                    continue;
                }
                hashMap3 = new HashMap();
                i2 = e.elementIterator();
                while (i2.hasNext()) {
                    e2 = (Element)i2.next();
                    hashMap3.put(e2.getName(), e2.getText());
                }
                if (hashMap3.size() != 0) {
                    hashMap2.put(e.getName(), hashMap3);
                } else {
                    hashMap2.put(e.getName(), e.getText());
                }
                map.put("data", hashMap2);
            }
        }
        catch (DocumentException e) {
            e.printStackTrace();
            log.error(e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
        }
        return map;
    }

    private HttpRequestBase getHttpRequestBase(int get, String action) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        return this.getHttpRequestBase(get, action, AccountType.Accounts);
    }

    private HttpRequestBase getHttpRequestBase(int get, String action, AccountType mAccountType) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        String timestamp = DateUtil.dateToStr(new Date(), 5);
        log.info(timestamp);
        EncryptUtil eu = new EncryptUtil();
        String sig = "";
        String acountName = "";
        String acountType = "";
        if (mAccountType == AccountType.Accounts) {
            acountName = this.ACCOUNT_SID;
            sig = this.ACCOUNT_SID + this.ACCOUNT_TOKEN + timestamp;
            acountType = "Accounts";
        } else {
            acountName = this.SUBACCOUNT_SID;
            sig = this.SUBACCOUNT_SID + this.SUBACCOUNT_Token + timestamp;
            acountType = Create_SubAccount;
        }
        String signature = eu.md5Digest(sig);
        String url = this.getBaseUrl().append("/" + acountType + "/").append(acountName).append("/" + action + "?sig=").append(signature).toString();
        if (callResult.equals(action)) {
            url = url + "&callsid=" + this.Callsid;
        }
        if (queryCallState.equals(action)) {
            url = url + "&callid=" + this.Callsid;
        }
        if (mediaFileUpload.equals(action)) {
            url = url + "&appid=" + this.App_ID + "&filename=" + this.Filename;
        }
        log.info(this.getmethodName(action) + " url = " + url);
        HttpGet mHttpRequestBase = null;
        if (get == 0) {
            mHttpRequestBase = new HttpGet(url);
        } else if (get == 1) {
            mHttpRequestBase = new HttpPost(url);
        }
        if (IvrDial.equals(action)) {
            this.setHttpHeaderXML((AbstractHttpMessage)mHttpRequestBase);
        } else if (mediaFileUpload.equals(action)) {
            this.setHttpHeaderMedia((AbstractHttpMessage)mHttpRequestBase);
        } else {
            this.setHttpHeader((AbstractHttpMessage)mHttpRequestBase);
        }
        String src = acountName + ":" + timestamp;
        String auth = eu.base64Encoder(src);
        mHttpRequestBase.setHeader("Authorization", auth);
        return mHttpRequestBase;
    }

    private String getmethodName(String action) {
        if (action.equals(Account_Info)) {
            return "queryAccountInfo";
        }
        if (action.equals(Create_SubAccount)) {
            return "createSubAccount";
        }
        if (action.equals(Get_SubAccounts)) {
            return "getSubAccounts";
        }
        if (action.equals(Query_SubAccountByName)) {
            return "querySubAccount";
        }
        if (action.equals(SMSMessages)) {
            return "sendSMS";
        }
        if (action.equals(TemplateSMS)) {
            return "sendTemplateSMS";
        }
        if (action.equals(Call_back)) {
            return "callback";
        }
        if (action.equals(LandingCalls)) {
            return "landingCalls";
        }
        if (action.equals(VoiceVerify)) {
            return "voiceVerify";
        }
        if (action.equals(IvrDial)) {
            return "ivrDial";
        }
        if (action.equals(BillRecords)) {
            return "billRecords";
        }
        return "";
    }

    private void setHttpHeaderXML(AbstractHttpMessage httpMessage) {
        httpMessage.setHeader("Accept", "application/xml");
        httpMessage.setHeader("Content-Type", "application/xml;charset=utf-8");
    }

    private void setHttpHeaderMedia(AbstractHttpMessage httpMessage) {
        if (this.BODY_TYPE == BodyType.Type_JSON) {
            httpMessage.setHeader("Accept", "application/json");
            httpMessage.setHeader("Content-Type", "application/octet-stream;charset=utf-8;");
        } else {
            httpMessage.setHeader("Accept", "application/xml");
            httpMessage.setHeader("Content-Type", "application/octet-stream;charset=utf-8;");
        }
    }

    private void setHttpHeader(AbstractHttpMessage httpMessage) {
        if (this.BODY_TYPE == BodyType.Type_JSON) {
            httpMessage.setHeader("Accept", "application/json");
            httpMessage.setHeader("Content-Type", "application/json;charset=utf-8");
        } else {
            httpMessage.setHeader("Accept", "application/xml");
            httpMessage.setHeader("Content-Type", "application/xml;charset=utf-8");
        }
    }

    private StringBuffer getBaseUrl() {
        StringBuffer sb = new StringBuffer("https://");
        sb.append(this.SERVER_IP).append(":").append(this.SERVER_PORT);
        sb.append("/2013-12-26");
        return sb;
    }

    private boolean isEmpty(String str) {
        return "".equals(str) || str == null;
    }

    private HashMap<String, Object> getMyError(String code, String msg) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("statusCode", code);
        hashMap.put("statusMsg", msg);
        return hashMap;
    }

    private HashMap<String, Object> subAccountValidate() {
        if (this.isEmpty(this.SERVER_IP)) {
            return this.getMyError("172004", "IP\u4e3a\u7a7a");
        }
        if (this.isEmpty(this.SERVER_PORT)) {
            return this.getMyError("172005", "\u7aef\u53e3\u9519\u8bef");
        }
        if (this.isEmpty(this.SUBACCOUNT_SID)) {
            return this.getMyError("172008", "\u5b50\u5e10\u53f7\u7a7a");
        }
        if (this.isEmpty(this.SUBACCOUNT_Token)) {
            return this.getMyError("172009", "\u5b50\u5e10\u53f7TOKEN\u7a7a");
        }
        return null;
    }

    private HashMap<String, Object> accountValidate() {
        if (this.isEmpty(this.SERVER_IP)) {
            return this.getMyError("172004", "IP\u4e3a\u7a7a");
        }
        if (this.isEmpty(this.SERVER_PORT)) {
            return this.getMyError("172005", "\u7aef\u53e3\u9519\u8bef");
        }
        if (this.isEmpty(this.ACCOUNT_SID)) {
            return this.getMyError("172006", "\u4e3b\u5e10\u53f7\u4e3a\u7a7a");
        }
        if (this.isEmpty(this.ACCOUNT_TOKEN)) {
            return this.getMyError("172007", "\u4e3b\u5e10\u53f7TOKEN\u4e3a\u7a7a");
        }
        if (this.isEmpty(this.App_ID)) {
            return this.getMyError("172012", "\u5e94\u7528ID\u4e3a\u7a7a");
        }
        return null;
    }

    private void setBodyType(BodyType bodyType) {
        this.BODY_TYPE = bodyType;
    }

    public static enum AccountType {
        Accounts,
        SubAccounts;

    }

    public static enum BodyType {
        Type_XML,
        Type_JSON;

    }
}

