/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.callservice.constants;

import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.ErrorSide;
import com.baijia.tianxiao.enums.Platform;
import com.baijia.tianxiao.enums.Subsystem;

public enum CallServiceErrorCode implements UniverseErrorCode
{
    PARAM_ERROR(400, "\u8bf7\u6c42\u53c2\u6570\u4e0d\u5408\u6cd5"),
    TIME_EXHAUSTED(201, "\u901a\u8bdd\u65f6\u957f\u5df2\u7528\u5b8c");

    private int code;
    private String message;

    private CallServiceErrorCode(int code, String msg) {
        this.code = code;
        this.message = msg;
    }

    public ErrorSide getErrorSide() {
        return ErrorSide.SERVER;
    }

    public Subsystem getSystem() {
        return Subsystem.ORGANIZATION;
    }

    public Platform getPlatform() {
        return Platform.UNKNOW;
    }

    public int getSubsystemErrorCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public UniverseErrorCode fromCode(int code) {
        for (CallServiceErrorCode errorCode : CallServiceErrorCode.values()) {
            if (errorCode.getSubsystemErrorCode() != code) continue;
            return errorCode;
        }
        return CommonErrorCode.UNKNOW;
    }
}

