package com.baijia.tianxiao.sal.callservice.constants;

import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.ErrorSide;
import com.baijia.tianxiao.enums.Platform;
import com.baijia.tianxiao.enums.Subsystem;

/**
 * @author macrohuang
 * @version 1.0
 * @title ErrorCode
 * @desc TODO
 * @date Nov 11, 2015
 */
public enum CallServiceErrorCode implements UniverseErrorCode {

    PARAM_ERROR(400, "请求参数不合法"),
    TIME_EXHAUSTED(201, "通话时长已用完"),;

    private int code;
    private String message;

    CallServiceErrorCode(int code, String msg) {
        this.code = code;
        this.message = msg;
    }

    @Override
    public ErrorSide getErrorSide() {
        return ErrorSide.SERVER;
    }

    @Override
    public Subsystem getSystem() {
        return Subsystem.ORGANIZATION;
    }

    @Override
    public Platform getPlatform() {
        return Platform.UNKNOW;
    }

    @Override
    public int getSubsystemErrorCode() {
        return code;
    }

    @Override
    public String getMessage() {
        return message;
    }

    @Override
    public UniverseErrorCode fromCode(int code) {
        for (CallServiceErrorCode errorCode : values()) {
            if (errorCode.getSubsystemErrorCode() == code) {
                return errorCode;
            }
        }
        return CommonErrorCode.UNKNOW;
    }

}
