/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.callservice.exception;

import com.baijia.tianxiao.dto.UniverseErrorCode;

/**
 * @title CallServiceRecordException
 * @desc TODO
 * @author cxm
 * @date 2015年12月10日
 * @version 1.0
 */
public class CallServiceRecordException extends RuntimeException {

    /**
     * 
     */
    private static final long serialVersionUID = -1519053662899016503L;

    private UniverseErrorCode errorCode;

    private String errorMsg;

    public CallServiceRecordException(String errorMsg) {
        super(errorMsg);
        this.errorMsg = errorMsg;
    }

    public CallServiceRecordException(UniverseErrorCode errorCode) {
        super(errorCode.getMessage());
        this.errorCode = errorCode;
    }

    public CallServiceRecordException(UniverseErrorCode errorCode, String errorMsg) {
        super(errorMsg);
        this.errorCode = errorCode;
        this.errorMsg = errorMsg;
    }

    public UniverseErrorCode getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

}
