package com.baijia.tianxiao.sal.callservice.constants;

import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.ErrorSide;
import com.baijia.tianxiao.enums.Platform;
import com.baijia.tianxiao.enums.Subsystem;

/**
 * @title ErrorCode
 * @desc TODO
 * @author macrohuang
 * @date Nov 11, 2015
 * @version 1.0
 */
public enum CallServiceErrorCode implements UniverseErrorCode {

    PARAM_ERROR(ErrorSide.CLIENT, Subsystem.UNKNOW, Platform.UNKNOW, 400, "请求参数不合法"),
    TIME_EXHAUSTED(ErrorSide.CLIENT, Subsystem.ORGANIZATION, Platform.UNKNOW, 201, "通话时长已用完"),

    ;

    private ErrorSide errorSide;
    private Subsystem subsystem;
    private Platform platform;
    private int code;
    private String message;

    private CallServiceErrorCode(ErrorSide errorSide, Subsystem subsystem, Platform platform, int code, String msg) {
        this.errorSide = errorSide;
        this.subsystem = subsystem;
        this.platform = platform;
        this.code = code;
        this.message = msg;
    }

    @Override
    public ErrorSide getErrorSide() {
        return errorSide;
    }

    @Override
    public Subsystem getSystem() {
        return subsystem;
    }

    @Override
    public Platform getPlatform() {
        return platform;
    }

    @Override
    public int getSubsystemErrorCode() {
        return code;
    }

    @Override
    public String getMessage() {
        return message;
    }

    @Override
    public UniverseErrorCode fromCode(int code) {
        for (CallServiceErrorCode errorCode : values()) {
            if (errorCode.getSubsystemErrorCode() == code) {
                return errorCode;
            }
        }
        return CommonErrorCode.UNKNOW;
    }

}
