/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.callservice.service.impl;

import com.baijia.tianxiao.dal.advisory.dao.OrgCallRecorderDao;
import com.baijia.tianxiao.dal.advisory.po.OrgCallRecorder;
import com.baijia.tianxiao.dal.org.constant.AuditColumType;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.dao.OrgTxtMsgDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.org.po.OrgTxtMsg;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.callservice.dto.CallUrlAndDurationResponseDto;
import com.baijia.tianxiao.sal.callservice.exception.CallServiceRecordException;
import com.baijia.tianxiao.sal.callservice.service.OrgCallService;
import com.baijia.tianxiao.util.storage.StorageUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgCallServiceImpl
implements OrgCallService {
    private static final Logger log = LoggerFactory.getLogger(OrgCallServiceImpl.class);
    @Resource
    private OrgCallRecorderDao orgCallRecordDao;
    @Resource
    private OrgStorageDao orgStorageDao;
    @Resource
    private OrgTxtMsgDao orgTxtMsgDao;
    @Resource
    private OrgAccountDao orgAccountDao;

    @Override
    @Transactional(readOnly=true)
    public CallUrlAndDurationResponseDto getRecordFileUrl(Long callId) {
        Preconditions.checkArgument((callId != null && callId > 0L ? 1 : 0) != 0, (String)"call id : %s is illegal.", (Object[])new Object[]{callId});
        OrgCallRecorder callRecord = (OrgCallRecorder)this.orgCallRecordDao.getById((Serializable)callId, new String[]{"id", "status", "storageId", "duringTime"});
        if (callRecord == null) {
            log.warn("can not get call record by callId:{}", (Object)callId);
            throw new CallServiceRecordException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7684\u901a\u8bdd\u8bb0\u5f55.");
        }
        if (callRecord.getStatus() != 1) {
            log.warn("call is not connected");
            return null;
        }
        if (callRecord.getStorageId() == null || callRecord.getStorageId() == 0L) {
            log.warn("storage id is illegal:{}", (Object)callRecord.getStorageId());
            return null;
        }
        OrgStorage storage = (OrgStorage)this.orgStorageDao.getById((Serializable)callRecord.getStorageId(), new String[0]);
        if (storage == null) {
            log.warn("can not found storage by storage id:{}", (Object)callRecord.getStorageId());
            throw new CallServiceRecordException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "");
        }
        String url = StorageUtil.constructUrl((String)storage.getFid(), (String)storage.getSn(), (Integer)storage.getMimeType());
        log.info("get org call record:{},record file url:{}", (Object)callRecord, (Object)url);
        return new CallUrlAndDurationResponseDto(callRecord.getDuringTime(), url);
    }

    @Override
    @Transactional(readOnly=true)
    public List<String> getOrgContactTel(Long orgId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"org id is illegal");
        ArrayList contactTels = Lists.newArrayList();
        OrgTxtMsg txtMsg = this.orgTxtMsgDao.getOrgTxtByIdAndType(orgId.intValue(), AuditColumType.PHONE.getValue());
        if (txtMsg == null || StringUtils.isBlank((CharSequence)txtMsg.getValue())) {
            OrgAccount acc = this.orgAccountDao.getAccountById(orgId.intValue(), new String[]{"mobile"});
            if (acc == null) {
                log.warn("can not found org account by orgId:{}", (Object)orgId);
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PERMISSION_DENY);
            }
            contactTels.add(acc.getMobile());
        } else {
            contactTels = Lists.newArrayList((Object[])StringUtils.split((String)txtMsg.getValue(), (char)','));
        }
        log.info("get contact tel by orgId:{},result:{}", (Object)orgId, (Object)contactTels);
        return contactTels;
    }
}

