/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.advisory.service.impl;

import com.baijia.tianxiao.dal.advisory.constant.AdvisoryType;
import com.baijia.tianxiao.dal.advisory.dao.OrgStudentAdvisoryDao;
import com.baijia.tianxiao.dal.advisory.po.OrgStudentAdvisory;
import com.baijia.tianxiao.dal.advisory.service.AdvisoryService;
import com.baijia.tianxiao.dal.course.dao.TeacherClassCourseDao;
import com.baijia.tianxiao.dal.course.po.TeacherClassCourse;
import com.baijia.tianxiao.dal.dto.response.AdvisoryInfoDto;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.sync.constant.AdvisoryStatus;
import com.baijia.tianxiao.dal.user.dao.StudentDao;
import com.baijia.tianxiao.dal.user.dao.UserDao;
import com.baijia.tianxiao.dal.user.po.User;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AdvisoryServiceImpl
implements AdvisoryService {
    private static final Logger log = LoggerFactory.getLogger(AdvisoryServiceImpl.class);
    @Resource
    private OrgStudentAdvisoryDao orgStudentAdvisoryDao;
    @Resource
    private OrgCourseDao orgCourseDao;
    @Resource
    private StudentDao studentDao;
    @Resource
    private UserDao userDao;
    @Resource
    private TeacherClassCourseDao teacherClassCourseDao;
    @Resource
    private OrgAccountDao orgAccountDao;

    @Override
    public List<AdvisoryInfoDto> getAdvisoryInfos(Long minId, Date latestDate, int size) {
        log.info("query advisory infos by minId:{},lastDate:{}", (Object)minId, (Object)latestDate);
        List orgStudentAdvisorys = this.orgStudentAdvisoryDao.getAdvisoryListByMinId(minId, latestDate, size, new String[0]);
        return this._getAdvisoryInfo(orgStudentAdvisorys);
    }

    @Override
    public List<AdvisoryInfoDto> getAdvisoryInfos(List<Long> advisoryIds) {
        log.info("query advisory infos by advisoryIds:{}", advisoryIds);
        if (advisoryIds == null || advisoryIds.isEmpty()) {
            return new ArrayList<AdvisoryInfoDto>();
        }
        List orgStudentAdvisorys = this.orgStudentAdvisoryDao.getByIds(advisoryIds, new String[0]);
        return this._getAdvisoryInfo(orgStudentAdvisorys);
    }

    private List<AdvisoryInfoDto> _getAdvisoryInfo(List<OrgStudentAdvisory> orgStudentAdvisorys) {
        ArrayList advisoryInfoDtos = Lists.newArrayList();
        Map orgNumberMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(orgStudentAdvisorys)) {
            Collection orgIds = CollectorUtil.collect(orgStudentAdvisorys, (Function)new Function<OrgStudentAdvisory, Integer>(){

                public Integer apply(OrgStudentAdvisory input) {
                    return input.getOrgId().intValue();
                }
            });
            List accList = this.orgAccountDao.getByIds(orgIds, new String[]{"id", "number"});
            orgNumberMap = CollectorUtil.collectMap((Collection)accList, (Function)new Function<OrgAccount, Long>(){

                public Long apply(OrgAccount input) {
                    return input.getId().longValue();
                }
            }, (Function)new Function<OrgAccount, Long>(){

                public Long apply(OrgAccount input) {
                    return input.getNumber().longValue();
                }
            });
        }
        HashMap teacherClassCourseMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(orgStudentAdvisorys)) {
            HashSet studentIdsTmp = Sets.newHashSet();
            HashSet courseIdSets = Sets.newHashSet();
            HashSet mobiles = Sets.newHashSet();
            for (OrgStudentAdvisory orgStudentAdvisory : orgStudentAdvisorys) {
                if (orgStudentAdvisory.getStudentId() > 0L) {
                    studentIdsTmp.add(Long.valueOf(orgStudentAdvisory.getStudentId()));
                } else {
                    mobiles.add(orgStudentAdvisory.getMobile());
                }
                courseIdSets.add(orgStudentAdvisory.getCourseId());
            }
            Map nameMap = this.studentDao.getStudentNameMap((Collection)studentIdsTmp);
            ArrayList users = Lists.newArrayList();
            users.addAll(this.userDao.getByIds((Collection)studentIdsTmp, new String[]{"id", "mobile", "number"}));
            users.addAll(this.userDao.getByMobiles((Collection)mobiles, new String[]{"id", "mobile", "number"}));
            Map courseMap = this.orgCourseDao.getOrgCourseMap((Collection)courseIdSets);
            List classCourses = this.teacherClassCourseDao.getByIds((Collection)courseIdSets, new String[0]);
            for (TeacherClassCourse teacherClassCourse : classCourses) {
                teacherClassCourseMap.put(teacherClassCourse.getId(), teacherClassCourse);
            }
            this.buildAdvisoryInfos(advisoryInfoDtos, orgStudentAdvisorys, nameMap, users, courseMap, teacherClassCourseMap, orgNumberMap);
        }
        return advisoryInfoDtos;
    }

    private void buildAdvisoryInfos(List<AdvisoryInfoDto> advisoryInfoDtos, List<OrgStudentAdvisory> orgStudentAdvisorys, Map<Long, String> nameMap, List<User> userList, Map<Long, OrgCourse> courseMap, Map<Long, TeacherClassCourse> teacherClassCourseMap, Map<Long, Long> orgNumberMap) {
        if (CollectionUtils.isNotEmpty(orgStudentAdvisorys)) {
            User user2;
            HashMap userMap = Maps.newHashMap();
            HashMap userIdMap = Maps.newHashMap();
            for (User user2 : userList) {
                userMap.put(user2.getMobile(), user2);
                userIdMap.put(user2.getId(), user2);
            }
            user2 = null;
            for (OrgStudentAdvisory orgStudentAdvisory : orgStudentAdvisorys) {
                String studentName;
                AdvisoryInfoDto advisoryInfoDto = new AdvisoryInfoDto();
                this.buildAdvisoryInfoDto(advisoryInfoDto, orgStudentAdvisory, orgNumberMap.get(orgStudentAdvisory.getOrgId()));
                advisoryInfoDto.setOrgId(orgStudentAdvisory.getOrgId());
                User user3 = user2 = orgStudentAdvisory.getStudentId() > 0L ? (User)userIdMap.get(orgStudentAdvisory.getStudentId()) : (User)userMap.get(orgStudentAdvisory.getMobile());
                if (user2 != null) {
                    advisoryInfoDto.setUserNumber(user2.getNumber());
                    advisoryInfoDto.setStudentId(user2.getId());
                }
                if (StringUtils.isBlank((CharSequence)(studentName = orgStudentAdvisory.getRealname()))) {
                    studentName = nameMap.get((long)orgStudentAdvisory.getStudentId());
                }
                advisoryInfoDto.setStudentName(StringUtils.isBlank((CharSequence)studentName) ? "\u5728\u7ebf\u7559\u5355\u5b66\u751f" : studentName);
                if (StringUtils.isEmpty((CharSequence)orgStudentAdvisory.getMobile().trim())) {
                    String mobile = user2 != null ? user2.getMobile() : "-";
                    advisoryInfoDto.setStudentMobile(mobile);
                } else {
                    advisoryInfoDto.setStudentMobile(orgStudentAdvisory.getMobile());
                }
                OrgCourse course = courseMap.get(orgStudentAdvisory.getCourseId());
                if (course != null) {
                    advisoryInfoDto.setCourseName(course.getName());
                    advisoryInfoDto.setCourseNumber(course.getNumber());
                }
                if (advisoryInfoDto.getAdvisoryType().equals(AdvisoryType.CLASS_COURSE_ADVISORY.getCode())) {
                    TeacherClassCourse classCourse = teacherClassCourseMap.get((long)orgStudentAdvisory.getCourseId());
                    if (classCourse != null) {
                        advisoryInfoDto.setClassCourseNumber(classCourse.getNumber());
                        advisoryInfoDto.setCourseName(classCourse.getName());
                    }
                } else if (advisoryInfoDto.getAdvisoryType().equals(AdvisoryType.ORG_ADVISORY.getCode())) {
                    advisoryInfoDto.setCourseName(AdvisoryType.ORG_ADVISORY.getNote());
                }
                advisoryInfoDto.setWords(orgStudentAdvisory.getWords());
                advisoryInfoDtos.add(advisoryInfoDto);
            }
        }
    }

    private void buildAdvisoryInfoDto(AdvisoryInfoDto advisoryInfoDto, OrgStudentAdvisory orgStudentAdvisory, Long orgNumber) {
        advisoryInfoDto.setOrgNumber(orgNumber);
        advisoryInfoDto.setAdvisoryId(orgStudentAdvisory.getId());
        advisoryInfoDto.setAdvisoryStatusEnum(AdvisoryStatus.getTypeByCode((Integer)orgStudentAdvisory.getStatus()));
        if (orgStudentAdvisory.getContentType().equals(AdvisoryType.TRIAL_COURSE.getTable())) {
            advisoryInfoDto.setAdvisotryTypeEnum(AdvisoryType.getTypeByCode((Integer)orgStudentAdvisory.getAdvisoryType()));
        } else {
            advisoryInfoDto.setAdvisotryTypeEnum(AdvisoryType.getTypeByCode((String)orgStudentAdvisory.getContentType()));
        }
        advisoryInfoDto.setCreateTime(orgStudentAdvisory.getCreateTime());
        advisoryInfoDto.setCourseId(orgStudentAdvisory.getCourseId());
    }
}

