
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.marketing.smsGroupSend.dto;

import com.baijia.tianxiao.dal.activity.po.SmsGroupSend.SmsGroupSendRecord;
import com.baijia.tianxiao.util.GenericsUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Lists;
import lombok.Data;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time Aug 17, 2016
 * @desc
 */
@Data
public class SmsGroupSendListDto implements Cloneable {

    public static final Integer truncatureContentLength = 20;
    public static final Integer truncatureNameLength = 20;
    public static final String splitSymbol = "、";

    private Long recordId;
    private Long sendTime;
    private String receivers; // 所有发送者拼凑的字符 , 记得进行缓存
    private String content;
    private Integer count; // 发送的人数

    @JsonIgnore
    private String truncatureNamesStr;
    @JsonIgnore
    private String truncatureContentStr;

    public static SmsGroupSendListDto newInstance(SmsGroupSendRecord record) {
        return newInstance(record, null);
    }

    /**
     * @param record
     * @param
     * @return
     */
    public static SmsGroupSendListDto newInstance(SmsGroupSendRecord record, List<StudentDto> studentLists) {
        SmsGroupSendListDto ret = new SmsGroupSendListDto();
        ret.setRecordId(record.getId());
        Timestamp time = record.getSendTime();
        if (time != null) {
            ret.setSendTime(time.getTime());
        }
        String content = record.getContent();
        content = GenericsUtils.isNullOrEmpty(content) ? "EMPTY CONTENT" : content;
        ret.setContent(record.getContent());
        ret.setCount(record.getTotalCount());
        if (content.length() > truncatureContentLength) {
            ret.setTruncatureContentStr(content.substring(0, truncatureContentLength));
        }
        if (GenericsUtils.notNullAndEmpty(studentLists)) {
            if (ret.getCount() == null || ret.getCount() == 0) {
                ret.setCount(studentLists.size());
            }
            String extractReceiverNames = SmsGroupSendRequest.extractReceiverNames(studentLists);
            ret.setReceivers(extractReceiverNames);
            if (studentLists.size() > truncatureNameLength) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < truncatureNameLength; i++) {
                    sb.append(studentLists.get(i).getName()).append(splitSymbol);
                }
                ret.setTruncatureNamesStr(GenericsUtils.deleteLastCharToString(sb));
            }
        }
        return ret;
    }

    /**
     * clone对象避免客户代码对缓存进行修改
     * 
     * @param dtos
     * @return
     */
    public static List<SmsGroupSendListDto> buildTurncatureResp(List<SmsGroupSendListDto> dtos) {
        if (GenericsUtils.isNullOrEmpty(dtos)) {
            return Collections.emptyList();
        }
        List<SmsGroupSendListDto> retDtos = new ArrayList<SmsGroupSendListDto>(dtos.size());
        // 可能存在发送人数过多或短信内容过长，导致网络传输的数据较大，所以这里进行截取,guava 返回的是不可变对象
        for (SmsGroupSendListDto dto : dtos) {
            SmsGroupSendListDto newDto = (SmsGroupSendListDto) dto.clone();
            if (GenericsUtils.notNullAndEmpty(newDto.getTruncatureContentStr())) {
                newDto.setContent(newDto.getTruncatureContentStr());
            }
            if (GenericsUtils.notNullAndEmpty(dto.getTruncatureNamesStr())) {
                newDto.setReceivers(newDto.getTruncatureNamesStr());
            }
            retDtos.add(newDto);
        }
        return retDtos;
    }

    public Object clone() {
        try {
            return super.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return null;
    }

}
