package com.baijia.tianxiao.sal.marketing.referral.dto;

import java.util.Collections;
import java.util.List;

import com.baijia.tianxiao.dal.activity.po.referral.GiftInfo;
import com.baijia.tianxiao.sal.marketing.commons.utils.JsonUtil;
import com.baijia.tianxiao.util.GenericsUtils;

/**
 * @author Rezar
 * @createDate :Mar 2, 2016 4:05:24 PM
 * @desc :
 */
public class ReferralRequest extends ReferralBaseInfo {

    private String gifts;
    private Long lastId;
    private String email;
    private String month;
    private Integer status;

    private String settleMentedMonth;
    private String needSettleMentedMonth;

    public List<GiftInfo> buildGiftInfos(Long...activityId) {
        if (GenericsUtils.notNullAndEmpty(gifts)) {
            List<GiftInfo> retList = JsonUtil.buildOptions(gifts, GiftInfo.class);
            if (GenericsUtils.notNullAndEmpty(activityId)) {
                Long activityId_ = activityId[0];
                for (GiftInfo giftInfo : retList) {
                    giftInfo.setActivityId(activityId_);
                }
            }
            return retList;
        } else {
            return Collections.emptyList();
        }
    }

    public String getSettleMentedMonth() {
        return settleMentedMonth;
    }

    public void setSettleMentedMonth(String settleMentedMonth) {
        this.settleMentedMonth = settleMentedMonth;
    }

    public String getNeedSettleMentedMonth() {
        return needSettleMentedMonth;
    }

    public void setNeedSettleMentedMonth(String needSettleMentedMonth) {
        this.needSettleMentedMonth = needSettleMentedMonth;
    }

    public String getMonth() {
        return month;
    }

    public void setMonth(String month) {
        this.month = month;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getGifts() {
        return gifts;
    }

    public void setGifts(String gifts) {
        this.gifts = gifts;
    }

    public Long getLastId() {
        return lastId;
    }

    public void setLastId(Long lastId) {
        this.lastId = lastId;
    }

    @Override
    public String toString() {
        return "ReferralRequest [gifts=" + gifts + ", lastId=" + lastId + ", email=" + email + ", month=" + month
            + ", status=" + status + ", settleMentedMonth=" + settleMentedMonth + ", needSettleMentedMonth="
            + needSettleMentedMonth + "]";
    }

}
