
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.marketing.commons.utils;

import com.baijia.tianxiao.util.GenericsUtils;

import lombok.extern.slf4j.Slf4j;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time Aug 25, 2016
 * @Desc this guy is too lazy, nothing left.
 */
@Slf4j
public class SmsUtils {

    /**
     * 计算短信的条数 <br/>
     * 
     * 手机短信收发有三种方式：Block方式、Text方式和PDU方式，前两种在国内很少使用，PDU格式则普遍支持。<br/>
     * 内容总长度140个字节（1120位），支持采用三种编码方式：7-bit、8-bit和UCS2编码， <br/>
     * 
     * 7-bit编码——用于发送普通的ASCII字符，ASCII码表最大到0x7X，最高位为0，总7-bit，<br/>
     * 实际编码时则可把8-bit的最高位比特使用起来，所以可支持1120/7=160个字符；<br/>
     * 
     * 8-bit编码——用于发送数据消息，比如图片和铃声、二进制数据等，此类数据无法使用7-bit编码，<br/>
     * 因为那样会丢掉一位，也不能用下面UCS2编码，因为不符合UNICODE编码检查（范围）。8-bit编码最多支持140个字节数据。<br/>
     * 
     * UCS2编码——用于发送Unicode字符，每个中文（韩文、日文），占用2字节，<br/>
     * 只要短信里包含这些多字节编码文字，那么即使还有英文，英文也需要安装UCS2编码，<br/>
     * 也占用2字节，所以，最多支持70个中文字（或中英混合短信）<br/>
     * 
     * 总之，只要含有中文（日文、韩文等），就需要使用多字节编码方式，<br/>
     * 若编码采用UCS2格式，1中文字占2字节，则可容纳70个中文字，<br/>
     * 如果是纯英文，将默认使用7bit编码方式（注意是7bit编码），则可容纳(140*8)/7=160个字符
     * 
     * @param content
     * @return
     */

    public static final int UCS2_LENGTH = 70; // (140 * 8) / 8 / 2 字节(中文占两个字节)
    public static final int _7_BIT_LENGTH = 160; // (140 * 8 ) / 7 字节(对应160个字符)

    public static int countContentSimple(String content) {
        if (GenericsUtils.isNullOrEmpty(content)) {
            return 0;
        }
        char[] chars = content.trim().toCharArray();
        boolean isAllUS = true;
        int contentLength = chars.length;
        for (char ch : chars) {
            if (CharUtils.isChineseChar(ch)) {
                if (isAllUS) {
                    isAllUS = false;
                    break;
                }
            }
        }
        int singleSmsLimit = UCS2_LENGTH;
        if (isAllUS) {
            singleSmsLimit = -_7_BIT_LENGTH;
        }
        int dev = contentLength / singleSmsLimit;
        return ((contentLength % singleSmsLimit == 0) ? dev : dev + 1);
    }

    public static int countContent(String content) {
        if (GenericsUtils.isNullOrEmpty(content)) {
            return 0;
        }
        boolean isAllEng = CharUtils.isAllUS(content);
        content = content.trim();
        char[] charArray = content.toCharArray();
        int singleSmsLimit = UCS2_LENGTH;
        int contentLength = 0;
        if (isAllEng) {
            contentLength = charArray.length;
            singleSmsLimit = _7_BIT_LENGTH;
        } else {
            contentLength = charArray.length * 2;
        }
        log.info("sms content's length is :{}(byte)", contentLength);
        int dev = contentLength / singleSmsLimit;
        return ((contentLength % singleSmsLimit == 0) ? dev : dev + 1);
    }
}
