package com.baijia.tianxiao.sal.marketing.article.service.impl;

import com.baijia.tianxiao.dto.upload.UploadResult;
import com.baijia.tianxiao.dto.upload.UploadResult.UploadFile;
import com.baijia.tianxiao.sal.marketing.article.service.ImageFileService;
import com.baijia.tianxiao.sal.marketing.commons.constants.Config;
import com.baijia.tianxiao.sal.marketing.vote.utils.FileUploadUtils;
import com.baijia.tianxiao.sal.marketing.vote.utils.FileUtils;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.springframework.stereotype.Service;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import lombok.extern.slf4j.Slf4j;

/**
 * @author Rezar
 * @createDate :Mar 28, 2016 10:01:49 AM
 * @desc :
 */
@Service
@Slf4j
public class ImageFileServiceImpl implements ImageFileService {

    public File download(String src) {
        if (GenericsUtils.isNullOrEmpty(src)) {
            return null;
        }
        FileOutputStream output = null;
        File storeFile = null;
        try {
            byte[] download = HttpClientUtils.download(src);
            storeFile = FileUtils.getTemplateFile(System.currentTimeMillis() + "_" + Math.random() * 1000000 + ".png");
            output = new FileOutputStream(storeFile);
            // 得到网络资源的字节数组,并写入文件
            output.write(download);
        } catch (Exception e) {
            log.info("[Download] Exception. and not will change the image url", e);
        } finally {
            try {
                if (output != null) {
                    output.close();
                }
            } catch (IOException e) {
                log.error("[Download] IOException.", e);
            }
        }
        return storeFile;
    }

    @Override
    public Map<String, String> downloadAndUploadManys(List<String> srcs) {
        TreeMap<String, String> srcAndUrl = new TreeMap<>();
        TreeMap<String, File> storeFiles = new TreeMap<>();
        try {
            int size = srcs.size();
            int pageSize = 6;
            int totalPage = (size % pageSize == 0 ? (size / pageSize) : (size / pageSize + 1));
            for (int pageNum = 1; pageNum <= totalPage; pageNum++) {
                int firstIndex = ((pageNum - 1) * pageSize);
                int lastIndex = (firstIndex + pageSize);
                lastIndex = lastIndex > size ? size : lastIndex;
                List<String> subList = srcs.subList(firstIndex, lastIndex);
                log.info(" total image size is : {} ", subList.size());
                for (String src : subList) {
                    File downloadAndUpload = download(src);
                    if (downloadAndUpload != null) {
                        log.info("{src is : {} }", src);
                        log.info("local file is : {} ", downloadAndUpload.getAbsolutePath());
                        storeFiles.put(downloadAndUpload.getName(), downloadAndUpload);
                    }
                }
                try {
                    // 进行文件的上传操作
                    UploadResult uploadResult = FileUploadUtils.uploadFiles(null, storeFiles, false);
                    int resultCount = uploadResult.getFiles().size();
                    log.info("Result Count is : {} ", resultCount);
                    log.info("upload result is : {} ", ToStringBuilder.reflectionToString(uploadResult));
                    int index = 0;
                    for (UploadFile upload : uploadResult.getFiles()) {
                        srcAndUrl.put(subList.get(index++), Config.IMAGE_SERVER_HOST + upload.getUrl());
                    }
                } finally {
                    Collection<File> values = storeFiles.values();
                    for (File file : values) {
                        try {
                            file.delete();
                        } catch (Exception e) {
                            log.error("delete file fail !");
                        }
                    }
                    storeFiles.clear();
                }
            }
            return srcAndUrl;
        } catch (Exception e) {
            log.error("[Download] Batch download Exception", e);
        }
        return Collections.emptyMap();
    }

    @Override
    public String downloadAndUploadOne(String src) {
        String newSrc = this.downloadAndUploadManys(Arrays.asList(src)).get(src);
        if (GenericsUtils.isNullOrEmpty(newSrc)) {
            newSrc = src;
        }
        return newSrc;
    }

}
