/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.marketing.article.dto;

import com.baijia.tianxiao.sal.marketing.article.utils.UrlUtil;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import lombok.Data;

/**
 * @author gaodan
 * @createdate 2016年3月19日
 * @desc
 */
@Data
public class PicArticleDetailListDto {
    private long id;
    private String mediaId;
    private int mediaType = 5;
    private List<ArticleInfo> newsItem;

    /**
     * 与微信返回的结果保持一致
     */
    @Data
    public static class ArticleInfo {
        private String title;
        private String thumb_media_url;
        private String author;
        private String digest;
        private String url;
        private String show_cover_pic;
        private String content_source_url;
    }

    public List<ArticleInfo> createArticleInfoListByBaseDtos(List<ArticleBaseDto> dtos) {
        if (dtos == null || dtos.size() < 1) {
            return Collections.emptyList();
        }
        List<ArticleInfo> list = new ArrayList<>();
        for (ArticleBaseDto baseDto : dtos) {
            ArticleInfo info = new ArticleInfo();
            info.setTitle(baseDto.getTitle());
            info.setShow_cover_pic("1");
            info.setThumb_media_url(baseDto.getThumbNail());
            info.setUrl(UrlUtil.getH5Url(baseDto.getArticleId()));
            info.setContent_source_url(info.getUrl());
            list.add(info);
        }
        return list;
    }
}
