package com.baijia.tianxiao.sal.marketing.vote.utils;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;

import com.baijia.tianxiao.util.GenericsUtils;

import lombok.extern.slf4j.Slf4j;


/**
 * @author Rezar
 * @createDate :Dec 30, 2015 5:54:13 PM
 * @desc :
 */
@Slf4j
public class FileUtils {

    public static File getTemplateFile(String fileName) {
        if (GenericsUtils.isNullOrEmpty(fileName)) {
            fileName = System.currentTimeMillis() + "_" + Math.random() * 1000000 + ".file";
        }
        String property = System.getProperty("java.io.tmpdir");
        File file = new File(property);
        File newFile = new File(file, fileName);
        try {
            newFile.createNewFile();
        } catch (IOException e) {
            e.printStackTrace();
            log.error("{# error while create a new file cause by : {} #}", e);
        }
        return newFile;
    }

    public static File[] listFileByPath(String classFilePath, FileFilter fileFilter) {
        URL url = getFileUrl(classFilePath);

        String fileDir = url.getFile();
        System.out.println(fileDir);
        File f = new File(fileDir);
        File[] files = f.listFiles(fileFilter);
        return files;
    }

    public static URL getFileUrl(String classFilePath) {
        URL url = FileUtils.class.getResource(classFilePath);
        return url;
    }

    public static File getFile(String classFilePath) {
        URL url = getFileUrl(classFilePath);
        if (url != null) {
            String filePath = url.getFile();
            return new File(filePath);
        } else {
            return null;
        }
    }
}
