package com.baijia.tianxiao.sal.marketing.vote.dto;

import java.util.List;

import org.springframework.beans.BeanUtils;

import com.baijia.tianxiao.dal.activity.po.vote.VoteInfo;
import com.baijia.tianxiao.sal.marketing.commons.constants.Config;

import lombok.Data;

/**
 * Created by liuxp on 16/2/22.
 */
@Data
public class VoteInfoResponse extends VoteInfoDto {
    private List<VoteOptionDto> voteOptions;
    private Integer browseCount; // 浏览人数
    private Integer userCount; // 活动的参与人数
    private Integer voteCount; // 投票总人数
    private String url;// 访问url
    private String shareUrl;// 分享url

    public static VoteInfoResponse getVoteInfoResponse(VoteInfo info) {
        VoteInfoResponse response = new VoteInfoResponse();
        BeanUtils.copyProperties(info, response, "startTime", "endTime");
        response.setStartTime(info.getStartTime().getTime());
        response.setEndTime(info.getEndTime().getTime());
        response.setBrowseCount(0);
        response.setUserCount(0);
        response.setVoteCount(0);
        String url = Config.DOMAIN + Config.VOTE_CURRENT_HOST + "?activityId=" + info.getActivityId() + "#!/";
        response.setUrl(url);
        return response;
    }
}
