
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.marketing.utils;

import java.io.IOException;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.dto.WebResponse;
import com.baijia.tianxiao.sal.marketing.commons.constants.Config;
import com.baijia.tianxiao.sal.marketing.smsGroupSend.dto.CourseDto;
import com.baijia.tianxiao.sal.marketing.smsGroupSend.dto.SmsGroupSendResp;
import com.baijia.tianxiao.sal.marketing.smsGroupSend.dto.StudentDto;
import com.baijia.tianxiao.util.GenericsUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import lombok.extern.slf4j.Slf4j;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time Aug 23, 2016
 * @Desc this guy is too lazy, nothing left.
 */
@SuppressWarnings("unchecked")
@Slf4j
public class MarketingWebResponse extends WebResponse<Object> {

    private static final long serialVersionUID = 6851388595876586409L;

    public static boolean canLogWithResponse = false;

    static {
        String env = Config.SYSTEM_ENV;
        if (env == null || !env.equalsIgnoreCase("online")) {
            canLogWithResponse = true;
        }
    }

    private boolean dataIsList = false;

    private Object dataToListValue = null;

    private boolean nullToRemove;

    private Map<String, Object> outerDataMap = Maps.newHashMap();

    private MarketingWebResponse() {

    }

    public MarketingWebResponse(Object data) {
        paddingData(data);
    }

    /**
     * 
     * @param errorCode
     */
    public MarketingWebResponse(UniverseErrorCode errorCode) {
        super(errorCode);
    }

    /**
     * 请求错误，通过错误码和自定义的错误信息来定义返回结果
     * 
     * @param errorCode
     * @param msg
     */
    public MarketingWebResponse(UniverseErrorCode errorCode, String msg) {
        super(errorCode, msg);
    }

    private void paddingData(Object data) {
        if (super.getData() != null && !this.dataIsList) {
            paddingDataFromObj(data);
            return;
        }
        if (!checkoutIsArray(data)) {
            super.setData(new HashMap<>());
            this.paddingDataFromObj(data);
        } else {
            super.setData(data);
            dataIsList = true;
        }
    }

    /**
     * @param data
     * @return
     */

    private boolean checkoutIsArray(Object data) {
        if (data == null) {
            return false;
        }
        return (data instanceof Collection<?>) || data.getClass().isArray() || (data instanceof Iterable<?>);
    }

    /**
     * @param data
     */
    private void paddingDataFromObj(Object data) {
        getSuperDataMap().putAll(ObjectReflectUtil.getFieldValues(data));
    }

    public void setData(Object data) {
        this.addData(data);
    }

    public MarketingWebResponse addData(Object data) {
        this.paddingData(data);
        return this;
    }

    public MarketingWebResponse addInnerData(String key, Object data) {
        if (dataIsList) {
            throw new UnsupportedOperationException("当前数据为列表数据，无法进行其余数据的填充");
        } else {
            if (super.getData() instanceof Map) {
                ((Map<String, Object>) super.getData()).put(key, data);
            }
        }
        return this;
    }

    public MarketingWebResponse addOuterData(String key, Object data) {
        this.outerDataMap.put(key, data);
        return this;
    }

    public MarketingWebResponse removeInnerData(String key) {
        if (dataIsList) {
            throw new UnsupportedOperationException("当前数据为列表数据，无法进行其余数据的填充");
        } else {
            if (super.getData() instanceof Map) {
                ((Map<String, Object>) super.getData()).remove(key);
            }
        }
        return this;
    }

    public MarketingWebResponse removeInnerDatas(String...keys) {
        this.removeKey(false, keys);
        return this;
    }

    public MarketingWebResponse removeOutterDatas(String...keys) {
        this.removeKey(true, keys);
        return this;
    }

    private void removeKey(boolean isOutter, String...keys) {
        if (GenericsUtils.notNullAndEmpty(keys)) {
            for (String key : keys) {
                if (isOutter) {
                    this.removeOuterData(key);
                } else {
                    this.removeInnerData(key);
                }
            }
        }
    }

    public MarketingWebResponse nullToRemove(boolean nullToRemove) {
        this.nullToRemove = nullToRemove;
        return this;
    }

    public MarketingWebResponse replcaeFromInnerData(String key) {
        Object innerData = this.removeKey(key, false);
        this.addOuterData(key, innerData);
        return this;
    }

    public MarketingWebResponse replaceFromOutterData(String key) {
        Object outterData = this.removeKey(key, true);
        this.addInnerData(key, outterData);
        return this;
    }

    /**
     * 默认是内部data的数据填充外部data属性
     * 
     * @param key
     * @return
     */
    public MarketingWebResponse dataToList(String key) {
        if (!this.dataIsList) {
            dataToListValue = this.getKey(key, false);
        }
        return this;
    }

    private Object removeKey(String key, boolean isOutter) {
        Object keyValue = this.getKey(key, isOutter);
        if (keyValue != null) {
            if (isOutter) {
                this.removeOuterData(key);
            } else {
                this.removeInnerData(key);
            }
        }
        return keyValue;
    }

    /**
     * @param key
     * @param b
     * @return
     */
    private Object getKey(String key, boolean isOutter) {
        if (!isOutter && !this.dataIsList) {
            Map<String, Object> dataMap = getSuperDataMap();
            return dataMap.get(key);
        }
        return this.outerDataMap.get(key);
    }

    private Map<String, Object> getSuperDataMap() {
        Map<String, Object> dataMap = (Map<String, Object>) super.getData();
        return dataMap;
    }

    public MarketingWebResponse dataToListFromOuter(String key) {
        this.dataToListValue = getKey(key, true);
        return this;
    }

    public MarketingWebResponse removeOuterData(String key) {
        this.outerDataMap.remove(key);
        return this;
    }

    public MarketingWebResponseMap toWebResponse() {
        this.outerDataMap.put("code", super.getCode());
        this.outerDataMap.put("msg", super.getMsg());
        Object superData = super.getData();
        Map<String, Object> tempOuterMap = this.outerDataMap;
        if (this.nullToRemove) {
            tempOuterMap = removeNullKeys(this.outerDataMap);
            if (!this.dataIsList) {
                superData = removeNullKeys(this.getSuperDataMap());
            }
        }
        if (this.dataToListValue != null) {
            tempOuterMap.put("data", this.dataToListValue);
        } else {
            tempOuterMap.put("data", superData);
        }
        return MarketingWebResponseMap.newInstance(tempOuterMap);
    }

    public MarketingWebResponseMap toWebResponseWithLog() {

        MarketingWebResponseMap respMap = this.toWebResponse();
        if (canLogWithResponse) {
            ObjectMapper objectMapper = new ObjectMapper();
            StringWriter writer = new StringWriter();
            try {
                objectMapper.writeValue(writer, respMap);
                log.info("[response : ] {}", JsonFormatUtil.formatJson(writer.toString()));
                writer.close();
            } catch (IOException e) {
                log.info("can not writeValue from obj: {} ", respMap);
            }
        }
        return respMap;
    }

    /**
     * @param valueMap
     */
    private Map<String, Object> removeNullKeys(Map<String, Object> valueMap) {
        Map<String, Object> tempMap = Maps.newHashMap(valueMap);
        try {
            List<String> removeKeys = Lists.newArrayList();
            for (String key : tempMap.keySet()) {
                if (tempMap.get(key) == null) {
                    removeKeys.add(key);
                }
            }
            for (String key : removeKeys) {
                tempMap.remove(key);
            }
        } catch (Exception e) {
            log.error("error while removeNullKey L {}", e);
        }
        return tempMap;
    }

    public MarketingWebResponse addMsg(String msg) {
        super.setMsg(msg);
        return this;
    }

    public MarketingWebResponse addCode(UniverseErrorCode code) {
        super.setErrorCode(code);
        return this;
    }

    public MarketingWebResponse addCode(int code) {
        super.setCode(code);
        return this;
    }

    public static MarketingWebResponse build() {
        return new MarketingWebResponse();
    }

    public static MarketingWebResponse build(Object data) {
        return new MarketingWebResponse(data);
    }

    public static void main(String[] args) {

        SmsGroupSendResp dto = new SmsGroupSendResp();
        List<CourseDto> courseDtos = Lists.newArrayList();
        courseDtos.add(new CourseDto());
        courseDtos.add(new CourseDto());
        courseDtos.add(new CourseDto());
        dto.setCourses(courseDtos);

        List<StudentDto> studentDtos = Lists.newArrayList();
        studentDtos.add(new StudentDto());
        studentDtos.add(new StudentDto());
        studentDtos.add(new StudentDto());
        dto.setStudents(studentDtos);

        MarketingWebResponse resp = MarketingWebResponse.build().addData(dto).nullToRemove(true);
        resp.toWebResponseWithLog();
    }

}
