package com.baijia.tianxiao.sal.marketing.referral.dto;

import org.springframework.beans.BeanUtils;

import com.baijia.tianxiao.dal.activity.po.referral.ReferralRecord;

import lombok.Data;

/**
 * Created by liuxp on 16/3/4.
 */
@Data
public class ReferralCustomer {
    private Long id;
    private String referralName;
    private String referralPhone;
    private String referralDesc;
    private String brokerName;
    private String brokerPhone;
    private long giftId;
    private long createTime;
    private String giftDesc;
    private int status;// 1:未结算，2：已结算

    public static ReferralCustomer getInstanceFromRecord(ReferralRecord record) {
        ReferralCustomer customer = new ReferralCustomer();
        BeanUtils.copyProperties(record, customer, "createTime");
        customer.setCreateTime(record.getCreateTime().getTime());
        customer.setStatus(record.getSettlementStatus());
        return customer;
    }
}
