package com.baijia.tianxiao.sal.marketing.referral.dto;

import java.sql.Timestamp;
import java.util.Date;

import org.springframework.beans.BeanUtils;

import com.baijia.tianxiao.dal.activity.enums.ActivityStatus;
import com.baijia.tianxiao.dal.activity.po.referral.ReferralInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;

import lombok.Data;

/**
 * @author Rezar
 * @createDate :Mar 2, 2016 2:41:28 PM
 * @desc :
 */
@Data
public class ReferralBaseInfo {

    private Long activityId;
    @JsonIgnore
    private Long orgId;
    private String title;
    private String subTitle;
    private Integer countLimit;
    private Long startTime;
    private Long endTime;
    private Long updateTime;
    private Long createTime;
    private Integer status;
    private String topPicUrl;
    private String contact;
    private Long templateId;

    private Integer browseCount;
    private Integer brokerNum;
    private Integer customerNum;
    private Integer toPayAmount;
    
    private Integer delStatus; //0未删除 1已删除

    public static final String REGEX = "\\n";

    public ReferralInfo buildPo() {
        ReferralInfo po = new ReferralInfo();
        BeanUtils.copyProperties(this, po, "startTime", "endTime");
        String contact = po.getContact();
        // solveContact(contact);
        if (this.getStartTime() != null && this.getStartTime() > 0) {
            po.setStartTime(new Timestamp(this.getStartTime()));
        }
        if (this.getEndTime() != null && this.getEndTime() > 0) {
            po.setEndTime(new Timestamp(this.getEndTime()));
        }
        return po;
    }

    private static String solveContact(String contact) {
        String replace = contact.replaceAll(REGEX, "</br>");
        return replace;
    }

    public static void main(String[] args) {
        String contact = "www.tast.\nfdhfdsafd";
        System.out.println(solveContact(contact));
    }

    public static ReferralBaseInfo buildDto(ReferralInfo info) {
        ReferralBaseInfo rbi = new ReferralBaseInfo();
        BeanUtils.copyProperties(info, rbi);
        rbi.setUpdateTime(info.getUpdateTime().getTime());
        rbi.setCreateTime(info.getCreateTime().getTime());
        rbi.setStartTime(info.getStartTime().getTime());
        rbi.setEndTime(info.getEndTime().getTime());
        checkStatus(info, rbi);
        return rbi;
    }

    public static void checkStatus(ReferralInfo info, ReferralBaseInfo rbi) {
        if (info.getStatus().intValue() == ActivityStatus.CLOSED.getCode()) {
            rbi.setStatus(info.getStatus());
        } else {
            if (info.getStartTime().after(new Date())) {
                rbi.setStatus(ActivityStatus.UN_START.getCode());
            } else if (info.getEndTime().before(new Date())) {
                rbi.setStatus(ActivityStatus.END.getCode());
            } else {
                rbi.setStatus(ActivityStatus.RUNNING.getCode());
            }
        }
    }

}
