package com.baijia.tianxiao.sal.marketing.commons.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.univocity.parsers.csv.CsvWriter;
import com.univocity.parsers.csv.CsvWriterSettings;

/**
 * @author Rezar
 * @createDate :Jan 12, 2016 5:31:08 PM
 * @desc :
 */
public class CsvUtils {

    private static Logger logger = LoggerFactory.getLogger(CsvUtils.class);

    public static String getRandomString(int length) { // length表示生成字符串的长度
        String base = "abcdefghijklmnopqrstuvwxyz0123456789";
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; i++) {
            int number = random.nextInt(base.length());
            sb.append(base.charAt(number));
        }
        return sb.toString();
    }

    public static File writerToCsvFile(File outputFile, CsvContent csvContent, String fileName) {
        if (!fileName.endsWith(".csv")) {
            fileName += ".csv";
        }

        File file = null;
        if (outputFile != null) {
            file = outputFile;
        } else {
            file = new File(System.getProperty("java.io.tmpdir") + File.separator + fileName);
        }
        if (!file.exists()) {
            try {
                file.createNewFile();
            } catch (IOException e) {
                logger.error("error : ", e);
                throw new RuntimeException("can not create new file with filepaht :" + file.getAbsolutePath());
            }
        }
        Writer outputWriter = null;
        try {
            byte[] bom = { (byte) 0xEF, (byte) 0xBB, (byte) 0xBF };
            OutputStream outputStream = new FileOutputStream(file);
            outputStream.write(bom);
            outputWriter = new OutputStreamWriter(outputStream);
            CsvWriterSettings settings = new CsvWriterSettings();
            // Sets the character sequence to write for the values that are null.
            settings.setNullValue("?");
            // Changes the comment character to -
            settings.getFormat().setComment('-');
            // Sets the character sequence to write for the values that are empty.
            settings.setEmptyValue("!");
            // writes empty lines as well.
            settings.setSkipEmptyLines(false);
            // Creates a writer with the above settings;
            CsvWriter writer = new CsvWriter(outputWriter, settings);
            List<RowBean> rowBeans = csvContent.getAllRows();
            if (rowBeans != null && rowBeans.size() > 0) {
                for (RowBean rowBean : rowBeans) {
                    if (rowBean.type == RowBean.rowType) {
                        String lineText = rowBean.getContent();
                        writer.writeRow(lineText);
                    } else if (rowBean.type == RowBean.tableType) {
                        String[] heads = rowBean.getHeads();
                        List<String> rows = rowBean.getRows();
                        // writes the file headers
                        writer.writeHeaders(heads);
                        // Let's write the rows one by one (the first row will be skipped)
                        for (int i = 0; i < rows.size(); i++) {
                            // writes the row
                            writer.writeRow(rows.get(i));
                        }
                    }
                }
            }
            writer.close();
        } catch (Exception ex) {
            logger.info("can not create csv file ,{}", ex);
        } finally {
            IOUtils.closeQuietly(outputWriter);
        }
        return file;
    }

    public static class CsvContent {
        private List<RowBean> rowBeans = new ArrayList<>();

        public void addRowBean(RowBean rb) {
            rowBeans.add(rb);
        }

        public void deleteRowBean(RowBean rowBean) {
            rowBeans.remove(rowBean);
        }

        public List<RowBean> getAllRows() {
            return this.rowBeans;
        }
    }

    public static class RowBean {
        public static final Integer rowType = 1;
        public static final Integer tableType = 2;
        private Integer type;
        private String content;
        private String[] heads;
        private List<String> rows;

        public static RowBean createRowType(String rowText) {
            RowBean rb = new RowBean();
            rb.setType(1);
            rb.setContent(rowText);
            return rb;
        }

        /**
         * 数据段使用- 进行分割
         * 
         * @param hreds
         * @param rows
         * @return
         */
        public static RowBean createTableType(String[] heads, List<String> rows) {
            RowBean rb = new RowBean();
            rb.setType(RowBean.tableType);
            rb.setHeads(heads);
            rb.setRows(rows);
            return rb;
        }

        public Integer getType() {
            return type;
        }

        public void setType(Integer type) {
            this.type = type;
        }

        public String getContent() {
            return content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public String[] getHeads() {
            return heads;
        }

        public void setHeads(String[] heads) {
            this.heads = heads;
        }

        public List<String> getRows() {
            return rows;
        }

        public void setRows(List<String> rows) {
            this.rows = rows;
        }

    }


}
