/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.marketing.commons.enums;

import java.util.ArrayList;
import java.util.List;

/**
 * @author gaodan
 * @createdate 2016年9月7日
 * @desc
 */
public enum MarketingEntryEnventEnum {
    COMMON_ACTIVITY("微活动", "tx_event_send_activity"),
    VOTE_ACTIVITY("投票", "tx_event_vote"),
    DRAW_ACTIVITY("抽奖", "tx_event_draw"),
    REFERRAL_ACTIVITY("转介绍", "tx_event_referral"),
    ACTIVITY_MERGE_ENVENT("四合一混合接口", "tx_event_activity_merge");
    
    private String label;
    private String event;
    private MarketingEntryEnventEnum(String label, String event){
        this.label = label;
        this.event = event;
    }
    
    public String getLabel(){
        return this.label;
    }
    
    public String getEvent(){
        return this.event;
    }
    
  //获取四个活动（微活动，投票，转介绍，抽奖）event事件列表
    public static List<String> getActivityMarketingEntryEventList(){
        List<String> activityMarketingEntryEventList = new ArrayList<>();
        activityMarketingEntryEventList.add(MarketingEntryEnventEnum.COMMON_ACTIVITY.getEvent());
        activityMarketingEntryEventList.add(MarketingEntryEnventEnum.VOTE_ACTIVITY.getEvent());
        activityMarketingEntryEventList.add(MarketingEntryEnventEnum.DRAW_ACTIVITY.getEvent());
        activityMarketingEntryEventList.add(MarketingEntryEnventEnum.REFERRAL_ACTIVITY.getEvent());
        return activityMarketingEntryEventList;
    }

}
