package com.baijia.tianxiao.sal.marketing.activity.dto;

import java.sql.Timestamp;
import java.util.Date;
import java.util.List;

import com.baijia.tianxiao.sal.organization.org.dto.addressbook.TXAddressBookDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.baijia.tianxiao.dal.activity.po.Activity;
import com.baijia.tianxiao.dal.activity.po.ActivityConf;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.date.DateUtil;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

/**
 * @author Rezar
 * @createDate :Jan 10, 2016 10:53:51 PM
 * @desc :
 */
public class ActivityDetailDto extends ActivityBaseInfo {

    private static Logger logger = LoggerFactory.getLogger(ActivityConfigDto.class);
    private Long startTime;
    private Long endTime;
    private Long enrollDeadline;
    private Double longitude;
    private Double latitude;
    private String address;
    private Object content;
    private Integer countLimit;
    private Object customConf;
    private String url;




    public Long getStartTime() {
        return startTime;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public Long getEndTime() {
        return endTime;
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    public Long getEnrollDeadline() {
        return enrollDeadline;
    }

    public void setEnrollDeadline(Long enrollDeadline) {
        this.enrollDeadline = enrollDeadline;
    }

    public Double getLongitude() {
        return longitude;
    }

    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    public Double getLatitude() {
        return latitude;
    }

    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Object getContent() {
        return content;
    }

    public void setContent(Object content) {
        this.content = content;
    }

    public Integer getCountLimit() {
        return countLimit;
    }

    public void setCountLimit(Integer countLimit) {
        this.countLimit = countLimit;
    }

    public Object getCustomConf() {
        return customConf;
    }

    public void setCustomConf(Object customConf) {
        this.customConf = customConf;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public static List<ActivityDetailDto> toList(List<? extends Activity> retList) {
        return null;
    }

    public static ActivityDetailDto buildResponse(Activity activity, ActivityConf activityConf) {
        ActivityDetailDto ard = new ActivityDetailDto();
        fillActivityConf(activityConf, ard);
        fillActivity(activity, ard);
        return ard;
    }

    private static Long getTime(Timestamp time) {
        return time == null ? null : time.getTime();
    }

    public static ActivityDetailDto buildResponse(Activity activity) {
        ActivityDetailDto ard = new ActivityDetailDto();
        fillActivity(activity, ard);
        return ard;
    }

    public static ActivityDetailDto buildResponse(ActivityConf activityConf) {
        ActivityDetailDto ard = new ActivityDetailDto();
        fillActivityConf(activityConf, ard);
        return ard;
    }

    private static void fillActivity(Activity activity, ActivityDetailDto ard) {
        ard.setName(activity.getTitle());
        // logger.info("content is : {}", activity.getContent());
        ard.setContent(getContent(activity.getContent()));
        ard.setBrowseCount(activity.getSupportNum() == null ? 0 : activity.getSupportNum());
        ard.setId(activity.getId());
        ard.setCreateTime(DateUtil.getStrToDate("yyyy-MM-dd HH:mm:ss", activity.getCreateTime()).getTime());
        toleranceSetUpdateTime(activity, ard);
        if (ard.getEndTime() < new Date().getTime() && activity.getSwitcher() == 1) {
            ard.setStatus(0);
        } else {
            ard.setStatus(activity.getSwitcher());
        }
        ard.setIsDel(activity.getIsdel());
    }

    /**
     * 
     * @param content
     * @return
     */
    private static Object getContent(String content) {
        if (GenericsUtils.isNullOrEmpty(content)) {
            return "";
        }
        try {
            JSONArray arrayJson = JSONArray.fromObject(content);
            if (arrayJson != null) {
                return arrayJson;
            }
        } catch (Exception e) {
        }
        try {
            JSONObject objJson = JSONObject.fromObject(content);
            if (objJson != null) {
                return objJson;
            }
        } catch (Exception e) {
        }
        return content;
    }

    private static void fillActivityConf(ActivityConf activityConf, ActivityDetailDto ard) {
        ard.setEnrollCount(activityConf.getCountLimit());
        ard.setEnrollDeadline(getTime(activityConf.getReportEndTime()));
        ard.setStartTime(getTime(activityConf.getStartTime()));
        ard.setEndTime(getTime(activityConf.getEndTime()));
        ard.setLongitude(getDouble(activityConf.getLongitude()));
        ard.setLatitude(getDouble(activityConf.getLatitude()));
        ard.setAddress(activityConf.getAddress());
        ard.setCountLimit(activityConf.getCountLimit());
        // logger.info("customerConf is : {} ", activityConf.getCustomConf());
        Object objects = getCustomerConf(activityConf.getCustomConf());
        ard.setCustomConf(objects);
        ard.setTemplateTypeId(activityConf.getTemplateTypeId());
        ard.setTemplateId(activityConf.getTemplateId());
    }

    private static Object getCustomerConf(String customConf) {
        if (GenericsUtils.isNullOrEmpty(customConf)) {
            return "";
        }
        JSONArray objects = JSONArray.fromObject(customConf);
        if (objects == null) {
            return "";
        }
        return objects;
    }

    private static Double getDouble(String strNumber) {
        if (GenericsUtils.isNullOrEmpty(strNumber)) {
            return null;
        } else {
            try {
                return Double.parseDouble(strNumber);
            } catch (NumberFormatException e) {
                logger.info("can not parser str: {} to  double  ");
            }
        }
        return null;
    }
}
