package com.baijia.tianxiao.sal.marketing.vote.dto;

import com.baijia.tianxiao.dal.activity.enums.ActivityStatus;
import com.baijia.tianxiao.dal.activity.po.vote.VoteInfo;
import lombok.Data;

import java.util.Date;

/**
 * Created by liuxp on 16/2/22.
 */
@Data
public class VoteListDto extends VoteStatistics {
    private String name;
    private Long updateTime;
    private int status;
    private int templateId;

    public static VoteListDto getInstance(VoteInfo info){
        VoteListDto dto = new VoteListDto();
        dto.setActivityId(info.getActivityId());
        dto.setName(info.getName());
        dto.setUpdateTime(info.getUpdateTime().getTime());
        if(info.getStatus().intValue()== ActivityStatus.CLOSED.getCode()){
            dto.setStatus(info.getStatus());
        }else {
            if(info.getStartTime().after(new Date())){
                dto.setStatus(ActivityStatus.UN_START.getCode());
            }else if(info.getEndTime().before(new Date())){
                dto.setStatus(ActivityStatus.END.getCode());
            }else {
                dto.setStatus(ActivityStatus.RUNNING.getCode());
            }
        }
        dto.setTemplateId(info.getTemplateId());
        return dto;
    }
}
