package com.baijia.tianxiao.sal.marketing.referral.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.dal.activity.dao.referral.GiftInfoDao;
import com.baijia.tianxiao.dal.activity.po.referral.GiftInfo;
import com.baijia.tianxiao.sal.marketing.referral.service.GiftService;
import com.baijia.tianxiao.util.GenericsUtils;

/**
 * @author Rezar
 * @createDate :Mar 2, 2016 7:54:23 PM
 * @desc :
 */
@Service
public class GiftServiceImpl implements GiftService {

    @Autowired
    private GiftInfoDao giftInfoDao;

    @Override
    public void batchAdd(Long activityId, List<GiftInfo> gifts) {
        if (GenericsUtils.isNullOrEmpty(gifts)) {
            return;
        }
        for (GiftInfo giftInfo : gifts) {
            giftInfo.setActivityId(activityId);
            this.giftInfoDao.insertGiftInfo(giftInfo);
        }
    }

    @Override
    public void deleteGifts(Long activityId, List<Long> gifts) {
        this.giftInfoDao.deleteGifts(activityId, gifts);
    }

    @Override
    public List<GiftInfo> findGifts(Long activityId) {
        return this.giftInfoDao.selectGifts(activityId);
    }

    @Override
    public void modifyGifts(List<GiftInfo> gifts) {
        this.giftInfoDao.updateGifts(gifts);
    }

}
