package com.baijia.tianxiao.sal.marketing.commons.service.impl.mq;

import com.baijia.tianxiao.sal.marketing.commons.dtos.MnsDto;
import com.baijia.tianxiao.sal.marketing.commons.service.mq.MqService;
import com.baijia.tianxiao.util.properties.PropertiesReader;

import com.aliyun.mns.client.CloudAccount;
import com.aliyun.mns.client.CloudQueue;
import com.aliyun.mns.model.Message;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Service;

import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;

/**
 * Created by liuxp on 16/2/26.
 */
@Service
@Slf4j
public class MqServiceImpl implements MqService,InitializingBean {

    private CloudQueue consultMsgQueue;

    @Override
    public void pushMns(MnsDto msg,String prefix) {
        try{
            JSONObject json = JSONObject.fromObject(msg);
            consultMsgQueue.putMessage(new Message(prefix+json.toString()));
            log.info("put message to activityMsgQueue msg:{}", msg);
        }catch(Exception e){
            log.info("put message to activityMsgQueue - Exception - msg:{}", msg);
            log.info("put message to activityMsgQueue - Exception - e:{}", e);
        }
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        try{
            Properties mnsProperties = PropertiesReader.getProperties("mns.properties");
            CloudAccount cloudAccount = new CloudAccount(mnsProperties.getProperty("mns.accesskeyid"),
                    mnsProperties.getProperty("mns.accesskeysecret"),
                    mnsProperties.getProperty("mns.accountendpoint"));
            consultMsgQueue = cloudAccount.getMNSClient().getQueueRef(mnsProperties.getProperty("activity.msg.queue"));
        }catch(Exception e){
            log.error("init cloud account error. e:{}", e);
        }
    }
}
