/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.marketing.commons.service;

import com.baijia.tianxiao.dal.activity.po.ActivityConf;
import com.baijia.tianxiao.dal.activity.po.TxActivityCommon;
import com.baijia.tianxiao.sal.marketing.commons.dtos.ActivityAmountDto;
import com.baijia.tianxiao.sal.marketing.commons.dtos.TxActivityCommonFilterParams;
import com.baijia.tianxiao.sal.marketing.commons.dtos.TxActivityMergeDto;
import com.baijia.tianxiao.sal.marketing.commons.enums.TemplateTypeCategory;
import com.baijia.tianxiao.sal.marketing.commons.utils.TwoTuple;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;

import java.util.List;

/**
 * @author gaodan
 * @createdate 2016年8月22日
 * @desc
 */
public interface TxActivityCommonService {
    public List<TxActivityMergeDto> getTxActivityMergeDtoList(Long orgId, PageDto  pageDto, TxActivityCommonFilterParams filterParams);
    
    /**
     * 更新或者添加所有活动配置信息
     * @param conf 
     * @param activityInfo 活动详情
     * @param blackboardActivityConfInfo 当是发活动时 需要传这个参数，其他默认null
     * @param saveProp
     */
    public void saveOrUpdateTxActivityCommon(TxActivityCommon conf, TemplateTypeCategory templateTypeCategory, Object activityInfo, ActivityConf blackboardActivityConfInfo, String... saveProp);
    
    //将线上数据，包括微活动、抽奖、投票和转介绍同步到tx_activity_conf表中
    public void synchronousActivityData(Integer type);
    
    //获取机构活动数量信息
    public ActivityAmountDto getActivityAmountDto(Long orgId);
    
    //保存白金版信息
    public TwoTuple<Integer, String> saveConsultBaiJinInfo(Long orgId);
    
    //机构是免费版的话，需要判断机构创建的活动是否达到上线
    public void checkoutOrgActivityVipLevelAndAmount(Long orgId);
}
