/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.marketing.activity.service.impl;

import com.baijia.tianxiao.dal.activity.dao.ActivityAccessLogDao;
import com.baijia.tianxiao.dal.activity.dao.ActivityDao;
import com.baijia.tianxiao.dal.activity.dao.EnrollDao;
import com.baijia.tianxiao.sal.marketing.activity.dto.ActivityStatisticsData;
import com.baijia.tianxiao.sal.marketing.activity.service.ActivityDataExportService;
import com.baijia.tianxiao.sal.marketing.commons.enums.TemplateTypeCategory;
import com.baijia.tianxiao.util.GenericsUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActivityDataExportServiceImpl
implements ActivityDataExportService {
    private static final Logger log = LoggerFactory.getLogger(ActivityDataExportServiceImpl.class);
    @Autowired
    ActivityDao activityDao;
    @Autowired
    ActivityAccessLogDao activityAccessLogDao;
    @Autowired
    EnrollDao enrollDao;

    @Override
    public Map<Long, ActivityStatisticsData> getActivityData(Date startTime, Date endTime, String startDate, String curDate, List<Long> TianxiaoOrgIds, int way) {
        HashMap<Long, ActivityStatisticsData> activityDatas = new HashMap<Long, ActivityStatisticsData>();
        List orgIds = this.activityDao.getExistOrgIds(TianxiaoOrgIds);
        if (orgIds == null || orgIds.size() == 0) {
            return activityDatas;
        }
        Map activityIdsOfOrgIdByDay = this.activityDao.getActivityIdByOrgIds(orgIds, startTime, endTime);
        Map activityIdsOfOrgId = this.activityDao.getActivityIdByOrgIds(orgIds, null, null);
        for (Long orgId : orgIds) {
            List activityIds = (List)activityIdsOfOrgId.get(orgId);
            if (activityIds == null || activityIds.isEmpty()) continue;
            ActivityStatisticsData activityStaticData = new ActivityStatisticsData();
            Integer activityTotal = activityIdsOfOrgIdByDay == null || activityIdsOfOrgIdByDay.size() == 0 ? Integer.valueOf(0) : (GenericsUtils.isNullOrEmpty(activityIdsOfOrgIdByDay.get(orgId)) ? Integer.valueOf(0) : Integer.valueOf(((List)activityIdsOfOrgIdByDay.get(orgId)).size()));
            Integer browseCount = 0;
            browseCount = way == 3 ? this.activityAccessLogDao.getActivityAccessLogTotal(activityIds, Integer.valueOf(TemplateTypeCategory.COMMON_TYPE.getType())) : this.activityAccessLogDao.getActivityAccessLogTotalByDay(activityIds, Integer.valueOf(TemplateTypeCategory.COMMON_TYPE.getType()), startDate, curDate);
            Integer enrollCount = this.enrollDao.getEnrollTotal(activityIds, startTime, endTime);
            activityStaticData.setActivityTotal(activityTotal);
            activityStaticData.setBrowseCount(browseCount == null ? 0 : browseCount);
            activityStaticData.setEnrollCount(enrollCount == null ? 0 : enrollCount);
            activityDatas.put(orgId, activityStaticData);
        }
        return activityDatas;
    }
}

