/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.marketing.activity.dto;

import com.baijia.tianxiao.dal.activity.po.Activity;
import com.baijia.tianxiao.dal.activity.po.ActivityConf;
import com.baijia.tianxiao.sal.marketing.activity.dto.ActivityBaseInfo;
import com.baijia.tianxiao.sal.marketing.activity.dto.ActivityConfigDto;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.date.DateUtil;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityDetailDto
extends ActivityBaseInfo {
    private static Logger logger = LoggerFactory.getLogger(ActivityConfigDto.class);
    private Long startTime;
    private Long endTime;
    private Long enrollDeadline;
    private Double longitude;
    private Double latitude;
    private String address;
    private Object content;
    private Integer countLimit;
    private Object customConf;
    private String url;

    public Long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    public Long getEnrollDeadline() {
        return this.enrollDeadline;
    }

    public void setEnrollDeadline(Long enrollDeadline) {
        this.enrollDeadline = enrollDeadline;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Object getContent() {
        return this.content;
    }

    public void setContent(Object content) {
        this.content = content;
    }

    public Integer getCountLimit() {
        return this.countLimit;
    }

    public void setCountLimit(Integer countLimit) {
        this.countLimit = countLimit;
    }

    public Object getCustomConf() {
        return this.customConf;
    }

    public void setCustomConf(Object customConf) {
        this.customConf = customConf;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public static List<ActivityDetailDto> toList(List<? extends Activity> retList) {
        return null;
    }

    public static ActivityDetailDto buildResponse(Activity activity, ActivityConf activityConf) {
        ActivityDetailDto ard = new ActivityDetailDto();
        ActivityDetailDto.fillActivityConf(activityConf, ard);
        ActivityDetailDto.fillActivity(activity, ard);
        return ard;
    }

    private static Long getTime(Timestamp time) {
        return time == null ? null : Long.valueOf(time.getTime());
    }

    public static ActivityDetailDto buildResponse(Activity activity) {
        ActivityDetailDto ard = new ActivityDetailDto();
        ActivityDetailDto.fillActivity(activity, ard);
        return ard;
    }

    public static ActivityDetailDto buildResponse(ActivityConf activityConf) {
        ActivityDetailDto ard = new ActivityDetailDto();
        ActivityDetailDto.fillActivityConf(activityConf, ard);
        return ard;
    }

    private static void fillActivity(Activity activity, ActivityDetailDto ard) {
        ard.setName(activity.getTitle());
        ard.setContent(ActivityDetailDto.getContent(activity.getContent()));
        ard.setBrowseCount(activity.getSupportNum() == null ? 0 : activity.getSupportNum());
        ard.setId(activity.getId());
        ard.setCreateTime(DateUtil.getStrToDate((String)"yyyy-MM-dd HH:mm:ss", (String)activity.getCreateTime()).getTime());
        ActivityDetailDto.toleranceSetUpdateTime(activity, ard);
        if (ard.getEndTime() < new Date().getTime() && activity.getSwitcher() == 1) {
            ard.setStatus(0);
        } else {
            ard.setStatus(activity.getSwitcher());
        }
        ard.setIsDel(activity.getIsdel());
    }

    private static Object getContent(String content) {
        if (GenericsUtils.isNullOrEmpty((Object)content)) {
            return "";
        }
        try {
            JSONArray arrayJson = JSONArray.fromObject((Object)content);
            if (arrayJson != null) {
                return arrayJson;
            }
        }
        catch (Exception arrayJson) {
            // empty catch block
        }
        try {
            JSONObject objJson = JSONObject.fromObject((Object)content);
            if (objJson != null) {
                return objJson;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return content;
    }

    private static void fillActivityConf(ActivityConf activityConf, ActivityDetailDto ard) {
        ard.setEnrollCount(activityConf.getCountLimit());
        ard.setEnrollDeadline(ActivityDetailDto.getTime(activityConf.getReportEndTime()));
        ard.setStartTime(ActivityDetailDto.getTime(activityConf.getStartTime()));
        ard.setEndTime(ActivityDetailDto.getTime(activityConf.getEndTime()));
        ard.setLongitude(ActivityDetailDto.getDouble(activityConf.getLongitude()));
        ard.setLatitude(ActivityDetailDto.getDouble(activityConf.getLatitude()));
        ard.setAddress(activityConf.getAddress());
        ard.setCountLimit(activityConf.getCountLimit());
        Object objects = ActivityDetailDto.getCustomerConf(activityConf.getCustomConf());
        ard.setCustomConf(objects);
        ard.setTemplateTypeId(activityConf.getTemplateTypeId());
        ard.setTemplateId(activityConf.getTemplateId());
    }

    private static Object getCustomerConf(String customConf) {
        if (GenericsUtils.isNullOrEmpty((Object)customConf)) {
            return "";
        }
        JSONArray objects = JSONArray.fromObject((Object)customConf);
        if (objects == null) {
            return "";
        }
        return objects;
    }

    private static Double getDouble(String strNumber) {
        if (GenericsUtils.isNullOrEmpty((Object)strNumber)) {
            return null;
        }
        try {
            return Double.parseDouble(strNumber);
        }
        catch (NumberFormatException e) {
            logger.info("can not parser str: {} to  double  ");
            return null;
        }
    }
}

