/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.marketing.commons.utils;

import com.aliyun.mns.client.CloudAccount;
import com.aliyun.mns.client.CloudPullTopic;
import com.aliyun.mns.client.CloudQueue;
import com.aliyun.mns.client.CloudTopic;
import com.aliyun.mns.client.MNSClient;
import com.aliyun.mns.model.Message;
import com.aliyun.mns.model.QueueMeta;
import com.aliyun.mns.model.RawTopicMessage;
import com.aliyun.mns.model.TopicMessage;
import com.aliyun.mns.model.TopicMeta;
import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.sal.marketing.commons.exceptions.BusinessException;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import java.util.UUID;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MnsUtils {
    private static final Logger log = LoggerFactory.getLogger(MnsUtils.class);
    public static final int POLLING_WAIT_SECONDS = 15;
    private static final long MAX_MSG_SIZE = 2048L;
    private MNSClient client;
    private static MnsUtils mnsUtils;

    public static String getPrefix() {
        return MessageSource.SIGNUP.getValue() + "$";
    }

    private MnsUtils() {
        CloudAccount account = new CloudAccount(PropertiesReader.getValue((String)"mns", (String)"mns.accesskeyid"), PropertiesReader.getValue((String)"mns", (String)"mns.accesskeysecret"), PropertiesReader.getValue((String)"mns", (String)"mns.accountendpoint"));
        this.client = account.getMNSClient();
    }

    public static synchronized MnsUtils getInstance() {
        if (mnsUtils == null) {
            mnsUtils = new MnsUtils();
        }
        return mnsUtils;
    }

    public static CloudQueue getPointsQueue() {
        MnsUtils mnsUtils = MnsUtils.getInstance();
        String subscribeQueueName = PropertiesReader.getValue((String)"mns", (String)"points.msg.queue");
        return mnsUtils.getAndCreateQueue(subscribeQueueName);
    }

    public CloudQueue getAndCreateQueue(String queueName) {
        CloudQueue queue = this.client.getQueueRef(queueName);
        if (queue == null) {
            QueueMeta meta = new QueueMeta();
            meta.setQueueName(queueName);
            meta.setPollingWaitSeconds(Integer.valueOf(15));
            meta.setMaxMessageSize(Long.valueOf(2048L));
            queue = this.client.createQueue(meta);
        }
        return queue;
    }

    public CloudTopic getOrCreateTopic(String topicName, String subscribeQueueName) {
        CloudTopic cloudTopic = this.client.getTopicRef(topicName);
        if (cloudTopic == null) {
            TopicMeta topicMeta = new TopicMeta();
            topicMeta.setTopicName(topicName);
            Vector<String> consumerNameList = new Vector<String>();
            consumerNameList.add(subscribeQueueName);
            QueueMeta queueMetaTemplate = new QueueMeta();
            queueMetaTemplate.setPollingWaitSeconds(Integer.valueOf(15));
            CloudPullTopic cloudPullTopic = this.client.createPullTopic(topicMeta, consumerNameList, true, queueMetaTemplate);
            cloudTopic = cloudPullTopic.getRawTopic();
        }
        return cloudTopic;
    }

    public TopicMessage publishMessage(String topicName, String subscribeQueueName, String messageBody) {
        CloudTopic cloudTopic = this.getOrCreateTopic(topicName, subscribeQueueName);
        if (cloudTopic != null) {
            RawTopicMessage tMessage = new RawTopicMessage();
            tMessage.setBaseMessageBody(messageBody);
            return cloudTopic.publishMessage((TopicMessage)tMessage);
        }
        throw new BusinessException("mns\u4e3b\u9898\u4e0d\u5b58\u5728, topicName=" + topicName);
    }

    public void sendMessage(String queueName, String messageBody) {
        CloudQueue queue = this.getAndCreateQueue(queueName);
        String msgId = UUID.randomUUID().toString();
        Message message = new Message();
        message.setMessageBody(messageBody);
        message.setRequestId(msgId);
        log.info("sendMessage.queueName:{}, messageBody:{}", (Object)queueName, (Object)messageBody);
        queue.putMessage(message);
    }

    public void doAfter() {
        if (this.client != null) {
            this.client.close();
        }
    }

    public MNSClient getClient() {
        return this.client;
    }
}

