/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.marketing.referral.service.impl;

import com.baijia.tianxiao.dal.activity.dao.referral.GiftInfoDao;
import com.baijia.tianxiao.dal.activity.dao.referral.ReferralInfoDao;
import com.baijia.tianxiao.dal.activity.dao.referral.ReferralRecordDao;
import com.baijia.tianxiao.dal.activity.dto.PageInfo;
import com.baijia.tianxiao.dal.activity.po.referral.GiftInfo;
import com.baijia.tianxiao.dal.activity.po.referral.ReferralInfo;
import com.baijia.tianxiao.dal.activity.po.referral.ReferralRecord;
import com.baijia.tianxiao.sal.marketing.activity.dto.ResultWrapper;
import com.baijia.tianxiao.sal.marketing.commons.enums.ResultType;
import com.baijia.tianxiao.sal.marketing.commons.utils.TupleUtil;
import com.baijia.tianxiao.sal.marketing.commons.utils.TwoTuple;
import com.baijia.tianxiao.sal.marketing.referral.dto.BrokerDto;
import com.baijia.tianxiao.sal.marketing.referral.dto.CommissionDetail;
import com.baijia.tianxiao.sal.marketing.referral.dto.CommissionDto;
import com.baijia.tianxiao.sal.marketing.referral.dto.CommissionListDto;
import com.baijia.tianxiao.sal.marketing.referral.dto.ReferralCustomer;
import com.baijia.tianxiao.sal.marketing.referral.enums.ReferralCode;
import com.baijia.tianxiao.sal.marketing.referral.service.ReferralRecordService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.date.DateUtil;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReferralRecordServiceImpl
implements ReferralRecordService {
    private static final Logger log = LoggerFactory.getLogger(ReferralRecordServiceImpl.class);
    @Autowired
    private ReferralRecordDao recordDao;
    @Autowired
    private ReferralInfoDao infoDao;
    @Autowired
    private GiftInfoDao giftInfoDao;

    @Override
    public ReferralCode addReferralRecord(ReferralRecord record) {
        ReferralInfo info = this.infoDao.getReferralInfo(record.getActivityId(), null);
        if (info == null) {
            log.warn("[Referral] Add record fail.info is not exit.activityId={}", (Object)record.getActivityId());
            return ReferralCode.FAIL;
        }
        ReferralCode validate = this.validate(info);
        if (validate != null) {
            return validate;
        }
        ReferralRecord existRecord = this.recordDao.selectByReferralPhone(record.getReferralPhone());
        if (existRecord != null) {
            log.info("[Referral] Referral phone is exit.phone=" + record.getReferralPhone());
            return ReferralCode.REPEAT;
        }
        Date today = new Date();
        Integer count = this.recordDao.selectCountByBrokerAndTime(record.getActivityId(), record.getBrokerPhone(), DateUtil.getStartOfDay((Date)today), DateUtil.getEndOfDay((Date)today));
        if (count != null && count >= 14) {
            return ReferralCode.EVIL;
        }
        record.setCreateTime(new Timestamp(today.getTime()));
        record.setUpdateTime(new Timestamp(today.getTime()));
        this.recordDao.addReferralRecord(record);
        return ReferralCode.SUCCESS;
    }

    private ReferralCode validate(ReferralInfo info) {
        if (info.getStatus() == 0) {
            return ReferralCode.CLOSED;
        }
        Date current = new Date();
        Timestamp begin = info.getStartTime();
        Timestamp end = info.getEndTime();
        if (current.before(begin)) {
            return ReferralCode.NOT_START;
        }
        if (current.after(end)) {
            return ReferralCode.IS_END;
        }
        return null;
    }

    @Override
    public List<ReferralCustomer> getCustomerListByActivityId(long activityId, PageInfo pageInfo) {
        List records = this.recordDao.selectRecordsByPage(activityId, pageInfo);
        if (records == null || records.size() < 1) {
            return Collections.emptyList();
        }
        ArrayList<ReferralCustomer> customers = new ArrayList<ReferralCustomer>(records.size());
        for (ReferralRecord record : records) {
            customers.add(ReferralCustomer.getInstanceFromRecord(record));
        }
        return customers;
    }

    @Override
    public List<BrokerDto> getBrokerList(long activityId, PageInfo page) {
        List brokers = this.recordDao.selectBrokersByActivityId(activityId, page);
        if (brokers == null) {
            return Collections.emptyList();
        }
        ArrayList<BrokerDto> dtos = new ArrayList<BrokerDto>(brokers.size());
        for (ReferralRecord broker : brokers) {
            dtos.add(BrokerDto.getInstance(broker));
        }
        return dtos;
    }

    @Override
    public ResultWrapper<ReferralRecord> setBrokerGift(long recordId, long giftId, long orgId) {
        ResultWrapper<ReferralRecord> result = new ResultWrapper<ReferralRecord>();
        ReferralRecord record = this.recordDao.selectRecordById(recordId);
        if (record == null) {
            result.setRetType(ResultType.FAIL);
            result.setRetDesc("\u6807\u8bb0\u5931\u8d25");
            log.warn("[Referral] mark gift fail.record is not exit.recordId=" + recordId);
            return result;
        }
        if (record.getMarkTime() != null && record.getSettlementStatus() == 1) {
            result.setRetDesc("\u8be5\u8bb0\u5f55\u5df2\u7ed3\u7b97\uff0c\u4e0d\u80fd\u518d\u6807\u8bb0");
            result.setRetType(ResultType.FAIL);
            return result;
        }
        ReferralInfo info = this.infoDao.getReferralInfo(record.getActivityId(), Long.valueOf(orgId));
        if (info == null) {
            result.setRetType(ResultType.FAIL);
            result.setRetDesc("\u6807\u8bb0\u5931\u8d25");
            log.warn("[Referral] mark gift fail.info is not exit.activityId={},orgId={}", (Object)record.getActivityId(), (Object)orgId);
            return result;
        }
        GiftInfo gift = this.giftInfoDao.selectGiftById(giftId);
        if (gift == null) {
            result.setRetType(ResultType.FAIL);
            result.setRetDesc("\u6807\u8bb0\u5931\u8d25");
            log.warn("[Referral] mark gift fail.Gift is not exit.giftId=" + giftId);
            return result;
        }
        record.setGiftId(Long.valueOf(giftId));
        record.setGiftDesc(gift.getGiftDesc());
        record.setIntroduceWayDesc(gift.getIntroduceWayDesc());
        record.setMarkTime(new Timestamp(new Date().getTime()));
        record.setType(gift.getType());
        this.recordDao.updateReferralRecord(record);
        result.setRetType(ResultType.SUCC);
        result.setData(record);
        return result;
    }

    @Override
    public List<CommissionDetail> referralRecordDetail(long activityId, long orgId, String brokerPhone, String month, Integer status, PageInfo pageInfo) {
        ReferralInfo ri = this.infoDao.getReferralInfo(Long.valueOf(activityId), Long.valueOf(orgId));
        if (ri == null) {
            log.info("can not find any activity with id : {} and orgId {} ", (Object)activityId, (Object)orgId);
            return Collections.emptyList();
        }
        TwoTuple<Date, Date> timeRange = this.findStartAndEnd(month);
        List referralRecords = this.recordDao.selectReferralRecordDetail(activityId, brokerPhone, status, (Date)timeRange.first, (Date)timeRange.second, pageInfo);
        ArrayList<CommissionDetail> cds = new ArrayList<CommissionDetail>();
        for (ReferralRecord rr : referralRecords) {
            GiftInfo gift = this.getGift(rr);
            CommissionDetail cd = CommissionDetail.buildDto(rr, gift);
            cds.add(cd);
        }
        return cds;
    }

    private GiftInfo getGift(ReferralRecord rr) {
        Long id = rr.getGiftId();
        GiftInfo giftInfo = null;
        if (id != null && id != -1L) {
            giftInfo = new GiftInfo();
            String giftDesc = rr.getGiftDesc();
            String introduceWayDesc = rr.getIntroduceWayDesc();
            Integer type = rr.getType();
            giftInfo.setId(id);
            giftInfo.setGiftDesc(giftDesc);
            giftInfo.setIntroduceWayDesc(introduceWayDesc);
            giftInfo.setType(type);
        }
        return giftInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void settleReferralByMonth(long activityId, String brokerPhone, String month) {
        TwoTuple<Date, Date> findStartAndEnd = this.findStartAndEnd(month);
        ReferralRecordServiceImpl referralRecordServiceImpl = this;
        synchronized (referralRecordServiceImpl) {
            List records = this.recordDao.selectBrokersByTime(activityId, brokerPhone, 2, (Date)findStartAndEnd.first, (Date)findStartAndEnd.second);
            if (records != null && records.size() > 0) {
                for (ReferralRecord record : records) {
                    record.setUpdateTime(new Timestamp(new Date().getTime()));
                    record.setSettlementStatus(Integer.valueOf(1));
                    this.recordDao.updateReferralRecord(record);
                }
            }
        }
    }

    public TwoTuple<Date, Date> findStartAndEnd(String month) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        Date startTime = new Date();
        try {
            startTime = sdf.parse(month);
        }
        catch (ParseException e) {
            log.warn("[Referral] Param error.month=" + month);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startTime);
        calendar.set(5, 1);
        startTime = DateUtil.getStartOfDay((Date)calendar.getTime());
        calendar.add(2, 1);
        Date endTime = DateUtil.getStartOfDay((Date)calendar.getTime());
        return TupleUtil.tuple(startTime, endTime);
    }

    @Override
    public CommissionListDto getCommissionListByMonth(long activityId, String month, final int status, PageDto pageDto) {
        Integer value;
        String amount;
        CommissionListDto listDto = new CommissionListDto();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        Date startTime = new Date();
        try {
            startTime = sdf.parse(month);
        }
        catch (ParseException e) {
            log.warn("[Referral] Param error.month=" + month);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startTime);
        calendar.set(5, 1);
        startTime = DateUtil.getStartOfDay((Date)calendar.getTime());
        calendar.add(2, 1);
        Date endTime = DateUtil.getStartOfDay((Date)calendar.getTime());
        List records = this.recordDao.selectBrokersByTime(activityId, "", status, startTime, endTime);
        log.info("referralRecords are :{}", (Object)records);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (records != null && records.size() > 0) {
            listDto.setCount(records.size());
            for (ReferralRecord record : records) {
                log.info("record is : {} ", (Object)record);
                Object dto = (CommissionDto)map.get(record.getBrokerPhone());
                boolean isInit = false;
                if (dto == null) {
                    dto = CommissionDto.getInstanceFromRecord(record);
                    isInit = true;
                } else {
                    if (status == 2 && ((CommissionDto)dto).getLastMarkTime() < record.getMarkTime().getTime()) {
                        ((CommissionDto)dto).setBrokerName(record.getBrokerName());
                        ((CommissionDto)dto).setLastMarkTime(record.getMarkTime().getTime());
                    }
                    if (status == 1 && ((CommissionDto)dto).getSettleTime() < record.getUpdateTime().getTime()) {
                        ((CommissionDto)dto).setBrokerName(record.getBrokerName());
                        ((CommissionDto)dto).setSettleTime(record.getUpdateTime().getTime());
                    }
                }
                if (record.getType() == 1 && !isInit && ReferralRecordServiceImpl.isDigits(((CommissionDto)dto).getAmount())) {
                    log.info(" isDigits {} ", (Object)((CommissionDto)dto).getAmount());
                    amount = ((CommissionDto)dto).getAmount();
                    amount = this.removeDot(amount);
                    value = Integer.parseInt(amount);
                    String giftValue = record.getGiftDesc();
                    giftValue = this.removeDot(giftValue);
                    value = value + Integer.parseInt(giftValue);
                    ((CommissionDto)dto).setAmount(value.toString());
                }
                map.put(record.getBrokerPhone(), dto);
            }
        } else {
            listDto.setHasMore(0);
            return listDto;
        }
        ArrayList list = new ArrayList(map.values());
        log.info("record list is : {} ", list);
        Collections.sort(list, new Comparator<CommissionDto>(){

            @Override
            public int compare(CommissionDto o1, CommissionDto o2) {
                if (status == 2) {
                    return (int)(o2.getLastMarkTime() - o1.getLastMarkTime());
                }
                return (int)(o2.getSettleTime() - o1.getSettleTime());
            }
        });
        Integer totalAmount = 0;
        for (CommissionDto cd : list) {
            amount = cd.getAmount().trim();
            log.info("amount is :{} ", (Object)totalAmount);
            if (!GenericsUtils.notNullAndEmpty((Object)amount) || cd.getGiftType() != 1) continue;
            try {
                value = Integer.parseInt(amount);
                totalAmount = totalAmount + value;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        int startIndex = (pageDto.getPageNum() - 1) * pageDto.getPageSize();
        listDto.setTotalAmount(totalAmount.intValue());
        if (GenericsUtils.isNullOrEmpty(list) || startIndex > list.size()) {
            listDto.setList(Collections.emptyList());
            listDto.setHasMore(0);
            return listDto;
        }
        int endIndex = Math.min(startIndex + pageDto.getPageSize(), list.size());
        listDto.setList(list.subList(startIndex, endIndex));
        return listDto;
    }

    private String removeDot(String number) {
        return number.replaceAll("([0-9]+)\\.?[\\d]*", "$1");
    }

    private static boolean isDigits(String amount) {
        String regex = "[1-9][0-9]*\\.?[\\d]*";
        return Pattern.matches(regex, amount.trim());
    }
}

