/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.marketing.commons.service.impl;

import com.baijia.tianxiao.dal.activity.dao.ActivityAccessLogDao;
import com.baijia.tianxiao.dal.activity.dao.ActivityConfDao;
import com.baijia.tianxiao.dal.activity.dao.ActivityDao;
import com.baijia.tianxiao.dal.activity.dao.TxActivityCommonDao;
import com.baijia.tianxiao.dal.activity.dao.TxOrgVersionConsultDao;
import com.baijia.tianxiao.dal.activity.dao.draw.DrawActivityDao;
import com.baijia.tianxiao.dal.activity.dao.referral.ReferralInfoDao;
import com.baijia.tianxiao.dal.activity.dao.vote.VoteInfoDao;
import com.baijia.tianxiao.dal.activity.po.Activity;
import com.baijia.tianxiao.dal.activity.po.ActivityConf;
import com.baijia.tianxiao.dal.activity.po.TxActivityCommon;
import com.baijia.tianxiao.dal.activity.po.TxOrgVersionConsult;
import com.baijia.tianxiao.dal.activity.po.draw.DrawInfo;
import com.baijia.tianxiao.dal.activity.po.referral.ReferralInfo;
import com.baijia.tianxiao.dal.activity.po.vote.VoteInfo;
import com.baijia.tianxiao.dal.org.constant.TXAccountType;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.marketing.commons.constants.Config;
import com.baijia.tianxiao.sal.marketing.commons.dtos.ActivityAmountDto;
import com.baijia.tianxiao.sal.marketing.commons.dtos.TxActivityCommonFilterParams;
import com.baijia.tianxiao.sal.marketing.commons.dtos.TxActivityMergeDto;
import com.baijia.tianxiao.sal.marketing.commons.enums.ConstantEnums;
import com.baijia.tianxiao.sal.marketing.commons.enums.EmailType;
import com.baijia.tianxiao.sal.marketing.commons.enums.TemplateTypeCategory;
import com.baijia.tianxiao.sal.marketing.commons.service.RedisService;
import com.baijia.tianxiao.sal.marketing.commons.service.TxActivityCommonService;
import com.baijia.tianxiao.sal.marketing.commons.utils.ActivityMailSender;
import com.baijia.tianxiao.sal.marketing.commons.utils.Mail;
import com.baijia.tianxiao.sal.marketing.commons.utils.TupleUtil;
import com.baijia.tianxiao.sal.marketing.commons.utils.TwoTuple;
import com.baijia.tianxiao.sal.organization.org.dto.OrgInfoSimpleDto;
import com.baijia.tianxiao.sal.organization.org.service.OrgInfoService;
import com.baijia.tianxiao.sal.organization.org.service.TXAccountService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.date.DateUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TxActivityCommonServiceImpl
implements TxActivityCommonService {
    private static final Logger log = LoggerFactory.getLogger(TxActivityCommonServiceImpl.class);
    @Autowired
    private TxActivityCommonDao txActivityCommonDao;
    @Autowired
    private DrawActivityDao drawActivityDao;
    @Autowired
    private ActivityAccessLogDao activityAccessLogDao;
    @Autowired
    private VoteInfoDao voteInfoDao;
    @Autowired
    private ReferralInfoDao referralInfoDao;
    @Autowired
    private ActivityDao activityDao;
    @Autowired
    private ActivityConfDao activityConfDao;
    @Autowired
    private TXAccountService txAccountService;
    @Autowired
    private OrgInfoService orgInfoService;
    @Autowired
    private RedisService redisService;
    @Autowired
    private TxOrgVersionConsultDao txOrgVersionConsultDao;
    private static String CONSULT_BAIJIN_SUBJECT = "\u5927\u4f17\u7248\u5929\u6821\u673a\u6784\u54a8\u8be2\u5347\u7ea7\u767d\u91d1\u7248";

    @Override
    public List<TxActivityMergeDto> getTxActivityMergeDtoList(Long orgId, PageDto pageDto, TxActivityCommonFilterParams filterParams) {
        List<Integer> typeIds = new ArrayList<Integer>();
        Integer templateType = filterParams.getTemplateType();
        if (templateType == null) {
            typeIds = TemplateTypeCategory.getTypeIdList();
        } else {
            typeIds.add(TemplateTypeCategory.getTemplateTypeCategoryByType(templateType).getTypeId());
        }
        log.info("[ActivityMerge] typeIds param:{}", typeIds);
        ArrayList<TxActivityMergeDto> activityMergeDtoList = new ArrayList<TxActivityMergeDto>();
        List txActivityCommonList = this.txActivityCommonDao.getTxActivityList(orgId, typeIds, pageDto, filterParams.getIsSortedByPopular(), filterParams.getStatus());
        if (GenericsUtils.notNullAndEmpty((Object)txActivityCommonList)) {
            for (TxActivityCommon conf : txActivityCommonList) {
                TxActivityMergeDto dto = TxActivityMergeDto.buildInstanceByTxAcitivityConf(conf, filterParams.getStatus());
                activityMergeDtoList.add(dto);
            }
        } else {
            return Collections.EMPTY_LIST;
        }
        return activityMergeDtoList;
    }

    @Override
    public void saveOrUpdateTxActivityCommon(TxActivityCommon conf, TemplateTypeCategory templateTypeCategory, Object activityInfo, ActivityConf blackboardActivityConfInfo, String ... saveProp) {
        log.info("[ActivityMerge] conf param:{}, activityInfo param:{}", (Object)conf, activityInfo);
        if (templateTypeCategory != null) {
            switch (templateTypeCategory) {
                case DRAW_TYPE: {
                    this.setTxActivityCommonByDrawInfo(conf, (DrawInfo)activityInfo);
                    break;
                }
                case VOTE_TYPE: {
                    this.setTxActivityCommonByVoteInfo(conf, (VoteInfo)activityInfo);
                    break;
                }
                case REFERRAL_TYPE: {
                    this.setTxActivityCommonByReferralInfo(conf, (ReferralInfo)activityInfo);
                    break;
                }
                case COMMON_TYPE: {
                    this.setTxActivityCommonByBlackboardActivityInfo(conf, (Activity)activityInfo, blackboardActivityConfInfo);
                }
            }
        }
        conf.setUpdateTime(new Date());
        log.info("[ActivityMerge] conf param:{}", (Object)conf);
        log.info("[ActivityMerge] templateTypeCategory param:{}, activityInfo param:{}, blackboardActivityConfInfo param:{}", new Object[]{templateTypeCategory, activityInfo, blackboardActivityConfInfo});
        this.txActivityCommonDao.saveOrUpdate((Object)conf, saveProp);
    }

    @Override
    @Transactional(value="yunyingTransactionManager")
    public void synchronousActivityData(Integer type) {
        TemplateTypeCategory templateTypeCategory = TemplateTypeCategory.getTemplateTypeCategoryByType(type);
        List existConfs = this.txActivityCommonDao.getAll(new String[0]);
        HashMap<Integer, ArrayList<Long>> activityIdsMapByTypeId = new HashMap<Integer, ArrayList<Long>>();
        if (existConfs != null && existConfs.size() > 0) {
            for (TxActivityCommon conf : existConfs) {
                Integer typeId = conf.getTemplateTypeId();
                Long activityId = conf.getActivityId();
                ArrayList<Long> activityIds = (ArrayList<Long>)activityIdsMapByTypeId.get(typeId);
                if (activityIds == null) {
                    activityIds = new ArrayList<Long>();
                    activityIdsMapByTypeId.put(typeId, activityIds);
                }
                activityIds.add(activityId);
            }
        }
        PageDto pageDto = new PageDto();
        pageDto.setPageSize(Integer.valueOf(100));
        pageDto.setPageNum(Integer.valueOf(1));
        List existActivityIds = (List)activityIdsMapByTypeId.get(templateTypeCategory.getTypeId());
        log.info("[TxActivityCommon] existActivityIds param:{}, templateTypeCategory param:{}, size param:{}", (Object)existActivityIds, (Object)templateTypeCategory);
        switch (templateTypeCategory) {
            case DRAW_TYPE: {
                this.sysnDraw(pageDto, existActivityIds);
                break;
            }
            case VOTE_TYPE: {
                this.sysnVote(pageDto, existActivityIds);
                break;
            }
            case REFERRAL_TYPE: {
                this.sysnReferral(pageDto, existActivityIds);
                break;
            }
            case COMMON_TYPE: {
                this.sysnActivity(pageDto, existActivityIds);
            }
        }
    }

    private void sysnActivity(PageDto pageDto, List<Long> existActivityIds) {
        List activityList = this.activityDao.getActivityList(pageDto);
        log.info("[TxActivityCommon] activityList param:{}", (Object)activityList.size());
        if (activityList != null && activityList.size() > 0) {
            ArrayList<TxActivityCommon> confs = new ArrayList<TxActivityCommon>();
            ArrayList<Long> activityIds = new ArrayList<Long>();
            for (Activity activity : activityList) {
                activityIds.add(activity.getId());
            }
            Map activityConfMap = this.activityConfDao.getConfigMapByActivityIds(activityIds);
            Map map = this.activityAccessLogDao.selectTotalByActivityId(activityIds, TemplateTypeCategory.COMMON_TYPE.getType());
            ArrayList<Long> sysnActivityIds = new ArrayList<Long>();
            for (Activity activity : activityList) {
                if (existActivityIds != null && existActivityIds.contains(activity.getId())) continue;
                TxActivityCommon conf = new TxActivityCommon();
                sysnActivityIds.add(activity.getId());
                ActivityConf blackboardActivityConfInfo = (ActivityConf)activityConfMap.get(activity.getId());
                this.setTxActivityCommonByBlackboardActivityInfo(conf, activity, blackboardActivityConfInfo);
                Integer accessCount = (Integer)map.get(activity.getId());
                conf.setAccessCount(Integer.valueOf(accessCount == null ? 0 : accessCount));
                conf.setCreateTime(DateUtil.getStrToDate((String)"yyyy-MM-dd HH:mm:ss", (String)activity.getCreateTime()));
                conf.setUpdateTime(DateUtil.getStrToDate((String)"yyyy-MM-dd HH:mm:ss", (String)activity.getUpdateTime()));
                confs.add(conf);
            }
            log.info("[TxActivityCommon]  \u540c\u6b65\u7684\u6d3b\u52a8 activityIds param:{}, sysnActivityIds param:{} , type:{}", new Object[]{activityIds, "\u53d1\u6d3b\u52a8", sysnActivityIds});
            if (confs.size() > 0) {
                this.txActivityCommonDao.saveAll(confs, new String[0]);
            }
            pageDto.setPageNum(Integer.valueOf(pageDto.getPageNum() + 1));
            log.info("[TxActivityCommon] pageDto :{}", (Object)pageDto);
            this.sysnActivity(pageDto, existActivityIds);
        }
    }

    private void sysnDraw(PageDto pageDto, List<Long> existActivityIds) {
        ArrayList<TxActivityCommon> confs = new ArrayList<TxActivityCommon>();
        List drawInfoList = this.drawActivityDao.getAll(new String[0]);
        if (drawInfoList != null && drawInfoList.size() > 0) {
            ArrayList<Long> activityIds = new ArrayList<Long>();
            for (DrawInfo drawInfo : drawInfoList) {
                activityIds.add(drawInfo.getActivityId());
            }
            log.info("[TxActivityCommon]  \u540c\u6b65\u7684\u6d3b\u52a8 activityIds param:{}, type:{}", activityIds, (Object)"\u62bd\u5956");
            Map map = this.activityAccessLogDao.selectTotalByActivityId(activityIds, TemplateTypeCategory.DRAW_TYPE.getType());
            for (DrawInfo drawInfo : drawInfoList) {
                if (existActivityIds != null && existActivityIds.contains(drawInfo.getActivityId())) continue;
                Integer accessCount = (Integer)map.get(drawInfo.getActivityId());
                TxActivityCommon conf = new TxActivityCommon();
                this.setTxActivityCommonByDrawInfo(conf, drawInfo);
                conf.setCreateTime((Date)drawInfo.getCreateTime());
                conf.setUpdateTime((Date)drawInfo.getUpdateTime());
                conf.setAccessCount(Integer.valueOf(accessCount == null ? 0 : accessCount));
                confs.add(conf);
            }
        }
        if (confs.size() > 0) {
            this.txActivityCommonDao.saveAll(confs, new String[0]);
        }
    }

    private void sysnVote(PageDto pageDto, List<Long> existActivityIds) {
        ArrayList<TxActivityCommon> confs = new ArrayList<TxActivityCommon>();
        List voteInfoList = this.voteInfoDao.getAll(new String[0]);
        if (voteInfoList != null && voteInfoList.size() > 0) {
            ArrayList<Long> activityIds = new ArrayList<Long>();
            for (VoteInfo voteInfo : voteInfoList) {
                activityIds.add(voteInfo.getActivityId());
            }
            log.info("[TxActivityCommon]  \u540c\u6b65\u7684\u6d3b\u52a8 activityIds param:{}, type:{}", activityIds, (Object)"\u6295\u7968");
            Map map = this.activityAccessLogDao.selectTotalByActivityId(activityIds, TemplateTypeCategory.VOTE_TYPE.getType());
            for (VoteInfo voteInfo : voteInfoList) {
                if (existActivityIds != null && existActivityIds.contains(voteInfo.getActivityId())) continue;
                Integer accessCount = (Integer)map.get(voteInfo.getActivityId());
                TxActivityCommon conf = new TxActivityCommon();
                this.setTxActivityCommonByVoteInfo(conf, voteInfo);
                conf.setCreateTime((Date)voteInfo.getCreateTime());
                conf.setUpdateTime((Date)voteInfo.getUpdateTime());
                conf.setAccessCount(Integer.valueOf(accessCount == null ? 0 : accessCount));
                confs.add(conf);
            }
            if (confs.size() > 0) {
                this.txActivityCommonDao.saveAll(confs, new String[0]);
            }
        }
    }

    private void sysnReferral(PageDto pageDto, List<Long> existActivityIds) {
        ArrayList<TxActivityCommon> confs = new ArrayList<TxActivityCommon>();
        List referralInfoList = this.referralInfoDao.getAll(new String[0]);
        if (referralInfoList != null && referralInfoList.size() > 0) {
            ArrayList<Long> activityIds = new ArrayList<Long>();
            for (ReferralInfo referralInfo : referralInfoList) {
                activityIds.add(referralInfo.getActivityId());
            }
            log.info("[TxActivityCommon]  \u540c\u6b65\u7684\u6d3b\u52a8 activityIds param:{}, type:{}, size:{}", new Object[]{activityIds, "\u8f6c\u4ecb\u7ecd", activityIds.size()});
            Map map = this.activityAccessLogDao.selectTotalByActivityId(activityIds, TemplateTypeCategory.REFERRAL_TYPE.getType());
            for (ReferralInfo referralInfo : referralInfoList) {
                if (existActivityIds != null && existActivityIds.contains(referralInfo.getActivityId())) continue;
                Integer accessCount = (Integer)map.get(referralInfo.getActivityId());
                TxActivityCommon conf = new TxActivityCommon();
                this.setTxActivityCommonByReferralInfo(conf, referralInfo);
                conf.setCreateTime((Date)referralInfo.getCreateTime());
                conf.setUpdateTime((Date)referralInfo.getUpdateTime());
                conf.setAccessCount(Integer.valueOf(accessCount == null ? 0 : accessCount));
                confs.add(conf);
            }
            if (confs.size() > 0) {
                this.txActivityCommonDao.saveAll(confs, new String[0]);
            }
        }
    }

    private void setTxActivityCommonByDrawInfo(TxActivityCommon conf, DrawInfo drawInfo) {
        BeanUtils.copyProperties((Object)drawInfo, (Object)conf);
        conf.setTemplateTypeId(Integer.valueOf(TemplateTypeCategory.DRAW_TYPE.getTypeId()));
        conf.setTitle(drawInfo.getName());
    }

    private void setTxActivityCommonByVoteInfo(TxActivityCommon conf, VoteInfo voteInfo) {
        BeanUtils.copyProperties((Object)voteInfo, (Object)conf);
        conf.setTitle(voteInfo.getName());
        conf.setTemplateTypeId(Integer.valueOf(TemplateTypeCategory.VOTE_TYPE.getTypeId()));
    }

    private void setTxActivityCommonByReferralInfo(TxActivityCommon conf, ReferralInfo referralInfo) {
        BeanUtils.copyProperties((Object)referralInfo, (Object)conf);
        conf.setTemplateId(Integer.valueOf(referralInfo.getTemplateId().intValue()));
        conf.setTemplateTypeId(Integer.valueOf(TemplateTypeCategory.REFERRAL_TYPE.getTypeId()));
    }

    private void setTxActivityCommonByBlackboardActivityInfo(TxActivityCommon conf, Activity activity, ActivityConf blackboardActivityConfInfo) {
        conf.setActivityId(activity.getId());
        conf.setTitle(activity.getTitle());
        conf.setOrgId(Long.valueOf(activity.getOrgId().longValue()));
        conf.setTemplateId(blackboardActivityConfInfo.getTemplateId());
        conf.setTemplateTypeId(Integer.valueOf(TemplateTypeCategory.COMMON_TYPE.getTypeId()));
        conf.setStartTime((Date)blackboardActivityConfInfo.getStartTime());
        conf.setEndTime((Date)blackboardActivityConfInfo.getEndTime());
        conf.setStatus(activity.getSwitcher());
        conf.setDelStatus(activity.getIsdel());
    }

    @Override
    public ActivityAmountDto getActivityAmountDto(Long orgId) {
        Integer activityTotal = this.txActivityCommonDao.getActivityTotal(orgId);
        ActivityAmountDto dto = new ActivityAmountDto();
        dto.setActivityTotal(activityTotal == null ? 0 : activityTotal);
        dto.setMostActivityTotalForFreeVersion(Config.MOST_ACTIVITY_TOTAL_FOR_FREE_VERSION);
        dto.setMostActivityTotalForPayVersion(Config.MOST_ACTIVITY_TOTAL_FOR_PAY_VERSION);
        return dto;
    }

    @Override
    @Transactional
    public TwoTuple<Integer, String> saveConsultBaiJinInfo(Long orgId) {
        OrgInfoSimpleDto simple = null;
        try {
            simple = this.orgInfoService.getOrgInfo(orgId);
        }
        catch (Exception e) {
            log.info("can not find an org with org_ID {}", (Object)orgId);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u673a\u6784\u4e0d\u5b58\u5728");
        }
        boolean isNotLimited = this.redisService.addOrgEmailCount(orgId, 0L, 0, EmailType.CONSULT_BAIJIN_VERSION);
        if (!isNotLimited) {
            log.info("\u673a\u6784\u6700\u591a\u6bcf\u5929\u53ef\u4ee5\u53d15\u5c01\u90ae\u4ef6");
            return TupleUtil.tuple(TupleUtil.OK, "\u63d0\u4ea4\u54a8\u8be2\u6210\u529f\uff0c\u5929\u6821\u987e\u95ee\u5c06\u5c3d\u5feb\u4e0e\u60a8\u8054\u7cfb");
        }
        String email = ConstantEnums.MAILBOX_CONTACTS_CONSULT_VERSION.value();
        String content = this.getContent(simple);
        String subject = CONSULT_BAIJIN_SUBJECT;
        Mail mail = ActivityMailSender.createMail(email, null, subject, content);
        try {
            ActivityMailSender.sendMail(email, mail, true);
        }
        catch (Exception e) {
            log.info("\u53d1\u9001\u90ae\u4ef6\u5931\u8d25\uff01e param:{}", (Throwable)e);
            return TupleUtil.tuple(CommonErrorCode.BUSINESS_ERROR.getSubsystemErrorCode(), "\u53d1\u9001\u90ae\u4ef6\u5931\u8d25\uff0c\u8bf7\u7a0d\u5019\u518d\u8bd5\uff01");
        }
        TxOrgVersionConsult versionConsult = this.txOrgVersionConsultDao.getTxOrgVersionConsultByOrgId(orgId);
        log.info("[TxActivityCommon] versionConsult:{}", (Object)versionConsult);
        if (versionConsult == null) {
            versionConsult = new TxOrgVersionConsult();
            versionConsult.setOrgId(orgId);
            versionConsult.setApplyDate(new Date());
            versionConsult.setCreateTime(new Date());
            versionConsult.setApplyType(TXAccountType.BAIJIN.getCode());
            this.txOrgVersionConsultDao.save((Object)versionConsult, new String[0]);
        } else {
            versionConsult.setApplyDate(new Date());
            this.txOrgVersionConsultDao.update((Object)versionConsult, new String[]{"applyDate"});
        }
        return TupleUtil.tuple(TupleUtil.OK, "\u63d0\u4ea4\u54a8\u8be2\u6210\u529f\uff0c\u5929\u6821\u987e\u95ee\u5c06\u5c3d\u5feb\u4e0e\u60a8\u8054\u7cfb");
    }

    private String getContent(OrgInfoSimpleDto simple) {
        StringBuffer sb = new StringBuffer();
        sb.append("\u673a\u6784\u540d\u79f0\uff1a").append(simple.getShortName() == null ? "" : simple.getShortName()).append("</br>");
        sb.append("\u8054\u7cfb\u4eba\u59d3\u540d\uff1a").append(simple.getContacts() == null ? "" : simple.getContacts()).append("</br>");
        sb.append("\u8054\u7cfb\u7535\u8bdd\uff1a").append(simple.getMobile() == null ? "" : simple.getMobile()).append("</br>");
        sb.append("\u5730\u5740\uff1a").append(simple.getAddress() == null ? "" : simple.getAddress()).append("</br>");
        sb.append("\u5907\u6ce8\uff1a\u5927\u4f17\u7248\u5929\u6821\u673a\u6784\u54a8\u8be2\u5347\u7ea7\u767d\u91d1\u7248");
        return sb.toString();
    }

    public static void main(String[] args) {
        OrgInfoSimpleDto simple = new OrgInfoSimpleDto();
        simple.setShortName("nihao");
        simple.setContacts("gaodan");
        StringBuffer sb = new StringBuffer();
        sb.append("\u673a\u6784\u540d\u79f0\uff1a").append(simple.getShortName() == null ? "" : simple.getShortName()).append("\r\n");
        sb.append("\u8054\u7cfb\u4eba\u59d3\u540d\uff1a" + simple.getContacts() == null ? "" : simple.getContacts() + "\r\n");
        System.out.println(sb.toString());
    }

    @Override
    public void checkoutOrgActivityVipLevelAndAmount(Long orgId) {
        TXAccount txAccount = this.txAccountService.getTXAccountByOrgId(Integer.valueOf(orgId.intValue()), new String[0]);
        if (txAccount.getVipLevel() == TXAccountType.DAZHONG.getCode()) {
            ActivityAmountDto dto = this.getActivityAmountDto(orgId);
            log.info("[TxActivityCommon] ActivityAmountDto param:{}", (Object)dto);
            if (dto.getActivityTotal() >= Config.MOST_ACTIVITY_TOTAL_FOR_FREE_VERSION) {
                log.warn("This organization:{} is free version:{}, the most amount of activity is :{}", new Object[]{orgId, txAccount.getVipLevel(), Config.MOST_ACTIVITY_TOTAL_FOR_FREE_VERSION});
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5927\u4f17\u7248\u5929\u6821\u7528\u6237\u6700\u591a\u53ef\u521b\u5efa" + Config.MOST_ACTIVITY_TOTAL_FOR_FREE_VERSION + "\u4e2a\u5fae\u6d3b\u52a8");
            }
        } else {
            return;
        }
    }
}

