/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.marketing.article.dto;

import com.baijia.tianxiao.dal.activity.po.ArticleBaseInfo;
import com.baijia.tianxiao.sal.marketing.article.dto.ArticleBaseDto;
import com.baijia.tianxiao.sal.marketing.article.utils.UrlUtil;
import com.baijia.tianxiao.sal.marketing.commons.constants.Config;
import com.baijia.tianxiao.sal.marketing.commons.utils.StringHelper;
import com.baijia.tianxiao.util.GenericsUtils;

public class HotArticleDto
extends ArticleBaseDto {
    private String articleId;
    private String introduction;
    private String accessNum;
    private String supportNum;
    private String originUrl;
    private String detailUrl;

    public static HotArticleDto getFromArticleBaseInfo(ArticleBaseInfo articleInfo) {
        HotArticleDto hotArticleDto = new HotArticleDto();
        hotArticleDto.setArticleId(articleInfo.getId());
        hotArticleDto.setAccessNum(articleInfo.getVisitCount().toString());
        hotArticleDto.setOriginUrl(articleInfo.getArticleUrl());
        hotArticleDto.setSupportNum(articleInfo.getThumbUpCount().toString());
        String imgUrl = articleInfo.getArticleImg();
        if (GenericsUtils.notNullAndEmpty((Object)imgUrl) && !imgUrl.startsWith(Config.IMAGE_SERVER_HOST)) {
            imgUrl = Config.getResourceProxyUrl(imgUrl);
        }
        hotArticleDto.setThumbNail(imgUrl);
        hotArticleDto.setTitle(articleInfo.getArticleTitle());
        hotArticleDto.setDetailUrl(UrlUtil.getH5Url(hotArticleDto.getArticleId()));
        hotArticleDto.setIntroduction(StringHelper.subString(articleInfo.getAbstractContent(), 20));
        return hotArticleDto;
    }

    @Override
    public String getArticleId() {
        return this.articleId;
    }

    public String getIntroduction() {
        return this.introduction;
    }

    public String getAccessNum() {
        return this.accessNum;
    }

    public String getSupportNum() {
        return this.supportNum;
    }

    public String getOriginUrl() {
        return this.originUrl;
    }

    public String getDetailUrl() {
        return this.detailUrl;
    }

    @Override
    public void setArticleId(String articleId) {
        this.articleId = articleId;
    }

    public void setIntroduction(String introduction) {
        this.introduction = introduction;
    }

    public void setAccessNum(String accessNum) {
        this.accessNum = accessNum;
    }

    public void setSupportNum(String supportNum) {
        this.supportNum = supportNum;
    }

    public void setOriginUrl(String originUrl) {
        this.originUrl = originUrl;
    }

    public void setDetailUrl(String detailUrl) {
        this.detailUrl = detailUrl;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HotArticleDto)) {
            return false;
        }
        HotArticleDto other = (HotArticleDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$articleId = this.getArticleId();
        String other$articleId = other.getArticleId();
        if (this$articleId == null ? other$articleId != null : !this$articleId.equals(other$articleId)) {
            return false;
        }
        String this$introduction = this.getIntroduction();
        String other$introduction = other.getIntroduction();
        if (this$introduction == null ? other$introduction != null : !this$introduction.equals(other$introduction)) {
            return false;
        }
        String this$accessNum = this.getAccessNum();
        String other$accessNum = other.getAccessNum();
        if (this$accessNum == null ? other$accessNum != null : !this$accessNum.equals(other$accessNum)) {
            return false;
        }
        String this$supportNum = this.getSupportNum();
        String other$supportNum = other.getSupportNum();
        if (this$supportNum == null ? other$supportNum != null : !this$supportNum.equals(other$supportNum)) {
            return false;
        }
        String this$originUrl = this.getOriginUrl();
        String other$originUrl = other.getOriginUrl();
        if (this$originUrl == null ? other$originUrl != null : !this$originUrl.equals(other$originUrl)) {
            return false;
        }
        String this$detailUrl = this.getDetailUrl();
        String other$detailUrl = other.getDetailUrl();
        return !(this$detailUrl == null ? other$detailUrl != null : !this$detailUrl.equals(other$detailUrl));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof HotArticleDto;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $articleId = this.getArticleId();
        result = result * 59 + ($articleId == null ? 43 : $articleId.hashCode());
        String $introduction = this.getIntroduction();
        result = result * 59 + ($introduction == null ? 43 : $introduction.hashCode());
        String $accessNum = this.getAccessNum();
        result = result * 59 + ($accessNum == null ? 43 : $accessNum.hashCode());
        String $supportNum = this.getSupportNum();
        result = result * 59 + ($supportNum == null ? 43 : $supportNum.hashCode());
        String $originUrl = this.getOriginUrl();
        result = result * 59 + ($originUrl == null ? 43 : $originUrl.hashCode());
        String $detailUrl = this.getDetailUrl();
        result = result * 59 + ($detailUrl == null ? 43 : $detailUrl.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "HotArticleDto(articleId=" + this.getArticleId() + ", introduction=" + this.getIntroduction() + ", accessNum=" + this.getAccessNum() + ", supportNum=" + this.getSupportNum() + ", originUrl=" + this.getOriginUrl() + ", detailUrl=" + this.getDetailUrl() + ")";
    }
}

