package com.baijia.tianxiao.sal.marketing.vote.service.impl;

import com.baijia.tianxiao.dal.activity.constants.CommonConstant;
import com.baijia.tianxiao.dal.activity.dao.vote.VoteOptionDao;
import com.baijia.tianxiao.dal.activity.po.vote.VoteOption;
import com.baijia.tianxiao.sal.marketing.vote.dto.VoteInfoRequest;
import com.baijia.tianxiao.sal.marketing.vote.dto.VoteOptionDto;
import com.baijia.tianxiao.sal.marketing.vote.service.VoteOptionService;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * Created by liuxp on 16/4/9.
 */
@Service
public class VoteOptionServiceImpl implements VoteOptionService{

    @Autowired
    private VoteOptionDao optionDao;

    public List<VoteOptionDto> getOptionList(long voteId) {
        List<VoteOption> optionList = optionDao.selectVoteOptionsByVoteId(voteId);
        if (optionList != null) {
            int number = 1;
            List<VoteOptionDto> dtoList = new ArrayList<>(optionList.size());
            for (VoteOption option : optionList) {
                VoteOptionDto dto = VoteOptionDto.getInstance(option);
                dto.setNumber(number);
                dtoList.add(dto);
                if (StringUtils.isBlank(dto.getPicUrl())) {
                    dto.setPicUrl(CommonConstant.VOTE_OPTION_DEFAULT_PIC);
                }
                number++;
            }
            return dtoList;
        }
        return Collections.emptyList();
    }
}
