package com.baijia.tianxiao.sal.marketing.commons.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

/**
 * @author Rezar
 * @createDate :Mar 2, 2016 8:54:52 PM
 * @desc :
 */
public class JsonUtil {

    @SuppressWarnings("unchecked")
    public static <T> List<T> buildOptions(String optionJson, Class<T> clazz) {
        JSONArray array = JSONArray.fromObject(optionJson);
        List<T> arrays = new ArrayList<>();
        Iterator<JSONObject> iterator = array.iterator();
        while (iterator.hasNext()) {
            JSONObject next = iterator.next();
            T bean = (T) JSONObject.toBean(next, clazz);
            arrays.add(bean);
        }
        return arrays;
    }

    @SuppressWarnings("unchecked")
    public static <T> T buildSingleOption(String optionJson, Class<T> clazz) {
        JSONObject jsonObj = JSONObject.fromObject(optionJson);
        T bean = (T) JSONObject.toBean(jsonObj, clazz);
        return bean;
    }

    public static void main(String[] args) {

    }

}
