package com.baijia.tianxiao.sal.marketing.commons.service.impl;

import com.baijia.tianxiao.dal.activity.constants.TemplateConstant;
import com.baijia.tianxiao.dal.activity.dao.TemplateDao;
import com.baijia.tianxiao.dal.activity.dao.TemplateTypeDao;
import com.baijia.tianxiao.dal.activity.dto.PageInfo;
import com.baijia.tianxiao.dal.activity.po.Template;
import com.baijia.tianxiao.dal.activity.po.TemplateType;
import com.baijia.tianxiao.dal.org.constant.TXAccountType;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.sal.marketing.activity.dto.TemplateDto;
import com.baijia.tianxiao.sal.marketing.commons.constants.Config;
import com.baijia.tianxiao.sal.marketing.commons.dtos.TxActivityCommonFilterParams;
import com.baijia.tianxiao.sal.marketing.commons.enums.TemplateTypeCategory;
import com.baijia.tianxiao.sal.marketing.commons.service.TemplateService;
import com.baijia.tianxiao.sal.organization.org.dto.pcAuthority.TxAccountPermissionsDto;
import com.baijia.tianxiao.sal.organization.org.service.TXAccountService;
import com.baijia.tianxiao.sal.organization.org.service.TxAccountPermissionService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.PostConstruct;

import lombok.extern.slf4j.Slf4j;

/**
 * Created by liuxp on 16/1/8.
 */
@Service
@Slf4j
public class TemplateServiceImpl implements TemplateService {

    public final Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private TemplateDao templateDao;
    @Autowired
    private TemplateTypeDao templateTypeDao;
    @Autowired
    private TxAccountPermissionService permissionService;
    @Autowired
    private TXAccountService txAccountService;

    @Override
    public List<TemplateDto> getTemplateByTypeId(int typeId,TemplateTypeCategory category,PageInfo page) {
        Set<Integer> typeIds = new HashSet<>();
        Map<Integer,TemplateType> typeMap = new HashMap<>();
        if(typeId<1){
            List<TemplateType> typeList = templateTypeDao.selectTemplateTypeListByCategory(category.getType());
            for(TemplateType type:typeList){
                typeMap.put(type.getTypeId(),type);
                typeIds.add(type.getTypeId());
            }
        }else {
            typeIds.add(typeId);
            typeMap = templateTypeDao.selectTypeByIds(typeIds);
        }

        List<Template> templateList = templateDao.selectTemplateListByTypeId(typeIds,page);
        List<TemplateDto> dtoList = new ArrayList<>();
        for(Template template:templateList){
            TemplateDto dto = TemplateDto.getInstance(template);
            dto.setUrl(Config.DOMAIN + template.getUrl());
            dto.setDesc(template.getActivityDesc());
            dtoList.add(dto);
        }

        logger.info("[Debug] typeMap="+typeMap);
        for(TemplateDto dto:dtoList){
            dto.setInitial(typeMap.get(dto.getTypeId()).getFlag());
            dto.setUrl(dto.getUrl()+"#!/");
        }
        return dtoList;
    }

    @PostConstruct
    public void init(){
        List<Template> templateList = templateDao.selectTemplateList();

        if(templateList!=null && templateList.size()>0){
            Set<Integer> ids = new HashSet<>();
            for (Template template: templateList) {
                ids.add(template.getTypeId());
                TemplateConstant.getMap().put(template.getTemplateId(), template);
            }
            Map<Integer,TemplateType> templateTypeMap = templateTypeDao.selectTypeByIds(ids);
            for (Template template: templateList){
                TemplateConstant.getMap().get(template.getTemplateId()).setType(templateTypeMap.get(template.getTypeId()));
            }
        }
        logger.info("[Init template]="+TemplateConstant.getMap());
    }

    @Override
    public List<TemplateDto> getTemplateDtoListByCondition(TxActivityCommonFilterParams filterParams, PageDto pageDto, Integer orgId,Integer cascadeId) {
        List<Integer> typeIds = new ArrayList<>();
        Map<Integer,TemplateType> typeMap = new HashMap<>();
        //类型为null
        Integer templateType = filterParams.getTemplateType();
        if(templateType == null){
            typeIds = TemplateTypeCategory.getTypeIdList();
        }else{
            typeIds.add(TemplateTypeCategory.getTemplateTypeCategoryByType(templateType).getTypeId());
        }
        log.info("[ActivityMerge] typeIds param:{}", typeIds);
        typeMap = templateTypeDao.selectTypeByIds(typeIds);
        
        //获取权限码 用于判断模板是否有权限
        log.info("[Template] orgId:{}, cascadeId:{}", orgId, cascadeId);
        TxAccountPermissionsDto permissions = permissionService.universalGetPermissions(orgId,cascadeId);
        Map<Long,Integer> map = new HashMap<>();
        if(permissions!=null && permissions.getAPPps()!=null && permissions.getAPPps().size()>0){
            for (TxAccountPermissionsDto.AccountPermissionDto permissionDto:permissions.getAPPps()){
                map.put(permissionDto.getPCode(),permissionDto.getPType());
            }
        }
        
        //获取机构版本类型 白金版，免费版。。。
        TXAccount txAccount = txAccountService.getTXAccountByOrgId(orgId);
        Integer vipLevel = null;
        if(txAccount != null){
            vipLevel = txAccount.getVipLevel();
        }
        log.info("[Template] vipLevel:{}", vipLevel);
        
        //获取改筛选条件下所有模板列表总数
        List<Template> templateList = templateDao.getTemplateListByCondition(typeIds, pageDto, filterParams.getIsSortedByPopular());
        
        //权限模板List
        List<TemplateDto> permissionTemplateList = new ArrayList<>();
        //无权限模板
        List<TemplateDto> noPermissionTemplateList = new ArrayList<>();
        
        if(templateList != null && templateList.size() > 0){
            for(Template template:templateList){
                TemplateDto dto = TemplateDto.getInstance(template);
                dto.setUrl(Config.DOMAIN + template.getUrl() + "#!/");
                dto.setDesc(template.getActivityDesc());
                dto.setInitial(typeMap.get(dto.getTypeId()).getFlag());
                //设置模板类型描述
                TemplateTypeCategory category = TemplateTypeCategory.getTemplateTypeCategoryByTypeId(dto.getTypeId());
                String templateTypeStr = category.getLabel();
                dto.setTemplateType(category.getType());
                
                //设置机构类型
                dto.setVipLevel(vipLevel);
                //设置促销图片
                dto.setPromotionIconUrl(getPromotionIconUrl(vipLevel, template));
                //设置模板标题
                String titleFormat = "[%s] %s";
                String title = String.format(titleFormat, templateTypeStr, template.getName());
                dto.setTitle(title);
                
                //设置模板是否有访问权限
                long pCode = category.getPCode();
                
                //当机构是大众版时候，需要做模板权限判断
                if(vipLevel == TXAccountType.DAZHONG.getCode() && map.get(pCode) != null && map.get(pCode)==1){
                    //模板没有权限访问
                    dto.setHasPermition(0);
                    noPermissionTemplateList.add(dto);
                }else{
                    dto.setHasPermition(1);
                    permissionTemplateList.add(dto);
                }
            }
        }else{
            return Collections.EMPTY_LIST;
        }
        
        //需要将有权限的模板放在无权限模板的前面
        permissionTemplateList.addAll(noPermissionTemplateList);
        return permissionTemplateList;
    }
    
    //设置促销图标
    private String getPromotionIconUrl(Integer vipLevel, Template template){
        String promotionIconUrl = "";
        if(StringUtils.isNotBlank(template.getVipLevel())){
            List<String> vipLevelList = Arrays.asList(template.getVipLevel().split(","));
            //pm要求机构 企业版、旗舰版、定制、专业版本都视为白金版
            Integer vipProxy = TXAccountType.getPaySet().contains(TXAccountType.getTXAccountTypeByCode(vipLevel)) ? TXAccountType.BAIJIN.getCode() : vipLevel;
            if(vipLevelList.contains(vipProxy.toString())){
                promotionIconUrl = template.getPromotionIconUrl();
            }
        }
        return promotionIconUrl;
    }
    
    public static void main(String[] args) {
        Integer vipProxy = TXAccountType.getPaySet().contains(1) ? TXAccountType.BAIJIN.getCode() : 10;
        System.out.println(TXAccountType.getPaySet().contains(TXAccountType.getTXAccountTypeByCode(1)));
        
    }

}