package com.baijia.tianxiao.sal.marketing.commons.enums;

import com.baijia.tianxiao.sal.marketing.commons.constants.Config;
import lombok.extern.slf4j.Slf4j;

/**
 * Created by liuxp on 16/5/3.
 */
@Slf4j
public enum SystemType {
    TX_MARKETING(1, Config.DOMAIN),
    CW_MARKETING(2, Config.CAIWU_DOMAIN),
    TX_CRM(3, Config.CRM_DOMAIN),
    YINGXIAO(4, Config.YINGXIAO);

    public int type;
    public String domain;

    private SystemType(Integer type, String domain) {
        this.type = type;
        this.domain = domain;
    }

    public int getType() {
        return type;
    }

    public String getDomain() {
        return domain;
    }

    public static String getDomain(int type) {
        for(SystemType systemType:SystemType.values()){
            if(systemType.getType()==type){
                log.info("[Config] Domain="+systemType.getDomain()+";type="+type);
                return systemType.getDomain();
            }
        }
        return "";
    }
}
