package com.baijia.tianxiao.sal.marketing.commons.dtos;

import com.baijia.tianxiao.dal.activity.po.MarketingEntry;
import com.baijia.tianxiao.dal.org.constant.TXAccountType;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.sal.marketing.commons.enums.SystemType;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;

/**
 * Created by liuxp on 16/4/20.
 */
@Data
@Slf4j
public class MarketingEntryDto extends MarketingEntry{
    private List<MarketingEntryDto> subEntries = new ArrayList<>();
    private int group;

    public static MarketingEntryDto createFromMarketingEntry(MarketingEntry entry, TXAccount txAccount){
        MarketingEntryDto dto = new MarketingEntryDto();
        BeanUtils.copyProperties(entry, dto);
        dto.setGroup(entry.getGroupId());
        String vipLevel = entry.getVipLevel();  //这里vipLevel可能是多个版本，版本之间用','隔开
        String promotionIconUrl = null;
        log.info("[MarketingEntry] vipLevel param:{}, txAccount.getVipLevel() param:{}", vipLevel, txAccount.getVipLevel());
        if(StringUtils.isNotBlank(vipLevel)){
            List<String> vipLevelList = Arrays.asList(vipLevel.split(","));
          //pm要求机构 企业版、旗舰版、定制、专业版本都视为白金版
            Integer vipProxy = TXAccountType.getPaySet().contains(TXAccountType.getTXAccountTypeByCode(txAccount.getVipLevel())) 
                ? TXAccountType.BAIJIN.getCode() : txAccount.getVipLevel();
            if(vipLevelList.contains(vipProxy.toString())){
                promotionIconUrl = entry.getPromotionIconUrl();
            }
        }
        dto.setPromotionIconUrl(promotionIconUrl == null ? "" : promotionIconUrl);
        if(StringUtils.isNotBlank(dto.getUrl())){
            dto.setUrl(SystemType.getDomain(dto.getSysType())+"/"+dto.getUrl());
        }
        return dto;
    }
    
    public static void main(String[] args) {
        String vipLevel = "6";
        List<String> vipLevelList = Arrays.asList(vipLevel.split(","));
        System.out.println(vipLevelList);
    }
}
