package com.baijia.tianxiao.sal.marketing.draw.service;

import java.util.List;

import com.baijia.tianxiao.dal.activity.po.draw.PrizeInfo;
import com.baijia.tianxiao.sal.marketing.draw.dto.PrizeInfoDto;

/**
 * @author Rezar
 * @createDate :Jan 25, 2016 5:37:52 PM
 * @desc :
 */
public interface DrawPrizesService {

    /**
     * 添加某个抽奖活动的所有的奖品信息
     * 
     * @param prizeInfos
     */
    public void addPrizes(Long activityId, List<PrizeInfoDto> prizeInfos);

    /**
     * 更新某个抽奖活动的所有奖品信息，这里的更新策略是：根据抽奖活动的activityId 删除掉之前所有的抽奖获得数据，</br>
     * 再将新的奖品数据插入
     * 
     * @param activityId
     * @param prizeInfos
     */
    void updatePrizes(Long activityId, List<PrizeInfo> prizeInfoDtos);

    /**
     * 获取到某个抽奖活动的所有奖品信息
     * 
     * @param activityId
     * @return
     */
    public List<PrizeInfoDto> getPrizeInfoDtosByActivityId(Long activityId);

    /**
     * 保存某个抽奖活动所有的奖品信息
     * 
     * @param prizeInfos
     */
    void addPrizeInfo(List<PrizeInfo> prizeInfos);

    List<PrizeInfo> getPrizeInfosByActivityId(Long activityId);

    void updatePrizesByDtos(Long activityId, List<PrizeInfoDto> prizeInfoDtos);

    public PrizeInfo getPrizeById(Long drawId);


}
