package com.baijia.tianxiao.sal.marketing.draw.dto;

import com.baijia.tianxiao.dal.activity.po.draw.DrawInfo;
import com.baijia.tianxiao.dal.activity.po.draw.PrizeInfo;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

import lombok.Data;

/**
 * Created by liuxp on 16/1/26.
 */
@Data
public class DrawCacheDto implements Serializable {
    private static final long serialVersionUID = -7500214170704502841L;
    private Long startTime; // 当前活动开始时间戳
    private Long endTime;// 活动结束时间
    private int limitCount;// 抽奖次数限制
    private int baseNum;// 基数
    private Long orgId;// 活动所属的机构
    private int templateId;// 活动模板ID
    private int status = 1;
    private PrizeInfo[] prizes;// 奖品
    private int[] probabilities;// 中奖概率*基数
    private Integer delStatus ; //0 :未删除 1:已删除
    private Integer infoFillStatus;

    public int getTemplateId() {
        return templateId;
    }

    public void setTemplateId(int templateId) {
        this.templateId = templateId;
    }

    public Long getStartTime() {
        return startTime;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public Long getEndTime() {
        return endTime;
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    public int getLimitCount() {
        return limitCount;
    }

    public void setLimitCount(int limitCount) {
        this.limitCount = limitCount;
    }

    public int getBaseNum() {
        return baseNum;
    }

    public void setBaseNum(int baseNum) {
        this.baseNum = baseNum;
    }

    public PrizeInfo[] getPrizes() {
        return prizes;
    }

    public void setPrizes(PrizeInfo[] prizes) {
        this.prizes = prizes;
    }

    public int[] getProbabilities() {
        return probabilities;
    }

    public void setProbabilities(int[] probabilities) {
        this.probabilities = probabilities;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public static DrawCacheDto getInstance(DrawInfo drawInfo, List<PrizeInfo> prizeInfos) {
        DrawCacheDto dto = new DrawCacheDto();
        dto.setStartTime(drawInfo.getStartTime().getTime());
        dto.setEndTime(drawInfo.getEndTime().getTime());
        dto.setLimitCount(drawInfo.getCountLimit());
        dto.setBaseNum(getBase(prizeInfos));
        dto.setTemplateId(drawInfo.getTemplateId());
        dto.setOrgId(drawInfo.getOrgId());
        dto.setStatus(drawInfo.getStatus());
        dto.setDelStatus(drawInfo.getDelStatus());
        dto.setInfoFillStatus(drawInfo.getInfoFillStatus());
        PrizeInfo[] prizes = new PrizeInfo[prizeInfos.size()];

        int[] probabilities = new int[prizeInfos.size()];

        for (int i = 0; i < prizeInfos.size(); i++) {
            prizes[i] = prizeInfos.get(i);
            probabilities[i] = prizes[i].getProbability().multiply(new BigDecimal(dto.getBaseNum())).intValue();
        }
        dto.setProbabilities(probabilities);
        dto.setPrizes(prizes);
        return dto;
    }

    private static int getBase(List<PrizeInfo> prizeInfos) {
        int max = 1;
        for (PrizeInfo prize : prizeInfos) {
            String str = prize.getProbability().toString();
            int index = str.indexOf(".");
            if (index != -1) {
                str = str.substring(index);
            }
            int length = str.length();
            if (length > max) {
                max = length;
            }
        }
        return (int) Math.pow(10, max - 1);
    }

    public static void main(String[] args) {
        List<PrizeInfo> prizeInfos = new ArrayList<>();
        PrizeInfo info = new PrizeInfo();
        info.setProbability(new BigDecimal("1"));
        prizeInfos.add(info);
        System.out.println(getBase(prizeInfos));
    }
}
