package com.baijia.tianxiao.sal.marketing.activity.service.impl;

import java.util.Arrays;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.dal.activity.dao.ActivityConfDao;
import com.baijia.tianxiao.dal.activity.po.ActivityConf;
import com.baijia.tianxiao.sal.marketing.activity.dto.ActivityDetailDto;
import com.baijia.tianxiao.sal.marketing.activity.service.ActivityConfService;
import com.baijia.tianxiao.util.GenericsUtils;

/**
 * @author Rezar
 * @createDate :Jan 11, 2016 5:30:35 PM
 * @desc :
 */
@Service
public class ActivityConfServiceImpl implements ActivityConfService {

    @Autowired
    private ActivityConfDao activityConfDao;

    @Override
    public ActivityDetailDto getActivityConfByActivityId(Long id) {
        Map<Long, ActivityConf> retMap = this.activityConfDao.getConfigMapByActivityIds(Arrays.asList(id));
        if (GenericsUtils.isNullOrEmpty(retMap)) {
            return null;
        }
        ActivityConf activityConf = retMap.get(id);
        ActivityDetailDto activityResponseDto = ActivityDetailDto.buildResponse(activityConf);
        return activityResponseDto;
    }

}
