/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.marketing.utils;

import com.baijia.tianxiao.util.GenericsUtils;

public class JsonFormatUtil {
    public static void printJson(String jsonStr) {
        System.out.println(JsonFormatUtil.formatJson(jsonStr));
    }

    public static String formatJson(String jsonStr) {
        if (GenericsUtils.isNullOrEmpty((Object)jsonStr) || jsonStr.length() >= 500) {
            return jsonStr;
        }
        if (jsonStr == null || "".equals(jsonStr)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        char last = '\u0000';
        char current = '\u0000';
        int indent = 0;
        int i = 0;
        while (i < jsonStr.length()) {
            last = current;
            current = jsonStr.charAt(i);
            switch (current) {
                case '[': 
                case '{': {
                    sb.append(current);
                    sb.append('\n');
                    JsonFormatUtil.addIndentBlank(sb, ++indent);
                    break;
                }
                case ']': 
                case '}': {
                    sb.append('\n');
                    JsonFormatUtil.addIndentBlank(sb, --indent);
                    sb.append(current);
                    break;
                }
                case ',': {
                    sb.append(current);
                    if (last == '\\') break;
                    sb.append('\n');
                    JsonFormatUtil.addIndentBlank(sb, indent);
                    break;
                }
                default: {
                    sb.append(current);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    private static void addIndentBlank(StringBuilder sb, int indent) {
        int i = 0;
        while (i < indent) {
            sb.append('\t');
            ++i;
        }
    }
}

