/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.marketing.commons.utils;

import com.univocity.parsers.csv.CsvFormat;
import com.univocity.parsers.csv.CsvWriter;
import com.univocity.parsers.csv.CsvWriterSettings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvUtils {
    private static Logger logger = LoggerFactory.getLogger(CsvUtils.class);

    public static String getRandomString(int length) {
        String base = "abcdefghijklmnopqrstuvwxyz0123456789";
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < length) {
            int number = random.nextInt(base.length());
            sb.append(base.charAt(number));
            ++i;
        }
        return sb.toString();
    }

    public static File writerToCsvFile(File outputFile, CsvContent csvContent, String fileName) {
        File file;
        block13: {
            if (!fileName.endsWith(".csv")) {
                fileName = String.valueOf(fileName) + ".csv";
            }
            file = null;
            file = outputFile != null ? outputFile : new File(String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + fileName);
            if (!file.exists()) {
                try {
                    file.createNewFile();
                }
                catch (IOException e) {
                    logger.error("error : ", (Throwable)e);
                    throw new RuntimeException("can not create new file with filepaht :" + file.getAbsolutePath());
                }
            }
            OutputStreamWriter outputWriter = null;
            try {
                try {
                    byte[] bom = new byte[]{-17, -69, -65};
                    FileOutputStream outputStream = new FileOutputStream(file);
                    ((OutputStream)outputStream).write(bom);
                    outputWriter = new OutputStreamWriter(outputStream);
                    CsvWriterSettings settings = new CsvWriterSettings();
                    settings.setNullValue("?");
                    ((CsvFormat)settings.getFormat()).setComment('-');
                    settings.setEmptyValue("!");
                    settings.setSkipEmptyLines(false);
                    CsvWriter writer = new CsvWriter((Writer)outputWriter, settings);
                    List<RowBean> rowBeans = csvContent.getAllRows();
                    if (rowBeans != null && rowBeans.size() > 0) {
                        for (RowBean rowBean : rowBeans) {
                            if (rowBean.type == RowBean.rowType) {
                                String lineText = rowBean.getContent();
                                writer.writeRow(lineText);
                                continue;
                            }
                            if (rowBean.type != RowBean.tableType) continue;
                            String[] heads = rowBean.getHeads();
                            List<String> rows = rowBean.getRows();
                            writer.writeHeaders(heads);
                            int i = 0;
                            while (i < rows.size()) {
                                writer.writeRow(rows.get(i));
                                ++i;
                            }
                        }
                    }
                    writer.close();
                }
                catch (Exception ex) {
                    logger.info("can not create csv file ,{}", (Throwable)ex);
                    IOUtils.closeQuietly(outputWriter);
                    break block13;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputWriter);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)outputWriter);
        }
        return file;
    }

    public static class CsvContent {
        private List<RowBean> rowBeans = new ArrayList<RowBean>();

        public void addRowBean(RowBean rb) {
            this.rowBeans.add(rb);
        }

        public void deleteRowBean(RowBean rowBean) {
            this.rowBeans.remove(rowBean);
        }

        public List<RowBean> getAllRows() {
            return this.rowBeans;
        }
    }

    public static class RowBean {
        public static final Integer rowType = 1;
        public static final Integer tableType = 2;
        private Integer type;
        private String content;
        private String[] heads;
        private List<String> rows;

        public static RowBean createRowType(String rowText) {
            RowBean rb = new RowBean();
            rb.setType(1);
            rb.setContent(rowText);
            return rb;
        }

        public static RowBean createTableType(String[] heads, List<String> rows) {
            RowBean rb = new RowBean();
            rb.setType(tableType);
            rb.setHeads(heads);
            rb.setRows(rows);
            return rb;
        }

        public Integer getType() {
            return this.type;
        }

        public void setType(Integer type) {
            this.type = type;
        }

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public String[] getHeads() {
            return this.heads;
        }

        public void setHeads(String[] heads) {
            this.heads = heads;
        }

        public List<String> getRows() {
            return this.rows;
        }

        public void setRows(List<String> rows) {
            this.rows = rows;
        }
    }
}

