/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.marketing.commons.dtos;

import com.baijia.tianxiao.dal.activity.enums.ActivityStatus;
import com.baijia.tianxiao.dal.activity.po.TxActivityCommon;
import com.baijia.tianxiao.sal.marketing.commons.enums.TemplateTypeCategory;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxActivityMergeDto {
    private static final Logger log = LoggerFactory.getLogger(TxActivityMergeDto.class);
    private Long activityId;
    private String title;
    private Integer brouseCount;
    private long updateTime;
    private Integer templateId;
    private Integer templateType;
    private String templateTypeStr;
    private Integer status;
    private String statusStr;

    public static TxActivityMergeDto buildInstanceByTxAcitivityConf(TxActivityCommon conf, Integer status) {
        ActivityStatus activityStatus;
        TxActivityMergeDto dto = new TxActivityMergeDto();
        dto.setActivityId(conf.getActivityId());
        dto.setTitle(conf.getTitle());
        dto.setBrouseCount(conf.getAccessCount());
        dto.setUpdateTime(conf.getUpdateTime().getTime());
        dto.setTemplateId(conf.getTemplateId());
        TemplateTypeCategory category = TemplateTypeCategory.getTemplateTypeCategoryByTypeId(conf.getTemplateTypeId());
        if (category != null) {
            dto.setTemplateType(category.getType());
            dto.setTemplateTypeStr(category.getLabel());
        }
        Date curDate = new Date();
        if (status == null) {
            status = conf.getStatus().intValue() == ActivityStatus.CLOSED.getCode() ? conf.getStatus() : (conf.getStartTime().after(curDate) ? Integer.valueOf(ActivityStatus.UN_START.getCode()) : (conf.getEndTime().before(curDate) ? Integer.valueOf(ActivityStatus.END.getCode()) : Integer.valueOf(ActivityStatus.RUNNING.getCode())));
        }
        if ((activityStatus = ActivityStatus.getActivityStatus((int)status)) != null) {
            dto.setStatus(status);
            dto.setStatusStr(activityStatus.getDesc());
        }
        return dto;
    }

    public Long getActivityId() {
        return this.activityId;
    }

    public String getTitle() {
        return this.title;
    }

    public Integer getBrouseCount() {
        return this.brouseCount;
    }

    public long getUpdateTime() {
        return this.updateTime;
    }

    public Integer getTemplateId() {
        return this.templateId;
    }

    public Integer getTemplateType() {
        return this.templateType;
    }

    public String getTemplateTypeStr() {
        return this.templateTypeStr;
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getStatusStr() {
        return this.statusStr;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setBrouseCount(Integer brouseCount) {
        this.brouseCount = brouseCount;
    }

    public void setUpdateTime(long updateTime) {
        this.updateTime = updateTime;
    }

    public void setTemplateId(Integer templateId) {
        this.templateId = templateId;
    }

    public void setTemplateType(Integer templateType) {
        this.templateType = templateType;
    }

    public void setTemplateTypeStr(String templateTypeStr) {
        this.templateTypeStr = templateTypeStr;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setStatusStr(String statusStr) {
        this.statusStr = statusStr;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TxActivityMergeDto)) {
            return false;
        }
        TxActivityMergeDto other = (TxActivityMergeDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$activityId = this.getActivityId();
        Long other$activityId = other.getActivityId();
        if (this$activityId == null ? other$activityId != null : !((Object)this$activityId).equals(other$activityId)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        Integer this$brouseCount = this.getBrouseCount();
        Integer other$brouseCount = other.getBrouseCount();
        if (this$brouseCount == null ? other$brouseCount != null : !((Object)this$brouseCount).equals(other$brouseCount)) {
            return false;
        }
        if (this.getUpdateTime() != other.getUpdateTime()) {
            return false;
        }
        Integer this$templateId = this.getTemplateId();
        Integer other$templateId = other.getTemplateId();
        if (this$templateId == null ? other$templateId != null : !((Object)this$templateId).equals(other$templateId)) {
            return false;
        }
        Integer this$templateType = this.getTemplateType();
        Integer other$templateType = other.getTemplateType();
        if (this$templateType == null ? other$templateType != null : !((Object)this$templateType).equals(other$templateType)) {
            return false;
        }
        String this$templateTypeStr = this.getTemplateTypeStr();
        String other$templateTypeStr = other.getTemplateTypeStr();
        if (this$templateTypeStr == null ? other$templateTypeStr != null : !this$templateTypeStr.equals(other$templateTypeStr)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        String this$statusStr = this.getStatusStr();
        String other$statusStr = other.getStatusStr();
        return !(this$statusStr == null ? other$statusStr != null : !this$statusStr.equals(other$statusStr));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TxActivityMergeDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $activityId = this.getActivityId();
        result = result * 59 + ($activityId == null ? 43 : ((Object)$activityId).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        Integer $brouseCount = this.getBrouseCount();
        result = result * 59 + ($brouseCount == null ? 43 : ((Object)$brouseCount).hashCode());
        long $updateTime = this.getUpdateTime();
        result = result * 59 + (int)($updateTime ^ $updateTime >>> 32);
        Integer $templateId = this.getTemplateId();
        result = result * 59 + ($templateId == null ? 43 : ((Object)$templateId).hashCode());
        Integer $templateType = this.getTemplateType();
        result = result * 59 + ($templateType == null ? 43 : ((Object)$templateType).hashCode());
        String $templateTypeStr = this.getTemplateTypeStr();
        result = result * 59 + ($templateTypeStr == null ? 43 : $templateTypeStr.hashCode());
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        String $statusStr = this.getStatusStr();
        result = result * 59 + ($statusStr == null ? 43 : $statusStr.hashCode());
        return result;
    }

    public String toString() {
        return "TxActivityMergeDto(activityId=" + this.getActivityId() + ", title=" + this.getTitle() + ", brouseCount=" + this.getBrouseCount() + ", updateTime=" + this.getUpdateTime() + ", templateId=" + this.getTemplateId() + ", templateType=" + this.getTemplateType() + ", templateTypeStr=" + this.getTemplateTypeStr() + ", status=" + this.getStatus() + ", statusStr=" + this.getStatusStr() + ")";
    }
}

