/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.marketing.article.utils;

import com.baijia.tianxiao.sal.marketing.article.utils.AnimatedGifEncoder;
import com.baijia.tianxiao.sal.marketing.article.utils.GifDecoder;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;

public class ImageUtil {
    public static String getImageFormatName(File file) throws IOException {
        String formatName = null;
        ImageInputStream iis = ImageIO.createImageInputStream(file);
        Iterator<ImageReader> imageReader = ImageIO.getImageReaders(iis);
        if (imageReader.hasNext()) {
            ImageReader reader = imageReader.next();
            formatName = reader.getFormatName();
        }
        return formatName;
    }

    public static String cutImage(String sourcePath, String targetPath, int x, int y, int width, int height) throws IOException {
        BufferedImage image;
        String formatName;
        File file = new File(sourcePath);
        if (!file.exists()) {
            throw new IOException("not found the image\uff1a" + sourcePath);
        }
        if (targetPath == null || targetPath.isEmpty()) {
            targetPath = sourcePath;
        }
        if ((formatName = ImageUtil.getImageFormatName(file)) == null) {
            return targetPath;
        }
        formatName = formatName.toLowerCase();
        String pathPrefix = ImageUtil.getPathWithoutSuffix(targetPath);
        targetPath = String.valueOf(pathPrefix) + formatName;
        if (IMAGE_FORMAT.GIF.getValue() == formatName) {
            GifDecoder decoder = new GifDecoder();
            int status = decoder.read(sourcePath);
            if (status != 0) {
                throw new IOException("read image " + sourcePath + " error!");
            }
            AnimatedGifEncoder encoder = new AnimatedGifEncoder();
            encoder.start(targetPath);
            encoder.setRepeat(decoder.getLoopCount());
            int i = 0;
            while (i < decoder.getFrameCount()) {
                encoder.setDelay(decoder.getDelay(i));
                BufferedImage childImage = decoder.getFrame(i);
                BufferedImage image2 = childImage.getSubimage(x, y, width, height);
                encoder.addFrame(image2);
                ++i;
            }
            encoder.finish();
        } else {
            image = ImageIO.read(file);
            image = image.getSubimage(x, y, width, height);
            ImageIO.write((RenderedImage)image, formatName, new File(targetPath));
        }
        image = ImageIO.read(file);
        image = image.getSubimage(x, y, width, height);
        ImageIO.write((RenderedImage)image, formatName, new File(targetPath));
        return targetPath;
    }

    public static String zoom(String sourcePath, String targetPath, int width, int height) throws IOException {
        BufferedImage image;
        String formatName;
        File file = new File(sourcePath);
        if (!file.exists()) {
            throw new IOException("not found the image \uff1a" + sourcePath);
        }
        if (targetPath == null || targetPath.isEmpty()) {
            targetPath = sourcePath;
        }
        if ((formatName = ImageUtil.getImageFormatName(file)) == null) {
            return targetPath;
        }
        formatName = formatName.toLowerCase();
        String pathPrefix = ImageUtil.getPathWithoutSuffix(targetPath);
        targetPath = String.valueOf(pathPrefix) + formatName;
        if (IMAGE_FORMAT.GIF.getValue() == formatName) {
            GifDecoder decoder = new GifDecoder();
            int status = decoder.read(sourcePath);
            if (status != 0) {
                throw new IOException("read image " + sourcePath + " error!");
            }
            AnimatedGifEncoder encoder = new AnimatedGifEncoder();
            encoder.start(targetPath);
            encoder.setRepeat(decoder.getLoopCount());
            int i = 0;
            while (i < decoder.getFrameCount()) {
                encoder.setDelay(decoder.getDelay(i));
                BufferedImage image2 = ImageUtil.zoom(decoder.getFrame(i), width, height);
                encoder.addFrame(image2);
                ++i;
            }
            encoder.finish();
        } else {
            image = ImageIO.read(file);
            BufferedImage zoomImage = ImageUtil.zoom(image, width, height);
            ImageIO.write((RenderedImage)zoomImage, formatName, new File(targetPath));
        }
        image = ImageIO.read(file);
        BufferedImage zoomImage = ImageUtil.zoom(image, width, height);
        ImageIO.write((RenderedImage)zoomImage, formatName, new File(targetPath));
        return targetPath;
    }

    public static BufferedImage getGifFirstFrame(InputStream is, int frameIndex) throws IOException {
        GifDecoder decoder = new GifDecoder();
        int status = decoder.read(is);
        if (status != 0) {
            throw new IOException("read image  error!");
        }
        return decoder.getFrame(frameIndex);
    }

    public static BufferedImage[] readerImage(File file) throws IOException {
        BufferedImage sourceImage = ImageIO.read(file);
        BufferedImage[] images = null;
        ImageInputStream iis = ImageIO.createImageInputStream(file);
        Iterator<ImageReader> imageReaders = ImageIO.getImageReaders(iis);
        if (imageReaders.hasNext()) {
            ImageReader reader = imageReaders.next();
            reader.setInput(iis);
            int imageNumber = reader.getNumImages(true);
            images = new BufferedImage[imageNumber];
            int i = 0;
            while (i < imageNumber) {
                BufferedImage image = reader.read(i);
                if (sourceImage.getWidth() > image.getWidth() || sourceImage.getHeight() > image.getHeight()) {
                    image = ImageUtil.zoom(image, sourceImage.getWidth(), sourceImage.getHeight());
                }
                images[i] = image;
                ++i;
            }
            reader.dispose();
            iis.close();
        }
        return images;
    }

    public static BufferedImage[] processImage(BufferedImage[] images, int x, int y, int width, int height) throws Exception {
        if (images == null) {
            return images;
        }
        BufferedImage[] oldImages = images;
        images = new BufferedImage[images.length];
        int i = 0;
        while (i < oldImages.length) {
            BufferedImage image = oldImages[i];
            images[i] = image.getSubimage(x, y, width, height);
            ++i;
        }
        return images;
    }

    public static void writerImage(BufferedImage[] images, String formatName, File file) throws Exception {
        Iterator<ImageWriter> imageWriters = ImageIO.getImageWritersByFormatName(formatName);
        if (imageWriters.hasNext()) {
            ImageWriter writer = imageWriters.next();
            String fileName = file.getName();
            int index = fileName.lastIndexOf(".");
            if (index > 0) {
                fileName = String.valueOf(fileName.substring(0, index + 1)) + formatName;
            }
            String pathPrefix = ImageUtil.getFilePrefixPath(file.getPath());
            File outFile = new File(String.valueOf(pathPrefix) + fileName);
            ImageOutputStream ios = ImageIO.createImageOutputStream(outFile);
            writer.setOutput(ios);
            if (writer.canWriteSequence()) {
                writer.prepareWriteSequence(null);
                int i = 0;
                while (i < images.length) {
                    BufferedImage childImage = images[i];
                    IIOImage image = new IIOImage(childImage, null, null);
                    writer.writeToSequence(image, null);
                    ++i;
                }
                writer.endWriteSequence();
            } else {
                int i = 0;
                while (i < images.length) {
                    writer.write(images[i]);
                    ++i;
                }
            }
            writer.dispose();
            ios.close();
        }
    }

    public static void cutImage(File sourceFile, File destFile, int x, int y, int width, int height) throws Exception {
        BufferedImage[] images = ImageUtil.readerImage(sourceFile);
        images = ImageUtil.processImage(images, x, y, width, height);
        String formatName = ImageUtil.getImageFormatName(sourceFile);
        destFile = new File(String.valueOf(ImageUtil.getPathWithoutSuffix(destFile.getPath())) + formatName);
        ImageUtil.writerImage(images, formatName, destFile);
    }

    public static void getOSSupportsStandardImageFormat() {
        String[] readerFormatName = ImageIO.getReaderFormatNames();
        String[] readerSuffixName = ImageIO.getReaderFileSuffixes();
        String[] readerMIMEType = ImageIO.getReaderMIMETypes();
        System.out.println("========================= OS supports reader ========================");
        System.out.println("OS supports reader format name :  " + Arrays.asList(readerFormatName));
        System.out.println("OS supports reader suffix name :  " + Arrays.asList(readerSuffixName));
        System.out.println("OS supports reader MIME type :  " + Arrays.asList(readerMIMEType));
        String[] writerFormatName = ImageIO.getWriterFormatNames();
        String[] writerSuffixName = ImageIO.getWriterFileSuffixes();
        String[] writerMIMEType = ImageIO.getWriterMIMETypes();
        System.out.println("========================= OS supports writer ========================");
        System.out.println("OS supports writer format name :  " + Arrays.asList(writerFormatName));
        System.out.println("OS supports writer suffix name :  " + Arrays.asList(writerSuffixName));
        System.out.println("OS supports writer MIME type :  " + Arrays.asList(writerMIMEType));
    }

    private static BufferedImage zoom(BufferedImage sourceImage, int width, int height) {
        BufferedImage zoomImage = new BufferedImage(width, height, sourceImage.getType());
        Image image = sourceImage.getScaledInstance(width, height, 4);
        Graphics gc = zoomImage.getGraphics();
        gc.setColor(Color.WHITE);
        gc.drawImage(image, 0, 0, null);
        return zoomImage;
    }

    public static String getFilePrefixPath(File file) throws IOException {
        String path = null;
        if (!file.exists()) {
            throw new IOException("not found the file !");
        }
        String fileName = file.getName();
        path = file.getPath().replace(fileName, "");
        return path;
    }

    public static String getFilePrefixPath(String path) throws Exception {
        if (path == null || path.isEmpty()) {
            throw new Exception("\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a\uff01");
        }
        int index = path.lastIndexOf(File.separator);
        if (index > 0) {
            path = path.substring(0, index + 1);
        }
        return path;
    }

    public static String getPathWithoutSuffix(String src) {
        String path = src;
        int index = path.lastIndexOf(".");
        if (index > 0) {
            path = path.substring(0, index + 1);
        }
        return path;
    }

    public static String getFileName(String filePath) throws IOException {
        File file = new File(filePath);
        if (!file.exists()) {
            throw new IOException("not found the file !");
        }
        return file.getName();
    }

    public static void main(String[] args) throws Exception {
        try {
            int x = 100;
            int y = 75;
            int width = 100;
            int height = 100;
            int clientWidth = 300;
            int clientHeight = 250;
            File file = new File("C:\\1.jpg");
            BufferedImage image = ImageIO.read(file);
            double destWidth = image.getWidth();
            double destHeight = image.getHeight();
            if (destWidth < (double)width || destHeight < (double)height) {
                throw new Exception("\u6e90\u56fe\u5927\u5c0f\u5c0f\u4e8e\u622a\u53d6\u56fe\u7247\u5927\u5c0f!");
            }
            double widthRatio = destWidth / (double)clientWidth;
            double heightRatio = destHeight / (double)clientHeight;
            x = Double.valueOf((double)x * widthRatio).intValue();
            y = Double.valueOf((double)y * heightRatio).intValue();
            width = Double.valueOf((double)width * widthRatio).intValue();
            height = Double.valueOf((double)height * heightRatio).intValue();
            System.out.println("\u88c1\u526a\u5927\u5c0f  x:" + x + ",y:" + y + ",width:" + width + ",height:" + height);
            String formatName = ImageUtil.getImageFormatName(file);
            String pathSuffix = "." + formatName;
            String pathPrefix = ImageUtil.getFilePrefixPath(file);
            String targetPath = String.valueOf(pathPrefix) + System.currentTimeMillis() + pathSuffix;
            targetPath = ImageUtil.cutImage(file.getPath(), targetPath, x, y, width, height);
            String bigTargetPath = String.valueOf(pathPrefix) + System.currentTimeMillis() + pathSuffix;
            ImageUtil.zoom(targetPath, bigTargetPath, 100, 100);
            String smallTargetPath = String.valueOf(pathPrefix) + System.currentTimeMillis() + pathSuffix;
            ImageUtil.zoom(targetPath, smallTargetPath, 50, 50);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static enum IMAGE_FORMAT {
        BMP("bmp"),
        JPG("jpg"),
        WBMP("wbmp"),
        JPEG("jpeg"),
        PNG("png"),
        GIF("gif");

        private String value;

        private IMAGE_FORMAT(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

