/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.marketing.article.enums;

import com.baijia.tianxiao.sal.marketing.article.enums.ArticleTypes;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum TouTiaoArticleEnum {
    GAOKAO(2, ArticleTypes.EDUCATION, "\u9ad8\u8003"),
    YIKAO(3, ArticleTypes.EDUCATION, "\u827a\u8003"),
    YIASI(4, ArticleTypes.EDUCATION, "\u96c5\u601d"),
    ZHONGXIAOXUE(5, ArticleTypes.EDUCATION, "\u4e2d\u5c0f\u5b66"),
    SILIUJI(6, ArticleTypes.EDUCATION, "\u56db\u516d\u7ea7"),
    KAOYAN(7, ArticleTypes.EDUCATION, "\u8003\u7814"),
    LINGDAOLI(8, ArticleTypes.CAREER, "\u9886\u5bfc\u529b"),
    CHANPINGYUNYING(9, ArticleTypes.CAREER, "\u4ea7\u54c1\u8fd0\u8425"),
    KOUCAI(10, ArticleTypes.CAREER, "\u53e3\u624d"),
    CAIHUIKAOSHI(11, ArticleTypes.CAREER, "\u8d22\u4f1a\u8003\u8bd5"),
    CHUANGYE(12, ArticleTypes.CAREER, "\u521b\u4e1a"),
    SHEYING(14, ArticleTypes.CREATIVE, "\u6444\u5f71"),
    SHEJI(15, ArticleTypes.CREATIVE, "\u8bbe\u8ba1"),
    XIAOHUA(16, ArticleTypes.LIFE, "\u6821\u82b1"),
    MEISHI(17, ArticleTypes.LIFE, "\u7f8e\u98df"),
    LICAI(18, ArticleTypes.LIFE, "\u7406\u8d22"),
    DUANZI(19, ArticleTypes.LIFE, "\u6bb5\u5b50"),
    MEIZHUANG(20, ArticleTypes.LIFE, "\u7f8e\u5986"),
    TIYU(21, ArticleTypes.LIFE, "\u4f53\u80b2"),
    QINGGAN(22, ArticleTypes.EMOTION, "\u60c5\u611f"),
    LVXING(23, ArticleTypes.TRAVEL, "\u65c5\u6e38"),
    MEIWEN(25, ArticleTypes.CULTURE, "\u7f8e\u6587");

    public ArticleTypes articleType;
    public Integer typeId;
    public String desc;
    private static Map<Integer, String> typeCache;
    private static Map<String, Integer> categoryMap;

    static {
        typeCache = new HashMap<Integer, String>();
        categoryMap = Maps.newHashMap();
        TouTiaoArticleEnum[] touTiaoArticleEnumArray = TouTiaoArticleEnum.values();
        int n = touTiaoArticleEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            TouTiaoArticleEnum type = touTiaoArticleEnumArray[n2];
            typeCache.put(type.typeId, type.desc);
            categoryMap.put(type.desc, type.articleType.code);
            ++n2;
        }
    }

    private TouTiaoArticleEnum(Integer typeId, ArticleTypes articleType, String desc) {
        this.typeId = typeId;
        this.articleType = articleType;
        this.desc = desc;
    }

    public static List<String> getTypeDescs() {
        return new ArrayList<String>(typeCache.values());
    }

    public static Integer getCategory(String desc) {
        Integer category = categoryMap.get(desc);
        return category;
    }
}

