/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.marketing.utils;

import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.dto.WebResponse;
import com.baijia.tianxiao.sal.marketing.commons.constants.Config;
import com.baijia.tianxiao.sal.marketing.smsGroupSend.dto.CourseDto;
import com.baijia.tianxiao.sal.marketing.smsGroupSend.dto.SmsGroupSendResp;
import com.baijia.tianxiao.sal.marketing.smsGroupSend.dto.StudentDto;
import com.baijia.tianxiao.sal.marketing.utils.JsonFormatUtil;
import com.baijia.tianxiao.sal.marketing.utils.MarketingWebResponseMap;
import com.baijia.tianxiao.sal.marketing.utils.ObjectReflectUtil;
import com.baijia.tianxiao.util.GenericsUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarketingWebResponse
extends WebResponse<Object> {
    private static final Logger log = LoggerFactory.getLogger(MarketingWebResponse.class);
    private static final long serialVersionUID = 6851388595876586409L;
    public static boolean canLogWithResponse = false;
    private boolean dataIsList = false;
    private Object dataToListValue = null;
    private boolean nullToRemove;
    private Map<String, Object> outerDataMap = Maps.newHashMap();

    private MarketingWebResponse() {
    }

    public MarketingWebResponse(Object data) {
        this.paddingData(data);
    }

    public MarketingWebResponse(UniverseErrorCode errorCode) {
        super(errorCode);
    }

    public MarketingWebResponse(UniverseErrorCode errorCode, String msg) {
        super(errorCode, msg);
    }

    private void paddingData(Object data) {
        if (super.getData() != null && !this.dataIsList) {
            this.paddingDataFromObj(data);
            return;
        }
        if (!this.checkoutIsArray(data)) {
            super.setData(new HashMap());
            this.paddingDataFromObj(data);
        } else {
            super.setData(data);
            this.dataIsList = true;
        }
    }

    private boolean checkoutIsArray(Object data) {
        if (data == null) {
            return false;
        }
        return data instanceof Collection || data.getClass().isArray() || data instanceof Iterable;
    }

    private void paddingDataFromObj(Object data) {
        this.getSuperDataMap().putAll(ObjectReflectUtil.getFieldValues(data));
    }

    public void setData(Object data) {
        this.addData(data);
    }

    public MarketingWebResponse addData(Object data) {
        this.paddingData(data);
        return this;
    }

    public MarketingWebResponse addInnerData(String key, Object data) {
        if (this.dataIsList) {
            throw new UnsupportedOperationException("\u5f53\u524d\u6570\u636e\u4e3a\u5217\u8868\u6570\u636e\uff0c\u65e0\u6cd5\u8fdb\u884c\u5176\u4f59\u6570\u636e\u7684\u586b\u5145");
        }
        if (super.getData() instanceof Map) {
            ((Map)super.getData()).put(key, data);
        }
        return this;
    }

    public MarketingWebResponse addOuterData(String key, Object data) {
        this.outerDataMap.put(key, data);
        return this;
    }

    public MarketingWebResponse removeInnerData(String key) {
        if (this.dataIsList) {
            throw new UnsupportedOperationException("\u5f53\u524d\u6570\u636e\u4e3a\u5217\u8868\u6570\u636e\uff0c\u65e0\u6cd5\u8fdb\u884c\u5176\u4f59\u6570\u636e\u7684\u586b\u5145");
        }
        if (super.getData() instanceof Map) {
            ((Map)super.getData()).remove(key);
        }
        return this;
    }

    public MarketingWebResponse removeInnerDatas(String ... keys) {
        this.removeKey(false, keys);
        return this;
    }

    public MarketingWebResponse removeOutterDatas(String ... keys) {
        this.removeKey(true, keys);
        return this;
    }

    private void removeKey(boolean isOutter, String ... keys) {
        if (GenericsUtils.notNullAndEmpty((Object)keys)) {
            for (String key : keys) {
                if (isOutter) {
                    this.removeOuterData(key);
                    continue;
                }
                this.removeInnerData(key);
            }
        }
    }

    public MarketingWebResponse nullToRemove(boolean nullToRemove) {
        this.nullToRemove = nullToRemove;
        return this;
    }

    public MarketingWebResponse replcaeFromInnerData(String key) {
        Object innerData = this.removeKey(key, false);
        this.addOuterData(key, innerData);
        return this;
    }

    public MarketingWebResponse replaceFromOutterData(String key) {
        Object outterData = this.removeKey(key, true);
        this.addInnerData(key, outterData);
        return this;
    }

    public MarketingWebResponse dataToList(String key) {
        if (!this.dataIsList) {
            this.dataToListValue = this.getKey(key, false);
        }
        return this;
    }

    private Object removeKey(String key, boolean isOutter) {
        Object keyValue = this.getKey(key, isOutter);
        if (keyValue != null) {
            if (isOutter) {
                this.removeOuterData(key);
            } else {
                this.removeInnerData(key);
            }
        }
        return keyValue;
    }

    private Object getKey(String key, boolean isOutter) {
        if (!isOutter && !this.dataIsList) {
            Map<String, Object> dataMap = this.getSuperDataMap();
            return dataMap.get(key);
        }
        return this.outerDataMap.get(key);
    }

    private Map<String, Object> getSuperDataMap() {
        Map dataMap = (Map)super.getData();
        return dataMap;
    }

    public MarketingWebResponse dataToListFromOuter(String key) {
        this.dataToListValue = this.getKey(key, true);
        return this;
    }

    public MarketingWebResponse removeOuterData(String key) {
        this.outerDataMap.remove(key);
        return this;
    }

    public MarketingWebResponseMap toWebResponse() {
        this.outerDataMap.put("code", super.getCode());
        this.outerDataMap.put("msg", super.getMsg());
        Map<String, Object> superData = super.getData();
        Map<String, Object> tempOuterMap = this.outerDataMap;
        if (this.nullToRemove) {
            tempOuterMap = this.removeNullKeys(this.outerDataMap);
            if (!this.dataIsList) {
                superData = this.removeNullKeys(this.getSuperDataMap());
            }
        }
        if (this.dataToListValue != null) {
            tempOuterMap.put("data", this.dataToListValue);
        } else {
            tempOuterMap.put("data", superData);
        }
        return MarketingWebResponseMap.newInstance(tempOuterMap);
    }

    public MarketingWebResponseMap toWebResponseWithLog() {
        MarketingWebResponseMap respMap = this.toWebResponse();
        if (canLogWithResponse) {
            ObjectMapper objectMapper = new ObjectMapper();
            StringWriter writer = new StringWriter();
            try {
                objectMapper.writeValue((Writer)writer, (Object)respMap);
                log.info("[response : ] {}", (Object)JsonFormatUtil.formatJson(writer.toString()));
                writer.close();
            }
            catch (IOException e) {
                log.info("can not writeValue from obj: {} ", (Object)respMap);
            }
        }
        return respMap;
    }

    private Map<String, Object> removeNullKeys(Map<String, Object> valueMap) {
        HashMap tempMap = Maps.newHashMap(valueMap);
        try {
            ArrayList removeKeys = Lists.newArrayList();
            for (String key : tempMap.keySet()) {
                if (tempMap.get(key) != null) continue;
                removeKeys.add(key);
            }
            for (String key : removeKeys) {
                tempMap.remove(key);
            }
        }
        catch (Exception e) {
            log.error("error while removeNullKey L {}", (Throwable)e);
        }
        return tempMap;
    }

    public MarketingWebResponse addMsg(String msg) {
        super.setMsg(msg);
        return this;
    }

    public MarketingWebResponse addCode(UniverseErrorCode code) {
        super.setErrorCode(code);
        return this;
    }

    public MarketingWebResponse addCode(int code) {
        super.setCode((long)code);
        return this;
    }

    public static MarketingWebResponse build() {
        return new MarketingWebResponse();
    }

    public static MarketingWebResponse build(Object data) {
        return new MarketingWebResponse(data);
    }

    public static void main(String[] args) {
        SmsGroupSendResp dto = new SmsGroupSendResp();
        ArrayList courseDtos = Lists.newArrayList();
        courseDtos.add(new CourseDto());
        courseDtos.add(new CourseDto());
        courseDtos.add(new CourseDto());
        dto.setCourses(courseDtos);
        ArrayList studentDtos = Lists.newArrayList();
        studentDtos.add(new StudentDto());
        studentDtos.add(new StudentDto());
        studentDtos.add(new StudentDto());
        dto.setStudents(studentDtos);
        MarketingWebResponse resp = MarketingWebResponse.build().addData(dto).nullToRemove(true);
        resp.toWebResponseWithLog();
    }

    static {
        String env = Config.SYSTEM_ENV;
        if (env == null || !env.equalsIgnoreCase("online")) {
            canLogWithResponse = true;
        }
    }
}

