/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.marketing.commons.service.impl;

import com.baijia.tianxiao.redis.AbstractBaseRedisDao;
import com.baijia.tianxiao.sal.marketing.commons.enums.ConstantEnums;
import com.baijia.tianxiao.sal.marketing.commons.enums.EmailType;
import com.baijia.tianxiao.sal.marketing.commons.service.RedisService;
import com.baijia.tianxiao.sal.marketing.draw.dto.DrawCacheDto;
import com.baijia.tianxiao.sal.marketing.vote.dto.VoteCacheDto;
import com.baijia.tianxiao.util.GenericsUtils;
import java.util.Date;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.stereotype.Service;

@Service
public class RedisServiceImpl
extends AbstractBaseRedisDao<String, Object>
implements RedisService {
    private static final Logger log = LoggerFactory.getLogger(RedisServiceImpl.class);
    public final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String emailCountKey = "TX#ACTIVITY#EMAIL#COUNT";
    public static final String DRAW_ACTIVITY_KEY = "TX#ACTIVITY#DRAW";
    public static final String VOTE_ACTIVITY_KEY = "TX#ACTIVITY#VOTE";
    public static final String ACTIVITY_VISITY_COUNT_KEY = "TX#ACTIVITY#VISITY#COUNT";
    public static final String ACTIVITY_VISITY_STATUS_KEY = "TX#ACTIVITY#STATUS_NEW";
    private static final int EMAIL_COUNT_LIMIT = GenericsUtils.isNullOrEmpty((Object)ConstantEnums.EMAIL_COUNT_LIMIT.value()) ? Integer.parseInt(ConstantEnums.EMAIL_COUNT_LIMIT.value()) : 5;

    @Override
    public Integer visitCount(String wechatOpenId, Long orgId) {
        final String fieldStr = this.getAcitivityVisitCountKey(wechatOpenId, orgId);
        return (Integer)this.redisTemplate.execute((RedisCallback)new RedisCallback<Integer>(){

            public Integer doInRedis(RedisConnection connection) throws DataAccessException {
                connection.select(6);
                RedisSerializer serializer = RedisServiceImpl.this.getRedisSerializer();
                byte[] keyBytes = serializer.serialize((Object)RedisServiceImpl.ACTIVITY_VISITY_COUNT_KEY);
                byte[] field = serializer.serialize((Object)fieldStr);
                RedisSerializer redisSerializer = RedisServiceImpl.this.redisTemplate.getDefaultSerializer();
                byte[] value = connection.hGet(keyBytes, field);
                return (Integer)redisSerializer.deserialize(value);
            }
        });
    }

    private String getAcitivityVisitCountKey(String wechatOpenId, long orgId) {
        String format = "%s_%s";
        String fieldStr = String.format(format, orgId, wechatOpenId);
        return fieldStr;
    }

    @Override
    public void setVisitCount(String wechatOpenId, Long orgId, final Integer count) {
        final String fieldStr = this.getAcitivityVisitCountKey(wechatOpenId, orgId);
        this.redisTemplate.execute((RedisCallback)new RedisCallback<Integer>(){

            public Integer doInRedis(RedisConnection connection) throws DataAccessException {
                connection.select(6);
                RedisSerializer serializer = RedisServiceImpl.this.getRedisSerializer();
                byte[] keyBytes = serializer.serialize((Object)RedisServiceImpl.ACTIVITY_VISITY_COUNT_KEY);
                byte[] field = serializer.serialize((Object)fieldStr);
                RedisSerializer redisSerializer = RedisServiceImpl.this.redisTemplate.getDefaultSerializer();
                byte[] value = redisSerializer.serialize((Object)count);
                connection.hSet(keyBytes, field, value);
                log.info("success to update visit count for for field : {} with count : {}  ", (Object)fieldStr, (Object)count);
                return null;
            }
        });
    }

    @Override
    public void setDrawActivityBase(final long activityId, final DrawCacheDto cacheDto) {
        this.redisTemplate.execute((RedisCallback)new RedisCallback<Object>(){

            public Object doInRedis(RedisConnection connection) throws DataAccessException {
                connection.select(6);
                RedisSerializer serializer = RedisServiceImpl.this.getRedisSerializer();
                byte[] key = serializer.serialize((Object)RedisServiceImpl.DRAW_ACTIVITY_KEY);
                byte[] field = serializer.serialize((Object)RedisServiceImpl.this.getDrawActivityKey(activityId));
                RedisSerializer redisSerializer = RedisServiceImpl.this.redisTemplate.getDefaultSerializer();
                byte[] value = redisSerializer.serialize((Object)cacheDto);
                connection.hSet(key, field, value);
                RedisServiceImpl.this.logger.info("[Redis] Update success. ActivityId=" + activityId);
                return null;
            }
        });
    }

    @Override
    public DrawCacheDto getDrawActivityBase(final long activityId) {
        this.logger.info("[Redis] activityId=" + activityId);
        return (DrawCacheDto)this.redisTemplate.execute((RedisCallback)new RedisCallback<DrawCacheDto>(){

            public DrawCacheDto doInRedis(RedisConnection connection) throws DataAccessException {
                RedisServiceImpl.this.logger.info("[Redis] Query start.");
                connection.select(6);
                RedisSerializer serializer = RedisServiceImpl.this.getRedisSerializer();
                byte[] key = serializer.serialize((Object)RedisServiceImpl.DRAW_ACTIVITY_KEY);
                byte[] field = serializer.serialize((Object)RedisServiceImpl.this.getDrawActivityKey(activityId));
                RedisSerializer redisSerializer = RedisServiceImpl.this.redisTemplate.getDefaultSerializer();
                byte[] value = connection.hGet(key, field);
                RedisServiceImpl.this.logger.info("[Redis] Query success.");
                return (DrawCacheDto)redisSerializer.deserialize(value);
            }
        });
    }

    @Override
    public VoteCacheDto getVoteActivityBase(final Long activityId) {
        this.logger.info("[redis] activityId: ", (Object)activityId);
        return (VoteCacheDto)this.redisTemplate.execute((RedisCallback)new RedisCallback<VoteCacheDto>(){

            public VoteCacheDto doInRedis(RedisConnection connection) throws DataAccessException {
                RedisServiceImpl.this.logger.info("[Redis Query Start.]");
                connection.select(6);
                RedisSerializer serializer = RedisServiceImpl.this.getRedisSerializer();
                byte[] key = serializer.serialize((Object)RedisServiceImpl.VOTE_ACTIVITY_KEY);
                byte[] field = serializer.serialize((Object)RedisServiceImpl.this.getVoteActivityKey(activityId));
                RedisSerializer redisSerializer = RedisServiceImpl.this.redisTemplate.getDefaultSerializer();
                byte[] value = connection.hGet(key, field);
                VoteCacheDto vcd = (VoteCacheDto)redisSerializer.deserialize(value);
                RedisServiceImpl.this.logger.info("[Find VoteCacheDto : {} ]", (Object)vcd);
                return vcd;
            }
        });
    }

    @Override
    public void setVoteActivityBase(final long activityId, final VoteCacheDto cacheDto) {
        this.redisTemplate.execute((RedisCallback)new RedisCallback<Object>(){

            public Object doInRedis(RedisConnection connection) throws DataAccessException {
                connection.select(6);
                RedisSerializer serializer = RedisServiceImpl.this.getRedisSerializer();
                byte[] key = serializer.serialize((Object)RedisServiceImpl.VOTE_ACTIVITY_KEY);
                byte[] field = serializer.serialize((Object)RedisServiceImpl.this.getVoteActivityKey(activityId));
                RedisSerializer redisSerializer = RedisServiceImpl.this.redisTemplate.getDefaultSerializer();
                byte[] value = redisSerializer.serialize((Object)cacheDto);
                connection.hSet(key, field, value);
                RedisServiceImpl.this.logger.info("[Redis] Update success. ActivityId=" + activityId);
                return null;
            }
        });
    }

    private String getVoteActivityKey(Long activityId) {
        StringBuilder sb = new StringBuilder();
        sb.append("VOTE").append("#").append(activityId);
        return sb.toString();
    }

    @Override
    public boolean addOrgEmailCount(final long orgId, final long activityId, final int templateTypeId, final EmailType emailType) {
        return (Boolean)this.redisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

            public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                connection.select(6);
                RedisSerializer serializer = RedisServiceImpl.this.getRedisSerializer();
                byte[] key = serializer.serialize((Object)RedisServiceImpl.emailCountKey);
                String fieldStr = RedisServiceImpl.this.getOrgKeyByDate(orgId, activityId, templateTypeId, emailType);
                byte[] field = serializer.serialize((Object)fieldStr);
                byte[] value = connection.hGet(key, field);
                if (value == null) {
                    connection.hSet(key, field, "1".getBytes());
                    RedisServiceImpl.this.logger.info("[Email] Init,key=" + fieldStr);
                    return true;
                }
                int count = Integer.parseInt((String)serializer.deserialize(value));
                if (count < EMAIL_COUNT_LIMIT) {
                    connection.hSet(key, field, String.valueOf(++count).getBytes());
                    RedisServiceImpl.this.logger.info("[Email] key=" + fieldStr + ";count=" + count);
                    return true;
                }
                return false;
            }
        });
    }

    private String getOrgKeyByDate(long orgId, long activityId, int typeId, EmailType emailType) {
        StringBuilder sb = new StringBuilder();
        sb.append(orgId).append("#").append(activityId).append("#").append(typeId).append("#").append(emailType.getCode()).append("#").append(DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd"));
        return sb.toString();
    }

    private String getDrawActivityKey(long activityId) {
        StringBuilder sb = new StringBuilder();
        sb.append("DRAW").append("#").append(activityId);
        return sb.toString();
    }

    @Override
    public void clearField(final String key, final String field) {
        this.redisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

            public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                connection.select(6);
                RedisSerializer serializer = RedisServiceImpl.this.getRedisSerializer();
                byte[] keyBytes = serializer.serialize((Object)key);
                byte[] fieldBytes = serializer.serialize((Object)field);
                Long ret = connection.hDel(keyBytes, (byte[][])new byte[][]{fieldBytes});
                log.info(" try to clear field : {} with key  : {} ,and return is : {} ", new Object[]{field, key, ret});
                return true;
            }
        });
    }

    @Override
    public void setchangeActivityStatus(final Long activityId, final Integer activityType, final Integer status) {
        this.redisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

            public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                connection.select(6);
                RedisSerializer serializer = RedisServiceImpl.this.getRedisSerializer();
                byte[] keyBytes = serializer.serialize((Object)RedisServiceImpl.ACTIVITY_VISITY_STATUS_KEY);
                String format = "%s_%s";
                String fieldStr = String.format(format, activityType, activityId);
                byte[] fieldBytes = serializer.serialize((Object)fieldStr);
                RedisSerializer redisSerializer = RedisServiceImpl.this.redisTemplate.getDefaultSerializer();
                byte[] value = redisSerializer.serialize((Object)status);
                connection.hSet(keyBytes, fieldBytes, value);
                log.info("success to changeActivityStatus to : {} ", (Object)status);
                return true;
            }
        });
    }

    @Override
    public Integer getActivityStatus(final Long activityId, final Integer activityType) {
        return (Integer)this.redisTemplate.execute((RedisCallback)new RedisCallback<Integer>(){

            public Integer doInRedis(RedisConnection connection) throws DataAccessException {
                connection.select(6);
                RedisSerializer serializer = RedisServiceImpl.this.getRedisSerializer();
                byte[] keyBytes = serializer.serialize((Object)RedisServiceImpl.ACTIVITY_VISITY_STATUS_KEY);
                String format = "%s_%s";
                String fieldStr = String.format(format, activityType, activityId);
                byte[] fieldBytes = serializer.serialize((Object)fieldStr);
                byte[] hGet = connection.hGet(keyBytes, fieldBytes);
                RedisSerializer redisSerializer = RedisServiceImpl.this.redisTemplate.getDefaultSerializer();
                Integer status = (Integer)redisSerializer.deserialize(hGet);
                log.info("success to changeActivityStatus to : {} ", (Object)status);
                return status;
            }
        });
    }

    @Override
    public RedisTemplate<String, Object> getRedisTemplate() {
        return this.redisTemplate;
    }

    @Override
    public Boolean setNXKey(final String key, final Object valueObj) {
        return (Boolean)this.redisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

            public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                RedisSerializer redisSerializer = RedisServiceImpl.this.redisTemplate.getDefaultSerializer();
                byte[] value = redisSerializer.serialize(valueObj);
                Boolean setNX = connection.setNX(key.getBytes(), value);
                return setNX;
            }
        });
    }

    @Override
    public void setKey(final String key, final Object valueObj) {
        this.redisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

            public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                RedisSerializer redisSerializer = RedisServiceImpl.this.redisTemplate.getDefaultSerializer();
                byte[] value = redisSerializer.serialize(valueObj);
                connection.set(key.getBytes(), value);
                return false;
            }
        });
    }

    @Override
    public <T> T getKeyValue(final String key) {
        return (T)this.redisTemplate.execute(new RedisCallback<T>(){

            public T doInRedis(RedisConnection connection) throws DataAccessException {
                byte[] bs = connection.get(key.getBytes());
                return RedisServiceImpl.this.redisTemplate.getDefaultSerializer().deserialize(bs);
            }
        });
    }
}

